/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.datatransfer;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.datatransfer.ExportUtil;
import org.eclipse.core.internal.runtime.XmlProcessorFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EclipseClasspath {
    protected List<String> srcDirs = new ArrayList<String>();
    protected List<String> classDirs = new ArrayList<String>();
    protected List<List<String>> inclusionLists = new ArrayList<List<String>>();
    protected List<List<String>> exclusionLists = new ArrayList<List<String>>();
    protected Map<String, String> variable2valueMap = new LinkedHashMap<String, String>();
    protected List<String> rawClassPathEntries = new ArrayList<String>();
    protected List<String> rawClassPathEntriesAbsolute = new ArrayList<String>();
    private final IJavaProject project;
    private static Map<String, IClasspathContainer> userLibraryCache = new HashMap<String, IClasspathContainer>();

    public EclipseClasspath(IJavaProject project) throws JavaModelException {
        this.project = project;
        this.handle(project.getRawClasspath());
    }

    public EclipseClasspath(IJavaProject project, ILaunchConfiguration conf, boolean bootstrap) throws CoreException {
        this.project = project;
        IRuntimeClasspathEntry[] runtimeEntries = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)conf);
        ArrayList<IClasspathEntry> classpathEntries = new ArrayList<IClasspathEntry>(runtimeEntries.length);
        IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray = runtimeEntries;
        int n = runtimeEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntimeClasspathEntry entry = iRuntimeClasspathEntryArray[n2];
            if (bootstrap && entry.getClasspathProperty() == 2 || !bootstrap && entry.getClasspathProperty() != 2) {
                if (entry.getClass().getName().equals("org.eclipse.jdt.internal.launching.VariableClasspathEntry")) {
                    e = this.convertVariableClasspathEntry(entry);
                    if (e != null) {
                        classpathEntries.add(e);
                    }
                } else if (entry.getClass().getName().equals("org.eclipse.jdt.internal.launching.DefaultProjectClasspathEntry")) {
                    e = JavaCore.newProjectEntry((IPath)entry.getPath());
                    classpathEntries.add(e);
                } else if (entry.getClasspathEntry() != null) {
                    classpathEntries.add(entry.getClasspathEntry());
                }
            } else if (bootstrap && entry.toString().startsWith(JavaRuntime.JRE_CONTAINER)) {
                classpathEntries.add(entry.getClasspathEntry());
            } else if (bootstrap && entry.toString().startsWith("org.eclipse.jdt.USER_LIBRARY")) {
                classpathEntries.add(entry.getClasspathEntry());
            }
            ++n2;
        }
        IClasspathEntry[] entries = classpathEntries.toArray(new IClasspathEntry[classpathEntries.size()]);
        this.handle(entries);
    }

    private void handle(IClasspathEntry[] entries) throws JavaModelException {
        IClasspathEntry[] iClasspathEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            this.handleSources(entry);
            this.handleVariables(entry);
            this.handleJars(entry);
            this.handleLibraries(entry);
            this.handleProjects(entry);
            ++n2;
        }
    }

    private void handleSources(IClasspathEntry entry) throws JavaModelException {
        String projectRoot = ExportUtil.getProjectRoot(this.project);
        String defaultClassDir = this.project.getOutputLocation().toString();
        String defaultClassDirAbsolute = ExportUtil.resolve(this.project.getOutputLocation());
        if (entry.getContentKind() == 1 && entry.getEntryKind() == 3) {
            IPath srcDirPath = entry.getPath();
            IPath classDirPath = entry.getOutputLocation();
            String srcDir = this.handleLinkedResource(srcDirPath);
            ExportUtil.removeProjectRoot(srcDirPath != null ? srcDirPath.toString() : projectRoot, this.project.getProject());
            String classDir = ExportUtil.removeProjectRoot(classDirPath != null ? classDirPath.toString() : defaultClassDir, this.project.getProject());
            this.srcDirs.add(srcDir);
            this.classDirs.add(classDir);
            String classDirAbsolute = classDirPath != null ? ExportUtil.resolve(classDirPath) : defaultClassDirAbsolute;
            this.rawClassPathEntries.add(classDir);
            this.rawClassPathEntriesAbsolute.add(classDirAbsolute);
            ArrayList<String> inclusionList = new ArrayList<String>();
            IPath[] iPathArray = entry.getInclusionPatterns();
            int n = iPathArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPath inclusion = iPathArray[n2];
                if (inclusion != null) {
                    inclusionList.add(ExportUtil.removeProjectRoot(inclusion.toString(), this.project.getProject()));
                }
                ++n2;
            }
            this.inclusionLists.add(inclusionList);
            ArrayList<String> exclusionList = new ArrayList<String>();
            IPath[] iPathArray2 = entry.getExclusionPatterns();
            int n3 = iPathArray2.length;
            n = 0;
            while (n < n3) {
                IPath exclusion = iPathArray2[n];
                if (exclusion != null) {
                    exclusionList.add(ExportUtil.removeProjectRoot(exclusion.toString(), this.project.getProject()));
                }
                ++n;
            }
            this.exclusionLists.add(exclusionList);
        }
    }

    private String handleLinkedResource(IPath srcDirPath) {
        IFile file;
        String projectRoot = ExportUtil.getProjectRoot(this.project);
        Object srcDir = ExportUtil.removeProjectRoot(srcDirPath != null ? srcDirPath.toString() : projectRoot, this.project.getProject());
        if (srcDirPath == null) {
            return srcDir;
        }
        try {
            file = ResourcesPlugin.getWorkspace().getRoot().getFile(srcDirPath);
        }
        catch (IllegalArgumentException e) {
            return srcDir;
        }
        if (file.isLinked()) {
            String pathVariable = file.getRawLocation().segment(0).toString();
            URI pathVariableValue = file.getWorkspace().getPathVariableManager().getURIValue(pathVariable);
            if (pathVariableValue != null) {
                String pathVariableExtension = file.getRawLocation().removeFirstSegments(1).toString();
                String relativePath = ExportUtil.getRelativePath(pathVariableValue.toString(), projectRoot);
                this.variable2valueMap.put(pathVariable + ".pathvariable", relativePath);
                this.variable2valueMap.put((String)srcDir + ".link", "${" + pathVariable + ".pathvariable}/" + pathVariableExtension);
            } else {
                String relativePath = ExportUtil.getRelativePath(String.valueOf(file.getLocation()), projectRoot);
                this.variable2valueMap.put((String)srcDir + ".link", relativePath);
            }
            srcDir = "${" + (String)srcDir + ".link}";
        }
        return srcDir;
    }

    private void handleJars(IClasspathEntry entry) {
        if (entry.getContentKind() == 2 && entry.getEntryKind() == 1) {
            String jarFile = entry.getPath().toString();
            StringBuffer jarFileBuffer = new StringBuffer();
            StringBuffer jarFileAbsoluteBuffer = new StringBuffer();
            String jarFileAbsolute = ExportUtil.resolve(entry.getPath());
            if (jarFileAbsolute == null) {
                jarFileAbsolute = jarFile;
                if (this.handleSubProjectClassesDirectory(jarFile, jarFileBuffer, jarFileAbsoluteBuffer)) {
                    jarFile = jarFileBuffer.toString();
                    jarFileAbsolute = jarFileAbsoluteBuffer.toString();
                }
            }
            String jarFileOld = jarFile;
            if ((jarFile = ExportUtil.removeProjectRoot(jarFile, this.project.getProject())).equals(jarFileOld) && this.handleSubProjectClassesDirectory(jarFile, jarFileBuffer, jarFileAbsoluteBuffer)) {
                jarFile = jarFileBuffer.toString();
                jarFileAbsolute = jarFileAbsoluteBuffer.toString();
            }
            this.rawClassPathEntries.add(jarFile);
            this.rawClassPathEntriesAbsolute.add(jarFileAbsolute);
        }
    }

    private boolean handleSubProjectClassesDirectory(String file, StringBuffer jarFile, StringBuffer jarFileAbsolute) {
        int i;
        String subproject;
        IJavaProject javaproject;
        if (file != null && file.indexOf(47) == 0 && (javaproject = ExportUtil.getJavaProjectByName(subproject = file.substring(1, i = (i = file.indexOf(47, 1)) != -1 ? i : file.length()))) != null) {
            jarFile.setLength(0);
            jarFileAbsolute.setLength(0);
            String location = javaproject.getProject().getName() + ".location";
            jarFileAbsolute.append(ExportUtil.replaceProjectRoot(file, javaproject.getProject(), ExportUtil.getProjectRoot(javaproject)));
            jarFile.append(ExportUtil.replaceProjectRoot(file, javaproject.getProject(), "${" + location + "}"));
            String projectRoot = ExportUtil.getProjectRoot(this.project);
            String relativePath = ExportUtil.getRelativePath(ExportUtil.getProjectRoot(javaproject), projectRoot);
            this.variable2valueMap.put(location, relativePath);
            return true;
        }
        return false;
    }

    private void handleVariables(IClasspathEntry entry) {
        if (entry.getContentKind() == 1 && entry.getEntryKind() == 4) {
            IPath value;
            String e = entry.getPath().toString();
            int index = e.indexOf(47);
            if (index == -1) {
                index = e.indexOf(92);
            }
            String variable = e;
            String path = "";
            if (index != -1) {
                variable = e.substring(0, index);
                path = e.substring(index);
            }
            if ((value = JavaCore.getClasspathVariable((String)variable)) != null) {
                String projectRoot = ExportUtil.getProjectRoot(this.project);
                String relativePath = ExportUtil.getRelativePath(value.toString(), projectRoot);
                this.variable2valueMap.put(variable, relativePath);
            } else if (this.variable2valueMap.get(variable) == null) {
                this.variable2valueMap.put(variable, "");
            }
            this.rawClassPathEntriesAbsolute.add(String.valueOf(value) + path);
            this.rawClassPathEntries.add("${" + variable + "}" + path);
        }
    }

    private void handleLibraries(IClasspathEntry entry) throws JavaModelException {
        if (entry.getContentKind() == 1 && entry.getEntryKind() == 5) {
            Object refName;
            IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)this.project);
            if (container == null) {
                return;
            }
            String jar = entry.getPath().toString();
            if (jar.startsWith(JavaRuntime.JRE_CONTAINER)) {
                refName = "${jre.container}";
            } else if (jar.startsWith("org.eclipse.jdt.USER_LIBRARY")) {
                String libraryName = container.getDescription();
                refName = "${" + libraryName + ".userclasspath}";
                if (container.getKind() == 2) {
                    refName = "${" + libraryName + ".bootclasspath}";
                }
            } else {
                String libraryName = container.getDescription();
                refName = "${" + libraryName + ".libraryclasspath}";
            }
            userLibraryCache.put((String)refName, container);
            this.srcDirs.add((String)refName);
            this.classDirs.add((String)refName);
            this.rawClassPathEntries.add((String)refName);
            this.rawClassPathEntriesAbsolute.add((String)refName);
            this.inclusionLists.add(new ArrayList());
            this.exclusionLists.add(new ArrayList());
        }
    }

    private void handleProjects(IClasspathEntry entry) {
        if (entry.getContentKind() == 1 && entry.getEntryKind() == 2) {
            String subProjectRoot = entry.getPath().toString();
            IJavaProject subProject = ExportUtil.getJavaProject(subProjectRoot);
            if (subProject == null) {
                AntUIPlugin.log("project is not loaded in workspace: " + subProjectRoot, null);
                return;
            }
            String classpathRef = "${" + subProject.getProject().getName() + ".classpath}";
            this.srcDirs.add(classpathRef);
            this.classDirs.add(classpathRef);
            this.rawClassPathEntries.add(classpathRef);
            this.rawClassPathEntriesAbsolute.add(classpathRef);
            this.inclusionLists.add(new ArrayList());
            this.exclusionLists.add(new ArrayList());
        }
    }

    public static String getClasspath(IJavaProject project) throws CoreException {
        List<String> items = EclipseClasspath.getClasspathList(project);
        return ExportUtil.toString(items, File.pathSeparator);
    }

    public static List<String> getClasspathList(IJavaProject project) throws CoreException {
        String[] classpath = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)project);
        return Arrays.asList(classpath);
    }

    public static boolean isReference(String s) {
        return EclipseClasspath.isProjectReference(s) || EclipseClasspath.isUserLibraryReference(s) || EclipseClasspath.isUserSystemLibraryReference(s) || EclipseClasspath.isLibraryReference(s) || EclipseClasspath.isJreReference(s);
    }

    public static boolean isProjectReference(String s) {
        return s.startsWith("${") && s.endsWith(".classpath}");
    }

    public static IJavaProject resolveProjectReference(String s) {
        String name = ExportUtil.removePrefixAndSuffix(s, "${", ".classpath}");
        return ExportUtil.getJavaProjectByName(name);
    }

    public static boolean isUserLibraryReference(String s) {
        return s.startsWith("${") && s.endsWith(".userclasspath}");
    }

    public static boolean isUserSystemLibraryReference(String s) {
        return s.startsWith("${") && s.endsWith(".bootclasspath}");
    }

    public static boolean isLibraryReference(String s) {
        return s.startsWith("${") && s.endsWith(".libraryclasspath}");
    }

    public static boolean isJreReference(String s) {
        return s.equals("${jre.container}");
    }

    public static IClasspathContainer resolveUserLibraryReference(String s) {
        return userLibraryCache.get(s);
    }

    public static boolean isLinkedResource(String s) {
        return s.startsWith("${") && s.endsWith(".link}");
    }

    public static String getLinkedResourceName(String s) {
        return ExportUtil.removePrefixAndSuffix(s, "${", ".link}");
    }

    public String resolveLinkedResource(String s) {
        String suffix;
        String name = ExportUtil.removePrefixAndSuffix(s, "${", "}");
        String value = this.variable2valueMap.get(name);
        int i = value.indexOf(suffix = ".pathvariable}");
        if (i != -1) {
            String pathVariable = value.substring(0, i + suffix.length() - 1);
            pathVariable = ExportUtil.removePrefix(pathVariable, "${");
            return this.variable2valueMap.get(pathVariable) + value.substring(i + suffix.length());
        }
        return value;
    }

    private IClasspathEntry convertVariableClasspathEntry(IRuntimeClasspathEntry entry) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(entry.getMemento().getBytes());
            Document doc = XmlProcessorFactory.parseWithErrorOnDOCTYPE((InputStream)is);
            Element element = (Element)doc.getElementsByTagName("memento").item(0);
            Object variableString = element.getAttribute("variableString");
            ExportUtil.addVariable(this.variable2valueMap, (String)variableString, ExportUtil.getProjectRoot(this.project));
            variableString = ExportUtil.removePrefix((String)variableString, "${");
            int i = ((String)variableString).indexOf(125);
            if (i != -1) {
                variableString = ((String)variableString).substring(0, i) + ((String)variableString).substring(i + 1);
            }
            IPath path = IPath.fromOSString((String)variableString);
            return JavaCore.newVariableEntry((IPath)path, null, null);
        }
        catch (Exception e) {
            AntUIPlugin.log(e);
            return null;
        }
    }
}

