/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core.service;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import org.eclipse.egit.github.core.Key;
import org.eclipse.egit.github.core.User;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.GitHubRequest;
import org.eclipse.egit.github.core.client.PageIterator;
import org.eclipse.egit.github.core.client.PagedRequest;
import org.eclipse.egit.github.core.service.GitHubService;

public class UserService
extends GitHubService {
    public UserService() {
    }

    public UserService(GitHubClient client) {
        super(client);
    }

    public User getUser(String login) throws IOException {
        if (login == null) {
            throw new IllegalArgumentException("Login name cannot be null");
        }
        if (login.length() == 0) {
            throw new IllegalArgumentException("Login name cannot be empty");
        }
        GitHubRequest request = this.createRequest();
        StringBuilder uri = new StringBuilder("/users");
        uri.append('/').append(login);
        request.setUri(uri);
        request.setType((Type)((Object)User.class));
        return (User)this.client.get(request).getBody();
    }

    public User getUser() throws IOException {
        GitHubRequest request = this.createRequest();
        request.setUri("/user");
        request.setType((Type)((Object)User.class));
        return (User)this.client.get(request).getBody();
    }

    public User editUser(User user) throws IOException {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        return (User)this.client.post("/user", user, (Type)((Object)User.class));
    }

    protected PagedRequest<User> createFollowersRequest(int start, int size, String user) {
        PagedRequest<User> request = this.createPagedRequest(start, size);
        if (user == null) {
            request.setUri("/user/followers");
        } else {
            StringBuilder uri = new StringBuilder("/users");
            uri.append('/').append(user);
            uri.append("/followers");
            request.setUri(uri);
        }
        request.setType(new TypeToken<List<User>>(){}.getType());
        return request;
    }

    protected PagedRequest<User> createFollowingRequest(int start, int size, String user) {
        PagedRequest<User> request = this.createPagedRequest(start, size);
        if (user == null) {
            request.setUri("/user/following");
        } else {
            StringBuilder uri = new StringBuilder("/users");
            uri.append('/').append(user);
            uri.append("/following");
            request.setUri(uri);
        }
        request.setType(new TypeToken<List<User>>(){}.getType());
        return request;
    }

    public List<User> getFollowers() throws IOException {
        return this.getAll(this.pageFollowers());
    }

    public PageIterator<User> pageFollowers() {
        return this.pageFollowers(100);
    }

    public PageIterator<User> pageFollowers(int size) {
        return this.pageFollowers(1, size);
    }

    public PageIterator<User> pageFollowers(int start, int size) {
        PagedRequest<User> request = this.createFollowersRequest(start, size, null);
        return this.createPageIterator(request);
    }

    public List<User> getFollowers(String user) throws IOException {
        return this.getAll(this.pageFollowers(user));
    }

    public PageIterator<User> pageFollowers(String user) {
        return this.pageFollowers(user, 100);
    }

    public PageIterator<User> pageFollowers(String user, int size) {
        return this.pageFollowers(user, 1, size);
    }

    public PageIterator<User> pageFollowers(String user, int start, int size) {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user.length() == 0) {
            throw new IllegalArgumentException("User cannot be empty");
        }
        PagedRequest<User> request = this.createFollowersRequest(start, size, user);
        return this.createPageIterator(request);
    }

    public List<User> getFollowing() throws IOException {
        return this.getAll(this.pageFollowing());
    }

    public PageIterator<User> pageFollowing() {
        return this.pageFollowing(100);
    }

    public PageIterator<User> pageFollowing(int size) {
        return this.pageFollowing(1, size);
    }

    public PageIterator<User> pageFollowing(int start, int size) {
        PagedRequest<User> request = this.createFollowingRequest(start, size, null);
        return this.createPageIterator(request);
    }

    public List<User> getFollowing(String user) throws IOException {
        return this.getAll(this.pageFollowing(user));
    }

    public PageIterator<User> pageFollowing(String user) {
        return this.pageFollowing(user, 100);
    }

    public PageIterator<User> pageFollowing(String user, int size) {
        return this.pageFollowing(user, 1, size);
    }

    public PageIterator<User> pageFollowing(String user, int start, int size) {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user.length() == 0) {
            throw new IllegalArgumentException("User cannot be empty");
        }
        PagedRequest<User> request = this.createFollowingRequest(start, size, user);
        return this.createPageIterator(request);
    }

    public boolean isFollowing(String user) throws IOException {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user.length() == 0) {
            throw new IllegalArgumentException("User cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/user/following");
        uri.append('/').append(user);
        return this.check(uri.toString());
    }

    public void follow(String user) throws IOException {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user.length() == 0) {
            throw new IllegalArgumentException("User cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/user/following");
        uri.append('/').append(user);
        this.client.put(uri.toString());
    }

    public void unfollow(String user) throws IOException {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user.length() == 0) {
            throw new IllegalArgumentException("User cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/user/following");
        uri.append('/').append(user);
        this.client.delete(uri.toString());
    }

    public List<String> getEmails() throws IOException {
        PagedRequest request = this.createPagedRequest();
        request.setUri("/user/emails");
        request.setType(new TypeToken<List<String>>(){}.getType());
        return this.getAll(request);
    }

    public void addEmail(String ... emails) throws IOException {
        if (emails == null) {
            throw new IllegalArgumentException("Emails cannot be null");
        }
        if (emails.length == 0) {
            throw new IllegalArgumentException("Emails cannot be empty");
        }
        this.client.post("/user/emails", emails, null);
    }

    public void removeEmail(String ... emails) throws IOException {
        if (emails == null) {
            throw new IllegalArgumentException("Emails cannot be null");
        }
        if (emails.length == 0) {
            throw new IllegalArgumentException("Emails cannot be empty");
        }
        this.client.delete("/user/emails", emails);
    }

    public List<Key> getKeys() throws IOException {
        PagedRequest request = this.createPagedRequest();
        request.setUri("/user/keys");
        request.setType(new TypeToken<List<Key>>(){}.getType());
        return this.getAll(request);
    }

    public Key getKey(int id) throws IOException {
        GitHubRequest request = this.createRequest();
        StringBuilder uri = new StringBuilder("/user/keys");
        uri.append('/').append(id);
        request.setUri(uri);
        request.setType((Type)((Object)Key.class));
        return (Key)this.client.get(request).getBody();
    }

    public Key createKey(Key key) throws IOException {
        return (Key)this.client.post("/user/keys", key, (Type)((Object)Key.class));
    }

    public Key editKey(Key key) throws IOException {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        StringBuilder uri = new StringBuilder("/user/keys");
        uri.append('/').append(key.getId());
        return (Key)this.client.post(uri.toString(), key, (Type)((Object)Key.class));
    }

    public void deleteKey(int id) throws IOException {
        StringBuilder uri = new StringBuilder("/user/keys");
        uri.append('/').append(id);
        this.client.delete(uri.toString());
    }
}

