/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui.wizards;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractTaskRepositoryPageContribution {
    private final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();
    private final String title;
    private final String description;
    private TaskRepository repository;
    private String connectorKind;
    private String id;

    protected AbstractTaskRepositoryPageContribution(String title, String description) {
        this.title = title;
        this.description = description;
        this.id = "";
    }

    public void init(String connectorKind, TaskRepository repository) {
        this.connectorKind = connectorKind;
        this.repository = repository;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public abstract Control createControl(Composite var1);

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public abstract boolean isPageComplete();

    public abstract boolean canFlipToNextPage();

    public abstract IStatus validate();

    public abstract void applyTo(TaskRepository var1);

    protected void fireValidationRequired() {
        for (Listener l : this.listeners) {
            l.validationRequired(this);
        }
    }

    protected final TaskRepository getRepository() {
        return this.repository;
    }

    protected final String getConnectorKind() {
        return this.connectorKind;
    }

    void setId(String id) {
        Assert.isNotNull((Object)id);
        this.id = id;
    }

    public final String getId() {
        return this.id;
    }

    public boolean isEnabled() {
        return true;
    }

    public static interface Listener {
        public void validationRequired(AbstractTaskRepositoryPageContribution var1);
    }
}

