/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.html.internal;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.mylyn.wikitext.html.internal.SpanStrategy;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;

class CompositeSpanStrategy
implements SpanStrategy {
    private final List<SpanStrategy> delegates;

    CompositeSpanStrategy(List<SpanStrategy> delegates) {
        this.delegates = List.copyOf(delegates);
    }

    @Override
    public void beginSpan(DocumentBuilder builder, DocumentBuilder.SpanType type, Attributes attributes) {
        for (SpanStrategy strategy : this.delegates) {
            strategy.beginSpan(builder, type, attributes);
        }
    }

    @Override
    public void endSpan(DocumentBuilder builder) {
        for (SpanStrategy strategy : IntStream.range(0, this.delegates.size()).map(i -> this.delegates.size() - 1 - i).mapToObj(this.delegates::get).collect(Collectors.toList())) {
            strategy.endSpan(builder);
        }
    }
}

