/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.palette.customize;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.gef.internal.InternalImages;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteSeparator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

class PaletteLabelProvider
implements ILabelProvider,
IColorProvider {
    private Map<ImageDescriptor, Image> imageCache = new HashMap<ImageDescriptor, Image>();

    public PaletteLabelProvider(TreeViewer viewer) {
    }

    public Color getBackground(Object element) {
        return null;
    }

    private Image getCachedImage(ImageDescriptor descriptor) {
        return this.imageCache.computeIfAbsent(descriptor, dummy -> descriptor.createImage());
    }

    public Color getForeground(Object element) {
        PaletteEntry entry = (PaletteEntry)element;
        if (!entry.isVisible() || !entry.getParent().isVisible()) {
            return ColorConstants.lineForeground;
        }
        return null;
    }

    public Image getImage(Object element) {
        PaletteEntry entry = (PaletteEntry)element;
        ImageDescriptor descriptor = entry.getSmallIcon();
        if (descriptor == null) {
            if (entry instanceof PaletteContainer) {
                descriptor = InternalImages.DESC_FOLDER_OPEN;
            } else if (entry instanceof PaletteSeparator) {
                descriptor = InternalImages.DESC_SEPARATOR;
            } else {
                return null;
            }
        }
        return this.getCachedImage(descriptor);
    }

    public String getText(Object element) {
        return ((PaletteEntry)element).getLabel();
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        for (Image element : this.imageCache.values()) {
            element.dispose();
        }
        this.imageCache = null;
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

