/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.explorer.repositories.CDORepository;
import org.eclipse.emf.cdo.explorer.ui.DeleteElementsDialog;
import org.eclipse.emf.cdo.explorer.ui.handlers.AbstractRepositoryHandler;
import org.eclipse.emf.cdo.internal.explorer.AbstractElement;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class RepositoryDeleteHandler
extends AbstractRepositoryHandler {
    private List<CDOCheckout> checkouts;
    private boolean deleteCheckoutContents;
    private boolean deleteContents;

    public RepositoryDeleteHandler() {
        super(null, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void preRun(ExecutionEvent event) throws Exception {
        DeleteElementsDialog dialog;
        this.checkouts = new ArrayList<CDOCheckout>();
        this.deleteCheckoutContents = false;
        this.deleteContents = false;
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        AbstractElement[] repositories = AbstractElement.collect((Collection)this.elements);
        for (CDORepository repository : this.elements) {
            this.checkouts.addAll(Arrays.asList(repository.getCheckouts()));
        }
        int size = this.checkouts.size();
        if (size != 0) {
            Object message;
            String plural = size == 1 ? "" : "s";
            Object object = message = size == 1 ? "is 1" : "are " + size;
            if (!MessageDialog.openQuestion((Shell)shell, (String)"Existing Checkouts", (String)("There " + (String)message + " existing checkout" + plural + ".\n\nAre you sure you want to delete the checkout" + plural + ", too?"))) {
                this.cancel();
                return;
            }
            DeleteElementsDialog dialog2 = new DeleteElementsDialog(shell, this.checkouts.toArray(new AbstractElement[size]));
            if (dialog2.open() != 0) {
                this.cancel();
                return;
            }
            this.deleteCheckoutContents = dialog2.isDeleteContents();
        }
        if ((dialog = new DeleteElementsDialog(shell, repositories)).open() == 0) {
            this.deleteContents = dialog.isDeleteContents();
            return;
        }
        this.cancel();
    }

    protected void doExecute(IProgressMonitor monitor) throws Exception {
        for (CDOCheckout checkout : this.checkouts) {
            checkout.delete(this.deleteCheckoutContents);
        }
        this.checkouts = null;
        for (CDORepository repository : this.elements) {
            repository.delete(this.deleteContents);
        }
    }
}

