/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.checkouts.actions;

import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.explorer.ui.checkouts.CDOCheckoutContentProvider;
import org.eclipse.emf.cdo.explorer.ui.checkouts.wizards.NewWizard;
import org.eclipse.emf.cdo.internal.ui.actions.TransactionalBackgroundAction;
import org.eclipse.emf.cdo.internal.ui.dialogs.SelectClassDialog;
import org.eclipse.emf.cdo.internal.ui.editor.CDOEditor;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.ui.shared.SharedIcons;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.action.CreateChildAction;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.ui.navigator.WizardActionGroup;
import org.eclipse.ui.wizards.IWizardCategory;
import org.eclipse.ui.wizards.IWizardDescriptor;
import org.eclipse.ui.wizards.IWizardRegistry;

public class NewActionProvider
extends CommonActionProvider
implements ISelectionChangedListener {
    private static final String NEW_MENU_NAME = "common.new.menu";
    private ICommonActionExtensionSite extensionSite;
    private CDOCheckoutContentProvider contentProvider;
    private ActionFactory.IWorkbenchAction showDlgAction;
    private WizardActionGroup newWizardActionGroup;
    private IWorkbenchPage page;
    private TreeViewer viewer;
    private Object selectedObject;

    public void init(ICommonActionExtensionSite extensionSite) {
        this.extensionSite = extensionSite;
        ICommonViewerSite viewSite = extensionSite.getViewSite();
        if (viewSite instanceof ICommonViewerWorkbenchSite) {
            this.page = ((ICommonViewerWorkbenchSite)viewSite).getPage();
            IWorkbenchWindow window = this.page.getWorkbenchWindow();
            this.showDlgAction = ActionFactory.NEW.create(window);
            CDOCheckoutContentProvider contentProvider = this.getContentProvider();
            WizardRegistryWrapper wrapperRegistry = new WizardRegistryWrapper(contentProvider);
            this.newWizardActionGroup = new WizardActionGroup(window, (IWizardRegistry)wrapperRegistry, "new", extensionSite.getContentService());
            this.viewer = (TreeViewer)extensionSite.getStructuredViewer();
            this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
            this.updateSelectedObject(this.viewer.getSelection());
        }
    }

    public void dispose() {
        if (this.viewer != null) {
            this.viewer.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (this.showDlgAction != null) {
            this.showDlgAction.dispose();
            this.showDlgAction = null;
        }
        super.dispose();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        this.updateSelectedObject(selection);
    }

    private void updateSelectedObject(ISelection selection) {
        IStructuredSelection ssel;
        if (selection instanceof IStructuredSelection && (ssel = (IStructuredSelection)selection).size() == 1) {
            this.selectedObject = ssel.getFirstElement();
            if (this.selectedObject instanceof CDOCheckout) {
                CDOCheckout checkout = (CDOCheckout)this.selectedObject;
                this.selectedObject = checkout.getRootObject();
            }
            return;
        }
        this.selectedObject = null;
    }

    public void fillContextMenu(IMenuManager menu) {
        if (this.viewer == null) {
            return;
        }
        CDOCheckout checkout = CDOExplorerUtil.getCheckout((Object)this.selectedObject);
        if (checkout == null || checkout.isReadOnly()) {
            return;
        }
        MenuManager submenu = new MenuManager("&New", NEW_MENU_NAME);
        this.fillNewWizardActions((IMenuManager)submenu);
        if (this.selectedObject instanceof CDOResource) {
            CDOResource resource = (CDOResource)this.selectedObject;
            if (!resource.isRoot()) {
                this.fillNewRootActions((IMenuManager)submenu, checkout, resource);
                submenu.add((IContributionItem)new Separator());
                submenu.add((IAction)new NewRootOtherAction(resource, checkout));
                submenu.add((IContributionItem)new Separator());
            }
        } else if (!(this.selectedObject instanceof CDOResourceNode) && this.selectedObject instanceof EObject) {
            this.fillNewChildActions((IMenuManager)submenu, checkout, (EObject)this.selectedObject);
        }
        submenu.add((IContributionItem)new Separator("additions"));
        menu.insertAfter("group.new", (IContributionItem)submenu);
    }

    /*
     * Unable to fully structure code
     */
    private void fillNewWizardActions(IMenuManager menu) {
        this.newWizardActionGroup.setContext(this.getContext());
        this.newWizardActionGroup.fillContextMenu(menu);
        newResourceFolderItem = null;
        newModelResourceItem = null;
        newBinaryFileItem = null;
        newTextFileItem = null;
        firstID = null;
        var11_8 = newWizardItems = menu.getItems();
        var10_9 = newWizardItems.length;
        var9_10 = 0;
        while (var9_10 < var10_9) {
            newWizardItem = var11_8[var9_10];
            if (!(newWizardItem instanceof ActionContributionItem)) ** GOTO lbl-1000
            action = ((ActionContributionItem)newWizardItem).getAction();
            if (!(action instanceof IPluginContribution)) ** GOTO lbl-1000
            pluginContribution = (IPluginContribution)action;
            id = pluginContribution.getLocalId();
            if ("org.eclipse.emf.cdo.explorer.ui.new.folder".equals(id)) {
                newResourceFolderItem = menu.remove(newWizardItem);
            } else if ("org.eclipse.emf.cdo.explorer.ui.new.resource".equals(id)) {
                newModelResourceItem = menu.remove(newWizardItem);
            } else if ("org.eclipse.emf.cdo.explorer.ui.new.resource.binary".equals(id)) {
                newBinaryFileItem = menu.remove(newWizardItem);
            } else if ("org.eclipse.emf.cdo.explorer.ui.new.resource.text".equals(id)) {
                newTextFileItem = menu.remove(newWizardItem);
            } else if ("Ecore Diagram".equals(action.getText())) {
                menu.remove(newWizardItem);
            } else if (firstID == null) {
                firstID = newWizardItem.getId();
            }
            ++var9_10;
        }
        if (firstID == null) {
            group = new Separator("cdo-new-wizards");
            menu.add((IContributionItem)group);
            firstID = group.getId();
        }
        if (newResourceFolderItem != null) {
            menu.insertBefore(firstID, newResourceFolderItem);
        }
        if (newModelResourceItem != null) {
            menu.insertBefore(firstID, newModelResourceItem);
        }
        if (newBinaryFileItem != null) {
            menu.insertBefore(firstID, newBinaryFileItem);
        }
        if (newTextFileItem != null) {
            menu.insertBefore(firstID, newTextFileItem);
        }
    }

    private void fillNewRootActions(IMenuManager menu, final CDOCheckout checkout, final CDOResource resource) {
        CDOPackageRegistry packageRegistry = resource.cdoView().getSession().getPackageRegistry();
        CDOEditor.NewRootMenuPopulator populator = new CDOEditor.NewRootMenuPopulator(packageRegistry){

            protected IAction createAction(EObject object) {
                ComposedAdapterFactory adapterFactory = NewActionProvider.this.getAdapterFactory(checkout);
                Object image = CDOEditor.getLabelImage((AdapterFactory)adapterFactory, (Object)object);
                ImageDescriptor imageDescriptor = ExtendedImageRegistry.getInstance().getImageDescriptor(image);
                return new NewRootAction(resource, checkout, object, imageDescriptor);
            }
        };
        populator.populateMenu(menu);
    }

    private void fillNewChildActions(IMenuManager menu, CDOCheckout checkout, EObject object) {
        ResourceSet resourceSet = checkout.getView().getResourceSet();
        ComposedAdapterFactory adapterFactory = this.getAdapterFactory(checkout);
        AdapterFactoryEditingDomain editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)new BasicCommandStack(), resourceSet);
        StructuredSelection selection = new StructuredSelection((Object)object);
        CDOObject cdoObject = CDOUtil.getCDOObject((EObject)object);
        Collection childDescriptors = editingDomain.getNewChildDescriptors((Object)object, null);
        for (Object childDescriptor : childDescriptors) {
            CreateChildAction delegate = new CreateChildAction((EditingDomain)editingDomain, (ISelection)selection, childDescriptor);
            String text = delegate.getText();
            String toolTipText = delegate.getToolTipText();
            ImageDescriptor imageDescriptor = delegate.getImageDescriptor();
            NewChildAction action = new NewChildAction(text, toolTipText, imageDescriptor, checkout, cdoObject, childDescriptor);
            menu.add((IAction)action);
        }
    }

    private ComposedAdapterFactory getAdapterFactory(CDOCheckout checkout) {
        CDOCheckoutContentProvider contentProvider = this.getContentProvider();
        return contentProvider.getStateManager().getState(checkout).getAdapterFactory();
    }

    private CDOCheckoutContentProvider getContentProvider() {
        if (this.contentProvider == null) {
            String viewerID = this.extensionSite.getContentService().getViewerId();
            this.contentProvider = CDOCheckoutContentProvider.getInstance(viewerID);
        }
        return this.contentProvider;
    }

    private abstract class AbstractNewAction
    extends TransactionalBackgroundAction {
        private CDOCheckout checkout;
        private EObject newObject;

        public AbstractNewAction(String text, String toolTipText, ImageDescriptor image, CDOCheckout checkout, CDOObject parent) {
            super(NewActionProvider.this.page, text, toolTipText, image, parent);
            this.checkout = checkout;
        }

        protected CDOTransaction openTransaction(CDOObject AbstractNewAction2) {
            if (this.checkout != null) {
                return this.checkout.openTransaction();
            }
            return null;
        }

        protected final void doRun(CDOTransaction transaction, CDOObject parent, IProgressMonitor monitor) throws Exception {
            StructuredSelection selection = new StructuredSelection((Object)CDOUtil.getEObject((EObject)parent));
            this.newObject = this.doRun(transaction, parent, (ISelection)selection);
        }

        protected abstract EObject doRun(CDOTransaction var1, CDOObject var2, ISelection var3);

        protected void postRun(CDOView view, CDOObject parent) {
            CDOCheckoutContentProvider contentProvider;
            EObject object;
            if (this.newObject != null && (object = view.getObject(this.newObject)) != null && (contentProvider = NewActionProvider.this.getContentProvider()) != null) {
                contentProvider.selectObjects(object);
            }
        }
    }

    private class NewChildAction
    extends AbstractNewAction {
        private final Object childDescriptor;

        public NewChildAction(String text, String toolTipText, ImageDescriptor image, CDOCheckout checkout, CDOObject parent, Object childDescriptor) {
            super(text, toolTipText, image, checkout, parent);
            this.childDescriptor = childDescriptor;
        }

        @Override
        protected EObject doRun(CDOTransaction transaction, CDOObject parent, ISelection selection) {
            ComposedAdapterFactory adapterFactory = CDOEditor.createAdapterFactory((boolean)true);
            try {
                CommandParameter parameter;
                Object value;
                BasicCommandStack commandStack = new BasicCommandStack();
                ResourceSet resourceSet = transaction.getResourceSet();
                AdapterFactoryEditingDomain editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)commandStack, resourceSet);
                CreateChildAction delegate = new CreateChildAction((EditingDomain)editingDomain, selection, this.childDescriptor);
                delegate.run();
                if (this.childDescriptor instanceof CommandParameter && (value = (parameter = (CommandParameter)this.childDescriptor).getValue()) instanceof EObject) {
                    EObject eObject = (EObject)value;
                    return eObject;
                }
                return null;
            }
            finally {
                adapterFactory.dispose();
            }
        }
    }

    private class NewRootAction
    extends AbstractNewAction {
        private final EObject object;

        public NewRootAction(CDOResource resource, CDOCheckout checkout, EObject object, ImageDescriptor image) {
            super(object.eClass().getName(), null, image, checkout, (CDOObject)resource);
            this.object = object;
        }

        @Override
        protected EObject doRun(CDOTransaction transaction, CDOObject resource, ISelection selection) {
            EList contents = ((CDOResource)resource).getContents();
            contents.add((Object)this.object);
            return this.object;
        }
    }

    private class NewRootOtherAction
    extends AbstractNewAction {
        private EObject object;

        public NewRootOtherAction(CDOResource resource, CDOCheckout checkout) {
            super("Other...", null, SharedIcons.getDescriptor((String)"obj16/EClass.gif"), checkout, (CDOObject)resource);
        }

        protected void preRun() throws Exception {
            SelectClassDialog dialog = new SelectClassDialog(NewActionProvider.this.page, "New Root Object", "Select a package and a class for the new root object.");
            if (dialog.open() == 0) {
                EClass eClass = dialog.getSelectedClass();
                this.object = EcoreUtil.create((EClass)eClass);
            } else {
                this.cancel();
            }
        }

        @Override
        protected EObject doRun(CDOTransaction transaction, CDOObject resource, ISelection selection) {
            EList contents = ((CDOResource)resource).getContents();
            contents.add((Object)this.object);
            return this.object;
        }
    }

    private static final class WizardDescriptorWrapper
    implements IWizardDescriptor {
        private final IWizardDescriptor delegate;
        private final CDOCheckoutContentProvider contentProvider;

        private WizardDescriptorWrapper(IWizardDescriptor delegate, CDOCheckoutContentProvider contentProvider) {
            this.delegate = delegate;
            this.contentProvider = contentProvider;
        }

        public String getId() {
            return this.delegate.getId();
        }

        public ImageDescriptor getImageDescriptor() {
            return this.delegate.getImageDescriptor();
        }

        public IStructuredSelection adaptedSelection(IStructuredSelection selection) {
            return this.delegate.adaptedSelection(selection);
        }

        public String getLabel() {
            return this.delegate.getLabel();
        }

        public <T> T getAdapter(Class<T> adapter) {
            return (T)this.delegate.getAdapter(adapter);
        }

        public String getDescription() {
            return this.delegate.getDescription();
        }

        public String[] getTags() {
            return this.delegate.getTags();
        }

        public IWorkbenchWizard createWizard() throws CoreException {
            IWorkbenchWizard wizard = this.delegate.createWizard();
            if (wizard instanceof NewWizard) {
                NewWizard newWizard = (NewWizard)wizard;
                newWizard.setContentProvider(this.contentProvider);
            }
            return wizard;
        }

        public ImageDescriptor getDescriptionImage() {
            return this.delegate.getDescriptionImage();
        }

        public String getHelpHref() {
            return this.delegate.getHelpHref();
        }

        public IWizardCategory getCategory() {
            return this.delegate.getCategory();
        }

        public boolean canFinishEarly() {
            return this.delegate.canFinishEarly();
        }

        public boolean hasPages() {
            return this.delegate.hasPages();
        }
    }

    private static final class WizardRegistryWrapper
    implements IWizardRegistry {
        private static final IWizardRegistry DELEGATE = PlatformUI.getWorkbench().getNewWizardRegistry();
        private final CDOCheckoutContentProvider contentProvider;

        private WizardRegistryWrapper(CDOCheckoutContentProvider contentProvider) {
            this.contentProvider = contentProvider;
        }

        public IWizardCategory getRootCategory() {
            return DELEGATE.getRootCategory();
        }

        public IWizardDescriptor[] getPrimaryWizards() {
            return DELEGATE.getPrimaryWizards();
        }

        public IWizardDescriptor findWizard(String id) {
            IWizardDescriptor delegate = DELEGATE.findWizard(id);
            if (delegate != null) {
                return new WizardDescriptorWrapper(delegate, this.contentProvider);
            }
            return delegate;
        }

        public IWizardCategory findCategory(String id) {
            return DELEGATE.findCategory(id);
        }
    }
}

