/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.ui.editor.cheatsheet.simple;

import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.pde.internal.ua.ui.PDEUserAssistanceUIPlugin;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.CSAbstractEditor;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.simple.SimpleCSDefinitionPage;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.simple.SimpleCSFormOutlinePage;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.simple.SimpleCSInputContext;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.simple.SimpleCSInputContextManager;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.simple.SimpleCSSourcePage;
import org.eclipse.pde.internal.ui.editor.ISortableContentOutlinePage;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.FileStoreEditorInput;

public class SimpleCSEditor
extends CSAbstractEditor {
    protected String getEditorID() {
        return "org.eclipse.pde.ua.ui.simpleCheatSheetEditor";
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public String getContextIDForSaveAs() {
        return "simplecs-context";
    }

    protected void addEditorPages() {
        try {
            this.addPage((IFormPage)new SimpleCSDefinitionPage((FormEditor)this));
        }
        catch (PartInitException e) {
            PDEUserAssistanceUIPlugin.logException(e);
        }
        this.addSourcePage("simplecs-context");
    }

    protected ISortableContentOutlinePage createContentOutline() {
        return new SimpleCSFormOutlinePage((PDEFormEditor)this);
    }

    protected InputContextManager createInputContextManager() {
        return new SimpleCSInputContextManager((PDEFormEditor)this);
    }

    protected void createResourceContexts(InputContextManager contexts, IFileEditorInput input) {
        contexts.putContext((IEditorInput)input, (InputContext)new SimpleCSInputContext((PDEFormEditor)this, (IEditorInput)input, true));
        contexts.monitorFile(input.getFile());
    }

    protected void createStorageContexts(InputContextManager contexts, IStorageEditorInput input) {
        contexts.putContext((IEditorInput)input, (InputContext)new SimpleCSInputContext((PDEFormEditor)this, (IEditorInput)input, true));
    }

    protected void createSystemFileContexts(InputContextManager contexts, FileStoreEditorInput input) {
        try {
            IFileStore store = EFS.getStore((URI)input.getURI());
            FileStoreEditorInput in = new FileStoreEditorInput(store);
            contexts.putContext((IEditorInput)in, (InputContext)new SimpleCSInputContext((PDEFormEditor)this, (IEditorInput)in, true));
        }
        catch (CoreException e) {
            PDEUserAssistanceUIPlugin.logException(e);
        }
    }

    public void editorContextAdded(InputContext context) {
        this.addSourcePage(context.getId());
    }

    protected InputContext getInputContext(Object object) {
        return this.fInputContextManager.findContext("simplecs-context");
    }

    public void contextRemoved(InputContext context) {
        this.close(false);
    }

    public void monitoredFileAdded(IFile monitoredFile) {
    }

    public boolean monitoredFileRemoved(IFile monitoredFile) {
        return true;
    }

    public ISelection getSelection() {
        IFormPage formPage = this.getActivePageInstance();
        if (formPage != null && formPage instanceof SimpleCSDefinitionPage) {
            return ((SimpleCSDefinitionPage)formPage).getSelection();
        }
        return super.getSelection();
    }

    protected String computeInitialPageId() {
        String firstPageId = super.computeInitialPageId();
        if (firstPageId == null) {
            firstPageId = "simpleCSPage";
        }
        return firstPageId;
    }

    protected PDESourcePage createSourcePage(PDEFormEditor editor, String title, String name, String contextId) {
        return new SimpleCSSourcePage(editor, title, name);
    }

    public boolean canCut(ISelection selection) {
        IFormPage page = this.getActivePageInstance();
        if (page instanceof PDEFormPage) {
            return ((PDEFormPage)page).canCut(selection);
        }
        return super.canCut(selection);
    }
}

