/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction.proposals;

import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.proposals.AddModuleRequiresCorrectionProposalCore;
import org.eclipse.jdt.ui.text.java.correction.ASTRewriteCorrectionProposalCore;

public class AddImportCorrectionProposalCore
extends ASTRewriteCorrectionProposalCore {
    public static final String JAVA_BASE = "java.base";
    private final String fTypeName;
    private final String fQualifierName;
    protected AddModuleRequiresCorrectionProposalCore fAdditionalProposal = null;

    public AddImportCorrectionProposalCore(String name, ICompilationUnit cu, int relevance, String qualifierName, String typeName, SimpleName node) {
        super(name, cu, ASTRewrite.create((AST)node.getAST()), relevance);
        this.fTypeName = typeName;
        this.fQualifierName = qualifierName;
        this.fAdditionalProposal = this.getAdditionalChangeCorrectionProposal();
    }

    public String getQualifiedTypeName() {
        return this.fQualifierName + "." + this.fTypeName;
    }

    public AddModuleRequiresCorrectionProposalCore getAdditionalProposal() {
        return this.fAdditionalProposal;
    }

    public AddModuleRequiresCorrectionProposalCore getAdditionalChangeCorrectionProposal() {
        ICompilationUnit cu = this.getCompilationUnit();
        AddModuleRequiresCorrectionProposalCore additionalChangeCorrectionProposal = null;
        IJavaProject currentJavaProject = cu.getJavaProject();
        if (currentJavaProject == null || !JavaModelUtil.is9OrHigher(currentJavaProject)) {
            return null;
        }
        IModuleDescription currentModuleDescription = null;
        try {
            currentModuleDescription = currentJavaProject.getModuleDescription();
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        if (currentModuleDescription == null) {
            return null;
        }
        ICompilationUnit currentModuleCompilationUnit = currentModuleDescription.getCompilationUnit();
        if (currentModuleCompilationUnit == null || !currentModuleCompilationUnit.exists()) {
            return null;
        }
        String qualifiedName = this.getQualifiedTypeName();
        List<IPackageFragment> packageFragments = AddModuleRequiresCorrectionProposalCore.getPackageFragmentsOfMatchingTypesImpl(qualifiedName, 0, (IJavaElement)currentJavaProject);
        IPackageFragment enclosingPackage = null;
        if (packageFragments.size() == 1) {
            enclosingPackage = packageFragments.get(0);
        }
        if (enclosingPackage != null) {
            IModuleDescription projectModule = null;
            if (enclosingPackage.isReadOnly()) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)enclosingPackage.getAncestor(3);
                projectModule = AddModuleRequiresCorrectionProposalCore.getModuleDescription((IJavaElement)root);
            } else {
                IJavaProject project = enclosingPackage.getJavaProject();
                projectModule = AddModuleRequiresCorrectionProposalCore.getModuleDescription((IJavaElement)project);
            }
            if (projectModule != null && (projectModule.exists() && !projectModule.equals(currentModuleDescription) || projectModule.isAutoModule()) && !JAVA_BASE.equals(projectModule.getElementName())) {
                String moduleName = projectModule.getElementName();
                Object[] args = new String[]{moduleName};
                String changeName = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_add_requires_module_info, args);
                String changeDescription = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_add_requires_module_description, args);
                additionalChangeCorrectionProposal = new AddModuleRequiresCorrectionProposalCore(moduleName, changeName, changeDescription, currentModuleCompilationUnit, this.getRelevance());
            }
        }
        return additionalChangeCorrectionProposal;
    }
}

