/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.manipulation.JavaManipulation;
import org.eclipse.jdt.internal.core.manipulation.CodeTemplateContext;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.corext.fix.UnimplementedCodeFixCore;
import org.eclipse.jdt.internal.ui.fix.AbstractMultiFix;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateException;

public class UnimplementedCodeCleanUpCore
extends AbstractMultiFix {
    public static final String MAKE_TYPE_ABSTRACT = "cleanup.make_type_abstract_if_missing_method";

    public UnimplementedCodeCleanUpCore() {
    }

    public UnimplementedCodeCleanUpCore(Map<String, String> settings) {
        super(settings);
    }

    @Override
    public String[] getStepDescriptions() {
        if (this.isEnabled("cleanup.add_missing_methods")) {
            return new String[]{MultiFixMessages.UnimplementedCodeCleanUp_AddUnimplementedMethods_description};
        }
        if (this.isEnabled(MAKE_TYPE_ABSTRACT)) {
            return new String[]{MultiFixMessages.UnimplementedCodeCleanUp_MakeAbstract_description};
        }
        return null;
    }

    @Override
    public String getPreview() {
        StringBuilder bld = new StringBuilder();
        if (this.isEnabled(MAKE_TYPE_ABSTRACT)) {
            bld.append("public abstract class Face implements IFace {\n");
        } else {
            bld.append("public class Face implements IFace {\n");
        }
        if (this.isEnabled("cleanup.add_missing_methods")) {
            boolean createComments = Boolean.parseBoolean(JavaManipulation.getPreference("org.eclipse.jdt.ui.javadoc", null));
            if (createComments) {
                bld.append(this.indent(this.getOverridingMethodComment(), "    "));
            }
            bld.append("    @Override\n");
            bld.append("    public void method() {\n");
            bld.append(this.indent(this.getMethodBody(), "        "));
            bld.append("    }\n");
            bld.append("}\n");
        } else {
            bld.append("}\n\n\n\n\n\n");
        }
        return bld.toString();
    }

    @Override
    public CleanUpRequirements getRequirements() {
        if (!this.isEnabled("cleanup.add_missing_methods") && !this.isEnabled(MAKE_TYPE_ABSTRACT)) {
            return super.getRequirements();
        }
        return new CleanUpRequirements(true, false, false, null);
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit) throws CoreException {
        IProblemLocation[] problemLocations = UnimplementedCodeCleanUpCore.convertProblems(unit.getProblems());
        return this.createFix(unit, problemLocations);
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit, IProblemLocation[] problems) throws CoreException {
        IProblemLocation[] problemLocations = UnimplementedCodeCleanUpCore.filter(problems, new int[]{67109264, 67109627});
        return UnimplementedCodeFixCore.createCleanUp(unit, this.isEnabled("cleanup.add_missing_methods"), this.isEnabled(MAKE_TYPE_ABSTRACT), problemLocations);
    }

    @Override
    public boolean canFix(ICompilationUnit compilationUnit, IProblemLocation problem) {
        int id = problem.getProblemId();
        if (id == 67109264 || id == 67109627) {
            return this.isEnabled("cleanup.add_missing_methods") || this.isEnabled(MAKE_TYPE_ABSTRACT);
        }
        return false;
    }

    @Override
    public int computeNumberOfFixes(CompilationUnit compilationUnit) {
        if (!this.isEnabled("cleanup.add_missing_methods") && !this.isEnabled(MAKE_TYPE_ABSTRACT)) {
            return 0;
        }
        IProblemLocation[] locations = UnimplementedCodeCleanUpCore.filter(UnimplementedCodeCleanUpCore.convertProblems(compilationUnit.getProblems()), new int[]{67109264, 67109627});
        HashSet<ASTNode> types = new HashSet<ASTNode>();
        IProblemLocation[] iProblemLocationArray = locations;
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            IProblemLocation location = iProblemLocationArray[n2];
            ASTNode type = UnimplementedCodeFixCore.getSelectedTypeNode(compilationUnit, location);
            if (type != null) {
                types.add(type);
            }
            ++n2;
        }
        return types.size();
    }

    private String getOverridingMethodComment() {
        String templateName = "org.eclipse.jdt.ui.text.codetemplates.overridecomment";
        Template template = UnimplementedCodeCleanUpCore.getCodeTemplate(templateName);
        if (template == null) {
            return "";
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), null, "\n");
        context.setVariable("file_name", "Face.java");
        context.setVariable("package_name", "test");
        context.setVariable("project_name", "TestProject");
        context.setVariable("enclosing_type", "Face");
        context.setVariable("enclosing_method", "method");
        context.setVariable("return_type", "void");
        context.setVariable("see_to_overridden", "test.IFace#foo()");
        return this.evaluateTemplate(template, context);
    }

    private String getMethodBody() {
        String templateName = "org.eclipse.jdt.ui.text.codetemplates.methodbody";
        Template template = UnimplementedCodeCleanUpCore.getCodeTemplate(templateName);
        if (template == null) {
            return "";
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), null, "\n");
        context.setVariable("enclosing_method", "method");
        context.setVariable("enclosing_type", "Face");
        context.setVariable("body_statement", "");
        return this.evaluateTemplate(template, context);
    }

    private static Template getCodeTemplate(String id) {
        return JavaManipulation.getCodeTemplateStore().findTemplateById(id);
    }

    private String evaluateTemplate(Template template, CodeTemplateContext context) {
        TemplateBuffer buffer;
        try {
            buffer = context.evaluate(template);
        }
        catch (BadLocationException | TemplateException e) {
            JavaManipulationPlugin.log(e);
            return "";
        }
        if (buffer == null) {
            return "";
        }
        return buffer.getString();
    }

    private String indent(String code, String indent) {
        char[] codeArray;
        if (code.length() == 0) {
            return code;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(indent);
        char[] cArray = codeArray = code.toCharArray();
        int n = codeArray.length;
        int n2 = 0;
        while (n2 < n) {
            char element = cArray[n2];
            buf.append(element);
            if (element == '\n') {
                buf.append(indent);
            }
            ++n2;
        }
        buf.append("\n");
        return buf.toString();
    }
}

