/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.views;

import org.eclipse.help.ui.internal.views.EngineDescriptor;
import org.eclipse.help.ui.internal.views.EngineDescriptorManager;
import org.eclipse.help.ui.internal.views.ScopeSet;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class LocalScopeDialog
extends TrayDialog {
    private static final String ORG_ECLIPSE_HELP_UI_LOCAL_SEARCH = "org.eclipse.help.ui.localSearch";
    private final EngineDescriptorManager descManager;
    private final IPreferenceStore preferenceStore;
    private PreferencePage localHelpPage;
    private final ScopeSet scopeSet;

    public LocalScopeDialog(Shell parentShell, PreferenceManager manager, EngineDescriptorManager descManager, ScopeSet set) {
        super(parentShell);
        this.descManager = descManager;
        this.preferenceStore = set.getPreferenceStore();
        this.scopeSet = set;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        EngineDescriptor localSearchDesc = null;
        int i = 0;
        while (localSearchDesc == null && i < this.descManager.getDescriptors().length) {
            if (ORG_ECLIPSE_HELP_UI_LOCAL_SEARCH.equals(this.descManager.getDescriptors()[i].getEngineTypeId())) {
                localSearchDesc = this.descManager.getDescriptors()[i];
            }
            ++i;
        }
        String id = localSearchDesc.getEngineTypeId();
        this.localHelpPage = localSearchDesc.createRootPage(this.scopeSet.getName());
        this.localHelpPage.setTitle(localSearchDesc.getLabel() + "_" + id);
        this.localHelpPage.setImageDescriptor(localSearchDesc.getImageDescriptor());
        this.localHelpPage.setDescription(localSearchDesc.getDescription());
        this.localHelpPage.setPreferenceStore(this.preferenceStore);
        this.localHelpPage.createControl(parent);
        Control helpPageControl = this.localHelpPage.getControl();
        GridData layoutData = new GridData(1808);
        helpPageControl.setLayoutData((Object)layoutData);
        return helpPageControl;
    }

    protected void okPressed() {
        this.localHelpPage.performOk();
        super.okPressed();
    }
}

