/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.net.internal.proxy.linux;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import org.eclipse.core.internal.net.AbstractProxyProvider;
import org.eclipse.core.internal.net.Activator;
import org.eclipse.core.internal.net.Policy;
import org.eclipse.core.internal.net.ProxyData;
import org.eclipse.core.internal.net.StringUtil;
import org.eclipse.core.net.proxy.IProxyData;

public class ProxyProviderLinux
extends AbstractProxyProvider {
    private static LibGio fLibGio;
    private static Pointer proxySettings;
    private static Pointer httpProxySettings;
    private static Pointer httpsProxySettings;
    private static Pointer socksProxySettings;
    private static Pointer ftpProxySettings;
    private static final String ENABLE_GNOME = "org.eclipse.core.net.enableGnome";
    private static final String LIBRARY_NAME = "gio-2.0";
    private static boolean isGnomeLibLoaded;

    static {
        proxySettings = Pointer.NULL;
        httpProxySettings = Pointer.NULL;
        httpsProxySettings = Pointer.NULL;
        socksProxySettings = Pointer.NULL;
        ftpProxySettings = Pointer.NULL;
        isGnomeLibLoaded = false;
        String value = System.getProperty(ENABLE_GNOME);
        if ("".equals(value) || "true".equals(value)) {
            ProxyProviderLinux.initializeSettings();
        }
    }

    @Override
    public IProxyData[] select(URI uri) {
        int n;
        int n2;
        Object[] objectArray;
        String[] nonProxyHosts = this.getNonProxiedHosts();
        if (nonProxyHosts != null) {
            String host = uri.getHost();
            objectArray = nonProxyHosts;
            n2 = nonProxyHosts.length;
            n = 0;
            while (n < n2) {
                String nonProxyHost = objectArray[n];
                if (StringUtil.hostMatchesFilter(host, nonProxyHost)) {
                    return new IProxyData[0];
                }
                ++n;
            }
        }
        IProxyData[] proxies = new IProxyData[]{};
        if (uri.getScheme() != null) {
            IProxyData[] iProxyDataArray;
            ProxyData pd = this.getSystemProxyInfo(uri.getScheme());
            if (pd != null) {
                IProxyData[] iProxyDataArray2 = new IProxyData[1];
                iProxyDataArray = iProxyDataArray2;
                iProxyDataArray2[0] = pd;
            } else {
                iProxyDataArray = new IProxyData[]{};
            }
            proxies = iProxyDataArray;
        } else {
            proxies = this.getProxyData();
        }
        if (Policy.DEBUG) {
            Policy.debug("LinuxProxyProvider#select result for [" + String.valueOf(uri) + "]");
            objectArray = proxies;
            n2 = proxies.length;
            n = 0;
            while (n < n2) {
                Object proxy = objectArray[n];
                System.out.println("\t" + String.valueOf(proxy));
                ++n;
            }
        }
        return proxies;
    }

    @Override
    public IProxyData[] getProxyData() {
        String[] commonTypes = new String[]{"HTTP", "SOCKS", "HTTPS"};
        return this.getProxyForTypes(commonTypes);
    }

    private IProxyData[] getProxyForTypes(String[] types) {
        ArrayList<ProxyData> allData = new ArrayList<ProxyData>();
        String[] stringArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            ProxyData pd = this.getSystemProxyInfo(type);
            if (pd != null && pd.getHost() != null) {
                allData.add(pd);
            }
            ++n2;
        }
        return allData.toArray(new IProxyData[0]);
    }

    @Override
    public String[] getNonProxiedHosts() {
        String npEnv;
        if (Policy.DEBUG_SYSTEM_PROVIDERS) {
            Policy.debug("Getting no_proxy");
        }
        if ((npEnv = ProxyProviderLinux.getEnv("no_proxy")) != null) {
            String[] npHosts = StringUtil.split(npEnv, new String[]{","});
            int i = 0;
            while (i < npHosts.length) {
                npHosts[i] = npHosts[i].trim();
                ++i;
            }
            if (Policy.DEBUG_SYSTEM_PROVIDERS) {
                Policy.debug("Got Env no_proxy: " + npEnv);
                this.debugPrint(npHosts);
            }
            return npHosts;
        }
        if (isGnomeLibLoaded) {
            try {
                String[] npHosts = ProxyProviderLinux.getGSettingsNonProxyHosts();
                if (npHosts != null && npHosts.length > 0) {
                    if (Policy.DEBUG_SYSTEM_PROVIDERS) {
                        Policy.debug("Got Gnome no_proxy");
                        this.debugPrint(npHosts);
                    }
                    return npHosts;
                }
            }
            catch (UnsatisfiedLinkError e) {
                Activator.logError("Problem during accessing Gnome library", e);
            }
        }
        return new String[0];
    }

    protected ProxyData getSystemProxyInfo(String protocol) {
        ProxyData pd = null;
        String envName = null;
        if (Policy.DEBUG_SYSTEM_PROVIDERS) {
            Policy.debug("Getting proxies for: " + protocol);
        }
        try {
            protocol = protocol.toLowerCase(Locale.ENGLISH);
            envName = protocol + "_proxy";
            Object proxyEnv = ProxyProviderLinux.getEnv(envName);
            if (Policy.DEBUG_SYSTEM_PROVIDERS) {
                Policy.debug("Got proxyEnv: " + (String)proxyEnv);
            }
            if (proxyEnv != null) {
                int colonInd = ((String)proxyEnv).indexOf(":");
                if (colonInd != -1 && ((String)proxyEnv).length() > colonInd + 2 && !"//".equals(((String)proxyEnv).substring(colonInd + 1, colonInd + 3))) {
                    proxyEnv = "http://" + (String)proxyEnv;
                }
                URI uri = new URI((String)proxyEnv);
                pd = new ProxyData(protocol);
                pd.setHost(Objects.requireNonNull(uri.getHost(), "no host in " + (String)proxyEnv));
                int port = uri.getPort();
                if (port == -1) {
                    throw new IllegalStateException("no port in " + (String)proxyEnv);
                }
                pd.setPort(port);
                String userInfo = uri.getUserInfo();
                if (userInfo != null) {
                    String user = null;
                    String password = null;
                    int pwInd = userInfo.indexOf(58);
                    if (pwInd >= 0) {
                        user = userInfo.substring(0, pwInd);
                        password = userInfo.substring(pwInd + 1);
                    } else {
                        user = userInfo;
                    }
                    pd.setUserid(user);
                    pd.setPassword(password);
                }
                pd.setSource("LINUX_ENV");
                if (Policy.DEBUG_SYSTEM_PROVIDERS) {
                    Policy.debug("Got Env proxy: " + String.valueOf(pd));
                }
                return pd;
            }
        }
        catch (Exception e) {
            Activator.logError("Problem during accessing system variable: " + envName, e);
        }
        if (isGnomeLibLoaded) {
            try {
                pd = ProxyProviderLinux.getGSettingsProxyInfo(protocol);
                if (pd != null) {
                    if (Policy.DEBUG_SYSTEM_PROVIDERS) {
                        Policy.debug("Got Gnome proxy: " + String.valueOf(pd));
                    }
                    pd.setSource("LINUX_GNOME");
                    return pd;
                }
            }
            catch (UnsatisfiedLinkError e) {
                Activator.logError("Problem during accessing Gnome library", e);
            }
        }
        return null;
    }

    private static String getEnv(String env) {
        try {
            return System.getenv(env);
        }
        catch (Throwable t) {
            Properties props;
            block12: {
                String[] cmd = new String[]{"/bin/sh", "-c", "env | grep -i proxy"};
                props = new Properties();
                Process proc = null;
                try {
                    proc = Runtime.getRuntime().exec(cmd);
                    props.load(proc.getInputStream());
                }
                catch (IOException e) {
                    Activator.logError("Problem during accessing system variable: " + env, e);
                    if (proc != null) {
                        proc.destroy();
                    }
                    break block12;
                }
                catch (IllegalArgumentException e) {
                    try {
                        Activator.logError("Problem during accessing system variable: " + env, e);
                        break block12;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (proc != null) {
                            proc.destroy();
                        }
                    }
                }
                if (proc != null) {
                    proc.destroy();
                }
            }
            return props.getProperty(env);
        }
    }

    private void debugPrint(String[] strs) {
        int i = 0;
        while (i < strs.length) {
            System.out.println(i + ": " + strs[i]);
            ++i;
        }
    }

    private static void initializeSettings() {
        block3: {
            try {
                fLibGio = (LibGio)Native.load((String)LIBRARY_NAME, LibGio.class);
                proxySettings = fLibGio.g_settings_new("org.gnome.system.proxy");
                httpProxySettings = fLibGio.g_settings_new("org.gnome.system.proxy.http");
                httpsProxySettings = fLibGio.g_settings_new("org.gnome.system.proxy.https");
                socksProxySettings = fLibGio.g_settings_new("org.gnome.system.proxy.socks");
                ftpProxySettings = fLibGio.g_settings_new("org.gnome.system.proxy.ftp");
                isGnomeLibLoaded = true;
                if (Policy.DEBUG_SYSTEM_PROVIDERS) {
                    Policy.debug("Loaded " + System.mapLibraryName(LIBRARY_NAME) + " library");
                }
            }
            catch (UnsatisfiedLinkError e) {
                isGnomeLibLoaded = false;
                if (!Policy.DEBUG_SYSTEM_PROVIDERS) break block3;
                Policy.debug("Could not load library: " + System.mapLibraryName(LIBRARY_NAME));
            }
        }
    }

    protected static ProxyData getGSettingsProxyInfo(String protocol) {
        boolean reqAuth;
        int port;
        Pointer host;
        Pointer mode;
        if (protocol == null) {
            return null;
        }
        if (proxySettings == Pointer.NULL) {
            ProxyProviderLinux.initializeSettings();
        }
        if (!(mode = fLibGio.g_settings_get_string(proxySettings, "mode")).getString(0L).equalsIgnoreCase("manual")) {
            fLibGio.g_free(mode);
            return null;
        }
        fLibGio.g_free(mode);
        switch (protocol.toLowerCase()) {
            case "http": {
                host = fLibGio.g_settings_get_string(httpProxySettings, "host");
                port = fLibGio.g_settings_get_int(httpProxySettings, "port");
                break;
            }
            case "https": {
                host = fLibGio.g_settings_get_string(httpsProxySettings, "host");
                port = fLibGio.g_settings_get_int(httpsProxySettings, "port");
                break;
            }
            case "ftp": {
                host = fLibGio.g_settings_get_string(ftpProxySettings, "host");
                port = fLibGio.g_settings_get_int(ftpProxySettings, "port");
                break;
            }
            case "socks": {
                host = fLibGio.g_settings_get_string(socksProxySettings, "host");
                port = fLibGio.g_settings_get_int(socksProxySettings, "port");
                break;
            }
            default: {
                return null;
            }
        }
        ProxyData proxyData = new ProxyData(protocol);
        proxyData.setHost(host.getString(0L));
        fLibGio.g_free(host);
        proxyData.setPort(port);
        if (proxyData.getHost() == null || proxyData.getPort() == 0) {
            return null;
        }
        if (protocol.equalsIgnoreCase("http") && (reqAuth = fLibGio.g_settings_get_boolean(httpProxySettings, "use-authentication"))) {
            Pointer user = fLibGio.g_settings_get_string(httpProxySettings, "authentication-user");
            proxyData.setUserid(user.getString(0L));
            fLibGio.g_free(user);
            Pointer password = fLibGio.g_settings_get_string(httpProxySettings, "authentication-password");
            proxyData.setPassword(password.getString(0L));
            fLibGio.g_free(password);
        }
        return proxyData;
    }

    protected static String[] getGSettingsNonProxyHosts() {
        Pointer mode;
        if (proxySettings == Pointer.NULL) {
            ProxyProviderLinux.initializeSettings();
        }
        if (!(mode = fLibGio.g_settings_get_string(proxySettings, "mode")).getString(0L).equalsIgnoreCase("manual")) {
            fLibGio.g_free(mode);
            return null;
        }
        fLibGio.g_free(mode);
        PointerByReference npHostsArray = fLibGio.g_settings_get_strv(proxySettings, "ignore-hosts");
        String[] npHosts = npHostsArray.getPointer().getStringArray(0L);
        fLibGio.g_strfreev(npHostsArray);
        return npHosts;
    }

    private static interface LibGio
    extends Library {
        public Pointer g_settings_new(String var1);

        public boolean g_settings_get_boolean(Pointer var1, String var2);

        public Pointer g_settings_get_string(Pointer var1, String var2);

        public int g_settings_get_int(Pointer var1, String var2);

        public PointerByReference g_settings_get_strv(Pointer var1, String var2);

        public void g_strfreev(PointerByReference var1);

        public void g_free(Pointer var1);
    }
}

