/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.ui;

import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.IGlobalServiceProvider;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;

@ImplementedBy(value=Default.class)
public interface IRenameContextFactory {
    public IRenameElementContext createRenameElementContext(EObject var1, XtextEditor var2, ITextSelection var3, XtextResource var4);

    public static class Default
    implements IRenameContextFactory {
        @Inject
        private IGlobalServiceProvider globalServiceProvider;
        @Inject
        private IResourceServiceProvider resourceServiceProvider;

        @Override
        public IRenameElementContext createRenameElementContext(EObject targetElement, XtextEditor editor, ITextSelection selection, XtextResource resource) {
            IRenameElementContext externalRenameElementContext;
            if (!this.resourceServiceProvider.canHandle(EcoreUtil2.getPlatformResourceOrNormalizedURI((EObject)targetElement)) && (externalRenameElementContext = this.createExternalRenameElementContext(targetElement, editor, selection, resource)) != null) {
                return externalRenameElementContext;
            }
            return this.createLocalRenameElementContext(targetElement, editor, selection, resource);
        }

        protected IRenameElementContext createExternalRenameElementContext(EObject targetElement, XtextEditor editor, ITextSelection selection, XtextResource resource) {
            IRenameContextFactory contextFactory;
            if (!this.resourceServiceProvider.canHandle(EcoreUtil2.getPlatformResourceOrNormalizedURI((EObject)targetElement)) && (contextFactory = (IRenameContextFactory)this.globalServiceProvider.findService(targetElement, IRenameContextFactory.class)) != null) {
                return contextFactory.createRenameElementContext(targetElement, editor, selection, resource);
            }
            return null;
        }

        protected IRenameElementContext createLocalRenameElementContext(EObject targetElement, XtextEditor editor, ITextSelection selection, XtextResource resource) {
            URI targetElementURI = EcoreUtil2.getPlatformResourceOrNormalizedURI((EObject)targetElement);
            IRenameElementContext.Impl renameElementContext = new IRenameElementContext.Impl(targetElementURI, targetElement.eClass(), (IEditorPart)editor, (ISelection)selection, resource.getURI());
            return renameElementContext;
        }
    }
}

