/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.common.ui.internal.preferences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.ocl.common.OCLConstants;
import org.eclipse.ocl.common.internal.options.CodeGenerationMode;
import org.eclipse.ocl.common.internal.options.CommonOptions;
import org.eclipse.ocl.common.preferences.PreferenceableOption;
import org.eclipse.ocl.common.ui.internal.messages.CommonUIMessages;
import org.eclipse.ocl.common.ui.internal.preferences.AbstractProjectPreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class CommonProjectPreferencePage
extends AbstractProjectPreferencePage {
    static final String[] delegateExtensionPoints = new String[]{"invocation_delegate", "query_delegate", "setting_delegate", "validation_delegate"};
    protected static final String[][] CODE_GENERATION_MODES = new String[][]{{CommonUIMessages.CodeGenerationMode_Delegated, CodeGenerationMode.DELEGATED.toString()}, {CommonUIMessages.CodeGenerationMode_Compiled, CodeGenerationMode.GENERATED.toString()}};
    private static String[][] DEFAULT_DELEGATION_MODES = null;

    private static String[][] getDelegateURIs() {
        HashSet<String> uris = new HashSet<String>();
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        String pluginID = EcorePlugin.getPlugin().getBundle().getSymbolicName();
        String[] stringArray = delegateExtensionPoints;
        int n = delegateExtensionPoints.length;
        int n2 = 0;
        while (n2 < n) {
            String extensionPointID = stringArray[n2];
            IExtensionPoint point = pluginRegistry.getExtensionPoint(pluginID, extensionPointID);
            if (point != null) {
                IConfigurationElement[] elements = point.getConfigurationElements();
                int i = 0;
                while (i < elements.length) {
                    String uri = elements[i].getAttribute("uri");
                    if (uri != null && !"http://www.eclipse.org/emf/2002/Ecore/OCL".equals(uri)) {
                        uris.add(uri);
                    }
                    ++i;
                }
            }
            ++n2;
        }
        ArrayList uriList = new ArrayList(uris);
        Collections.sort(uriList);
        DEFAULT_DELEGATION_MODES = new String[uriList.size()][2];
        int i = 0;
        while (i < uris.size()) {
            CommonProjectPreferencePage.DEFAULT_DELEGATION_MODES[i][0] = (String)uriList.get(i);
            CommonProjectPreferencePage.DEFAULT_DELEGATION_MODES[i][1] = (String)uriList.get(i);
            ++i;
        }
        return DEFAULT_DELEGATION_MODES;
    }

    public CommonProjectPreferencePage() {
        super(OCLConstants.PLUGIN_ID, CommonUIMessages.Common_PageTitle);
    }

    @Override
    protected AbstractProjectPreferencePage createClonePage() {
        return new CommonProjectPreferencePage();
    }

    @Override
    protected void createFieldEditors(Composite fieldEditorParent, List<AbstractProjectPreferencePage.IFieldEditor> fields) {
        Label horizontalLine = new Label(fieldEditorParent, 258);
        horizontalLine.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        horizontalLine.setFont(fieldEditorParent.getFont());
        if (DEFAULT_DELEGATION_MODES == null) {
            DEFAULT_DELEGATION_MODES = CommonProjectPreferencePage.getDelegateURIs();
        }
        fields.add(new AbstractProjectPreferencePage.MyComboFieldEditor((PreferenceableOption<?>)CommonOptions.DEFAULT_DELEGATION_MODE, CommonUIMessages.DefaultDelegationMode, DEFAULT_DELEGATION_MODES, fieldEditorParent, "OCL embedded within an Ecore model can be executed using the Unified or Classic OCL functionality.\nThe (recommended) Unified functionality uses an Xtext-based parser and the normalized Pivot metamodel.\nThe (legacy) Classic functionality uses an LPG-based parser and an extended Ecore metamodel.\nThis preference takes effect when the 'virtual' http://www.eclipse.org/emf/2002/Ecore/OCL is used.\nhttp://www.eclipse.org/emf/2002/Ecore/OCL/LPG delegates to the Classic LPG-based engine.\nhttp://www.eclipse.org/emf/2002/Ecore/OCL/Pivot delegates to the Unified Xtext-based engine.\nhttp://www.eclipse.org/emf/2002/Ecore/OCL/Debug delegates to the Unified Xtext-based debugger."));
        fields.add(new AbstractProjectPreferencePage.MyComboFieldEditor((PreferenceableOption<?>)CommonOptions.CODE_GENERATION_MODE, CommonUIMessages.CodeGenerationMode, CODE_GENERATION_MODES, fieldEditorParent, "When EMF's generate model facility is used to generate Java code for an Ecore model, OCL embedded\nwithin the Ecore model may be realized directly as Java code avoiding incurring a longer compile-time\nand a larger class size in exchange for faster execution and avoiding the need for the overheads of OCL\nparsing at run-time. Alternatively the realization may encode the OCL as Java strings requiring EMF's\ndelegate functionality to be used to invoke the OCL parser and interpreter at run-time."));
    }
}

