/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.net4j;

import java.util.Map;
import org.eclipse.emf.cdo.eresource.CDOResourceFactory;
import org.eclipse.emf.cdo.internal.net4j.CDONet4jSessionConfigurationImpl;
import org.eclipse.emf.cdo.internal.net4j.FailoverCDOSessionConfigurationImpl;
import org.eclipse.emf.cdo.internal.net4j.ReconnectingCDOSessionConfigurationImpl;
import org.eclipse.emf.cdo.internal.net4j.bundle.OM;
import org.eclipse.emf.cdo.net4j.CDONet4jSession;
import org.eclipse.emf.cdo.net4j.CDONet4jSessionConfiguration;
import org.eclipse.emf.cdo.net4j.CDONet4jViewProvider;
import org.eclipse.emf.cdo.net4j.CDOSession;
import org.eclipse.emf.cdo.net4j.CDOSessionConfiguration;
import org.eclipse.emf.cdo.net4j.FailoverCDOSessionConfiguration;
import org.eclipse.emf.cdo.net4j.ReconnectingCDOSessionConfiguration;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOViewProvider;
import org.eclipse.emf.cdo.view.CDOViewProviderRegistry;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.om.OMPlatform;

public final class CDONet4jUtil {
    public static final String PROTOCOL_JVM = "cdo.net4j.jvm";
    public static final String PROTOCOL_TCP = "cdo.net4j.tcp";
    public static final String PROTOCOL_SSL = "cdo.net4j.ssl";
    public static final String PROTOCOL_WS = "cdo.net4j.ws";
    public static final String PROTOCOL_WSS = "cdo.net4j.wss";

    static {
        try {
            if (!OMPlatform.INSTANCE.isOSGiRunning()) {
                CDOUtil.registerResourceFactory(null);
                Map map = Resource.Factory.Registry.INSTANCE.getProtocolToFactoryMap();
                if (!map.containsKey(PROTOCOL_TCP)) {
                    map.put(PROTOCOL_TCP, CDOResourceFactory.INSTANCE);
                }
                if (!map.containsKey(PROTOCOL_SSL)) {
                    map.put(PROTOCOL_SSL, CDOResourceFactory.INSTANCE);
                }
                if (!map.containsKey(PROTOCOL_WS)) {
                    map.put(PROTOCOL_WS, CDOResourceFactory.INSTANCE);
                }
                if (!map.containsKey(PROTOCOL_WSS)) {
                    map.put(PROTOCOL_WSS, CDOResourceFactory.INSTANCE);
                }
                if (!map.containsKey(PROTOCOL_JVM)) {
                    map.put(PROTOCOL_JVM, CDOResourceFactory.INSTANCE);
                }
                int priority = 400;
                CDOViewProviderRegistry.INSTANCE.addViewProvider((CDOViewProvider)new CDONet4jViewProvider.JVM(priority));
                CDOViewProviderRegistry.INSTANCE.addViewProvider((CDOViewProvider)new CDONet4jViewProvider.TCP(priority));
                CDOViewProviderRegistry.INSTANCE.addViewProvider((CDOViewProvider)new CDONet4jViewProvider.SSL(priority));
                CDOViewProviderRegistry.INSTANCE.addViewProvider((CDOViewProvider)new CDONet4jViewProvider.WS(priority));
                CDOViewProviderRegistry.INSTANCE.addViewProvider((CDOViewProvider)new CDONet4jViewProvider.WSS(priority));
            }
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            throw ex;
        }
        catch (Error ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    private CDONet4jUtil() {
    }

    public static void prepareContainer(IManagedContainer container) {
        OM.BUNDLE.prepareContainer(container);
    }

    public static CDONet4jSessionConfiguration createNet4jSessionConfiguration() {
        return new CDONet4jSessionConfigurationImpl();
    }

    @Deprecated
    public static CDOSessionConfiguration createSessionConfiguration() {
        return (CDOSessionConfiguration)CDONet4jUtil.createNet4jSessionConfiguration();
    }

    public static ReconnectingCDOSessionConfiguration createReconnectingSessionConfiguration(String hostAndPort, String repoName, IManagedContainer container) {
        return new ReconnectingCDOSessionConfigurationImpl(hostAndPort, repoName, container);
    }

    public static FailoverCDOSessionConfiguration createFailoverSessionConfiguration(String monitorConnectorDescription, String repositoryGroup) {
        return CDONet4jUtil.createFailoverSessionConfiguration(monitorConnectorDescription, repositoryGroup, (IManagedContainer)IPluginContainer.INSTANCE);
    }

    public static FailoverCDOSessionConfiguration createFailoverSessionConfiguration(String monitorConnectorDescription, String repositoryGroup, IManagedContainer container) {
        return new FailoverCDOSessionConfigurationImpl(monitorConnectorDescription, repositoryGroup, container);
    }

    public static CDONet4jSession getNet4jSession(IManagedContainer container, String description) {
        return (CDONet4jSession)container.getElement("org.eclipse.emf.cdo.sessions", "cdo", description);
    }

    @Deprecated
    public static CDOSession getSession(IManagedContainer container, String description) {
        return (CDOSession)CDONet4jUtil.getNet4jSession(container, description);
    }
}

