/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    public static final String ID = "org.eclipse.jface.text";
    private static Activator activator;
    private ExecutorService executor;

    public void start(BundleContext context) {
        activator = this;
    }

    public void stop(BundleContext context) {
        activator = null;
        if (this.executor != null) {
            this.executor.shutdownNow();
            this.executor = null;
        }
    }

    public static ExecutorService getExecutor() {
        activator.createExecutor();
        return Activator.activator.executor;
    }

    private void createExecutor() {
        if (Activator.activator.executor != null) {
            return;
        }
        this.executor = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors(), 3L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
            AtomicInteger count = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "org.eclipse.jface.text-worker-" + this.count.getAndIncrement());
                t.setDaemon(true);
                return t;
            }
        });
    }
}

