/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;

class StyledTextHelper {
    StyledTextHelper() {
    }

    protected static StyledText createStyledTextLabel(Composite parent) {
        StyledText styledText = new StyledText(parent, 524362);
        styledText.setEditable(false);
        styledText.setCursor(parent.getDisplay().getSystemCursor(0));
        styledText.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getRole(AccessibleControlEvent e) {
                e.detail = 41;
            }
        });
        return styledText;
    }

    protected static StyleRange appendLink(StyledText styledText, String text, Object href, int style) {
        StyleRange range = StyledTextHelper.createDynamicForegroundRange(styledText, 0, 0, style);
        range.underline = true;
        range.underlineStyle = 4;
        StyledTextHelper.appendStyled(styledText, text, range);
        range.data = href;
        return range;
    }

    protected static StyleRange createDynamicForegroundRange(final StyledText styledText, int start, int length, int style) {
        Color currentForeground = styledText.getForeground();
        final StyleRange range = new StyleRange(start, length, currentForeground, null, style);
        styledText.addPaintListener(new PaintListener(currentForeground){
            Color color;
            {
                this.color = color;
            }

            public void paintControl(PaintEvent e) {
                if (this.color != null && (this.color.isDisposed() || !this.color.equals((Object)styledText.getForeground())) || this.color == null && styledText.getForeground() != null) {
                    range.foreground = this.color = styledText.getForeground();
                    styledText.setStyleRange(range);
                }
            }
        });
        return range;
    }

    protected static void appendStyled(StyledText styledText, String text, StyleRange style) {
        style.start = styledText.getCharCount();
        style.length = text.length();
        styledText.append(text);
        styledText.setStyleRange(style);
    }
}

