/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import java.io.File;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUi;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceCatalogSource;
import org.eclipse.epp.internal.mpc.ui.catalog.ResourceProvider;
import org.eclipse.epp.internal.mpc.ui.wizards.Messages;
import org.eclipse.equinox.internal.p2.discovery.AbstractCatalogSource;
import org.eclipse.equinox.internal.p2.discovery.model.Icon;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.DiscoveryResources;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class MarketplaceDiscoveryResources
extends DiscoveryResources {
    private final Display display;
    private final ResourceManager resourceManager;
    private final boolean disposeResourceManager;

    public MarketplaceDiscoveryResources(Display display) {
        super(display);
        this.display = display;
        ResourceManager existingResourceManager = this.retrieveResourceManager(display);
        this.disposeResourceManager = existingResourceManager == null;
        this.resourceManager = existingResourceManager == null ? new LocalResourceManager(JFaceResources.getResources((Display)display)) : existingResourceManager;
    }

    private ResourceManager retrieveResourceManager(Display display) {
        Field resourceManager = DiscoveryResources.class.getDeclaredField("resourceManager");
        try {
            resourceManager.setAccessible(true);
            ResourceManager resourceManager2 = (ResourceManager)resourceManager.get((Object)this);
            resourceManager.setAccessible(false);
            return resourceManager2;
        }
        catch (Throwable throwable) {
            try {
                resourceManager.setAccessible(false);
                throw throwable;
            }
            catch (Exception e) {
                MarketplaceClientUi.error(e);
                return null;
            }
        }
    }

    public void dispose() {
        super.dispose();
        if (this.disposeResourceManager) {
            this.resourceManager.dispose();
        }
    }

    public String getIconPath(Icon icon, int dimension, boolean fallback) {
        String imagePath;
        switch (dimension) {
            case 64: {
                imagePath = icon.getImage64();
                if (imagePath != null || !fallback) break;
            }
            case 48: {
                imagePath = icon.getImage48();
                if (imagePath != null || !fallback) break;
            }
            case 32: {
                imagePath = icon.getImage32();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return imagePath != null && imagePath.length() > 0 ? imagePath : null;
    }

    public void setImage(final ImageReceiver receiver, final AbstractCatalogSource discoverySource, final String imagePath, Image fallbackImage) {
        if (imagePath != null && imagePath.length() > 0) {
            URL localURL;
            MarketplaceCatalogSource marketplaceSource;
            ResourceProvider.ResourceFuture resource;
            Image image = null;
            if (discoverySource instanceof MarketplaceCatalogSource && (resource = (marketplaceSource = (MarketplaceCatalogSource)discoverySource).getResourceProvider().getResource(imagePath)) != null && (localURL = resource.getLocalURL()) != null) {
                try {
                    File imageFile = new File(new URI(localURL.getProtocol(), null, localURL.getPath(), null, null));
                    if (imageFile.exists()) {
                        image = this.safeCreateImage(imagePath, localURL);
                    }
                }
                catch (URISyntaxException e) {
                    this.logFailedLoadingImage(imagePath, localURL, e);
                }
            }
            if (image != null) {
                receiver.setImage(image);
            } else if (fallbackImage != null) {
                receiver.setImage(fallbackImage);
            }
            new Job(Messages.MarketplaceDiscoveryResources_retrievingImage){
                {
                    super($anonymous0);
                    this.setPriority(10);
                    this.setUser(false);
                    this.setSystem(true);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    if (!MarketplaceDiscoveryResources.this.display.isDisposed()) {
                        try {
                            URL resource;
                            if (imagePath != null && imagePath.length() > 0 && (resource = discoverySource.getResource(imagePath)) != null) {
                                MarketplaceDiscoveryResources.this.display.asyncExec(() -> {
                                    Image image1 = MarketplaceDiscoveryResources.this.safeCreateImage(imagePath, resource);
                                    if (image1 != null) {
                                        receiver.setImage(image1);
                                    }
                                });
                            }
                        }
                        catch (Exception e) {
                            MarketplaceClientUi.log(2, Messages.MarketplaceDiscoveryResources_FailedCreatingImage, imagePath, discoverySource.getId(), e);
                            return Status.CANCEL_STATUS;
                        }
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        } else if (fallbackImage != null) {
            receiver.setImage(fallbackImage);
        }
    }

    private Image safeCreateImage(String imagePath, URL url) {
        try {
            ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)url);
            Image image = this.resourceManager.createImage(descriptor);
            return image;
        }
        catch (DeviceResourceException ex) {
            this.logFailedLoadingImage(imagePath, url, (Exception)((Object)ex));
        }
        catch (SWTException ex) {
            this.logFailedLoadingImage(imagePath, url, (Exception)((Object)ex));
        }
        return null;
    }

    private void logFailedLoadingImage(String imagePath, URL url, Exception ex) {
        MarketplaceClientUi.log(2, Messages.MarketplaceDiscoveryResources_LoadImageError, imagePath, ex);
    }

    public static interface ImageReceiver {
        public void setImage(Image var1);
    }
}

