/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.merge.java.facade;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.codegen.merge.java.facade.FacadeHelper;
import org.eclipse.emf.codegen.merge.java.facade.JAbstractType;
import org.eclipse.emf.codegen.merge.java.facade.JCompilationUnit;
import org.eclipse.emf.codegen.merge.java.facade.JInitializer;
import org.eclipse.emf.codegen.merge.java.facade.JMethod;
import org.eclipse.emf.codegen.merge.java.facade.JNode;
import org.eclipse.emf.codegen.merge.java.facade.JPackage;

public abstract class AbstractJNode
implements JNode {
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected String qualifiedName;

    public abstract void dispose();

    public abstract boolean isDisposed();

    protected abstract Object getWrappedObject();

    public abstract void setFacadeHelper(FacadeHelper var1);

    public abstract FacadeHelper getFacadeHelper();

    @Override
    public String getQualifiedName() {
        if (this.qualifiedName == null) {
            this.qualifiedName = this.computeQualifiedName();
        }
        return this.qualifiedName;
    }

    protected String computeQualifiedName() {
        JNode parent = this.getParent();
        return parent == null || parent instanceof JCompilationUnit ? this.getName() : String.valueOf(parent.getQualifiedName()) + "." + this.getName();
    }

    protected String getName(JInitializer initializer) {
        JNode parent = initializer.getParent();
        if (parent != null) {
            int index = this.getFacadeHelper().getChildren(parent, JInitializer.class).indexOf(initializer);
            return String.valueOf(parent.getName()) + "." + index;
        }
        return null;
    }

    protected String computeQualifiedName(JInitializer initializer) {
        JNode parent = initializer.getParent();
        if (parent != null) {
            int index = this.getFacadeHelper().getChildren(parent, JInitializer.class).indexOf(initializer);
            return String.valueOf(parent.getQualifiedName()) + "." + index;
        }
        return null;
    }

    protected String computeQualifiedName(JAbstractType abstractType) {
        JNode parent = abstractType.getParent();
        if (parent instanceof JAbstractType) {
            return String.valueOf(parent.getQualifiedName()) + "." + abstractType.getName();
        }
        JPackage jPackage = this.getFacadeHelper().getPackage(this);
        return jPackage != null ? String.valueOf(jPackage.getName()) + "." + abstractType.getName() : abstractType.getName();
    }

    protected String computeQualifiedName(JMethod method) {
        StringBuilder result = new StringBuilder(this.getParent().getQualifiedName());
        result.append(".");
        if (method.isConstructor()) {
            result.append(this.getParent().getName());
        } else {
            result.append(this.getName());
        }
        result.append("(");
        String[] parameters = method.getParameterTypes();
        if (parameters != null) {
            int i = 0;
            while (i < parameters.length) {
                if (i != 0) {
                    result.append(", ");
                }
                result.append(parameters[i]);
                ++i;
            }
        }
        result.append(")");
        return result.toString();
    }

    @Override
    public List<JNode> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public int getFlags() {
        return 0;
    }
}

