/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.jet;

import java.util.Map;
import org.eclipse.emf.codegen.jet.JETConstantDataGenerator;

public class JETExtendedConstantDataGenerator
extends JETConstantDataGenerator {
    protected final Map<String, String> substitutions;
    protected Analzyer analyzer;

    public JETExtendedConstantDataGenerator(char[] characters, String label, Map<String, String> substitutions) {
        super(characters, label);
        this.substitutions = substitutions;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void analyze(Analzyer analyzer) {
        this.analyzer = analyzer;
        this.generateCharData();
        this.analyzer = null;
    }

    @Override
    protected boolean isConsumeWhitespace() {
        return true;
    }

    @Override
    protected String generateLiteral(StringBuilder literalBody) {
        if (this.analyzer == null) {
            String substitution = this.substitutions.get(literalBody.toString());
            return substitution == null ? super.generateLiteral(literalBody) : substitution;
        }
        this.analyzer.handleLiteral(literalBody.toString());
        return "";
    }

    @Override
    protected String generateNewLine(int offset, int length) {
        if (this.analyzer == null) {
            String substitution = this.substitutions.get(new String(this.characters, offset, length));
            return substitution == null ? super.generateNewLine(offset, length) : substitution;
        }
        this.analyzer.handleNewLine(new String(this.characters, offset, length));
        return "";
    }

    @Override
    protected JETExtendedConstantDataGenerator copy() {
        return new JETExtendedConstantDataGenerator(this.characters, this.label, this.substitutions);
    }

    public static interface Analzyer {
        public void handleNewLine(String var1);

        public void handleLiteral(String var1);
    }
}

