/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ecore.dependencies.ui;

import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class TableColumnSorter
extends ViewerComparator {
    private final TableViewer viewer;
    private int direction = 128;
    private TableColumn column;
    private int columnIndex;

    public TableColumnSorter(TableViewer viewer) {
        this.viewer = viewer;
        viewer.setComparator((ViewerComparator)this);
        Table table = viewer.getTable();
        TableColumn[] columns = table.getColumns();
        int i = 0;
        while (i < columns.length) {
            if (this.column == null) {
                this.column = columns[i];
                table.setSortColumn(this.column);
                table.setSortDirection(this.direction);
            }
            columns[i].addSelectionListener((SelectionListener)new ColumnListener(i));
            ++i;
        }
    }

    public final int compare(Viewer viewer, Object o1, Object o2) {
        String str2;
        String str1;
        ILabelProvider labelProvider = (ILabelProvider)this.viewer.getLabelProvider(this.columnIndex);
        if (labelProvider instanceof DelegatingStyledCellLabelProvider) {
            DelegatingStyledCellLabelProvider.IStyledLabelProvider styledLabelProvider = ((DelegatingStyledCellLabelProvider)labelProvider).getStyledStringProvider();
            str1 = styledLabelProvider.getStyledText(o1).getString();
            str2 = styledLabelProvider.getStyledText(o2).getString();
        } else {
            str1 = labelProvider.getText(o1);
            str2 = labelProvider.getText(o2);
        }
        if (str1 == null) {
            str1 = "";
        }
        if (str2 == null) {
            str2 = "";
        }
        int result = this.compareStrings(str1, str2);
        return this.direction == 128 ? result : -result;
    }

    protected int compareStrings(String str1, String str2) {
        return str1.compareTo(str2);
    }

    private final class ColumnListener
    extends SelectionAdapter {
        private final int index;

        public ColumnListener(int index) {
            this.index = index;
        }

        public void widgetSelected(SelectionEvent e) {
            TableColumn selectedColumn = (TableColumn)e.widget;
            if (TableColumnSorter.this.column == selectedColumn) {
                TableColumnSorter.this.direction = TableColumnSorter.this.direction == 128 ? 1024 : 128;
            } else {
                TableColumnSorter.this.direction = 128;
                TableColumnSorter.this.column = selectedColumn;
                TableColumnSorter.this.columnIndex = this.index;
            }
            Table table = TableColumnSorter.this.viewer.getTable();
            table.setSortColumn(selectedColumn);
            table.setSortDirection(TableColumnSorter.this.direction);
            TableColumnSorter.this.viewer.refresh();
        }
    }
}

