/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.edit.providers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.uml2.common.edit.command.ChangeCommand;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.edit.UMLEditPlugin;
import org.eclipse.uml2.uml.edit.providers.UMLItemPropertyDescriptor;
import org.eclipse.uml2.uml.util.UMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypedElementDefaultPropertyDescriptor
extends UMLItemPropertyDescriptor {
    public TypedElementDefaultPropertyDescriptor(AdapterFactory adapterFactory, ResourceLocator resourceLocator, String displayName, String description, EStructuralFeature feature, boolean isSettable, boolean multiLine, boolean sortChoices, Object staticImage, String category, String[] filterFlags) {
        super(adapterFactory, resourceLocator, displayName, description, feature, isSettable, multiLine, sortChoices, staticImage, category, filterFlags);
    }

    public Collection<?> getChoiceOfValues(Object object) {
        if (this.isDefaultableTypedElement(object)) {
            TypedElement element = (TypedElement)object;
            switch (this.getDefaultType(element)) {
                case BOOLEAN: {
                    return Arrays.asList(Boolean.toString(false), Boolean.toString(true));
                }
                case ENUMERATION: {
                    return this.getLiteralNames((Enumeration)element.getType());
                }
            }
            return super.getChoiceOfValues(object);
        }
        return super.getChoiceOfValues(object);
    }

    protected List<String> getLiteralNames(Enumeration enumeration) {
        ArrayList<String> result = new ArrayList<String>(enumeration.getOwnedLiterals().size());
        for (EnumerationLiteral literal : enumeration.getOwnedLiterals()) {
            String name = literal.getName();
            if (name == null) {
                name = UMLUtil.getQualifiedText((EObject)literal);
            }
            result.add(name);
        }
        return result;
    }

    protected EnumerationLiteral getLiteral(Enumeration enumeration, String name) {
        for (EnumerationLiteral literal : enumeration.getOwnedLiterals()) {
            String actualName = literal.getName();
            if (actualName == null) {
                actualName = UMLUtil.getQualifiedText((EObject)literal);
            }
            if (!UML2Util.safeEquals((Object)actualName, (Object)name)) continue;
            return literal;
        }
        return null;
    }

    public void setPropertyValue(Object object, Object value) {
        if (this.isDefaultableTypedElement(object)) {
            TypedElement element = (TypedElement)object;
            EditingDomain editingDomain = this.getEditingDomain(object);
            if (value == null) {
                this.resetPropertyValue(object);
            } else {
                switch (this.getDefaultType(element)) {
                    case BOOLEAN: {
                        if (editingDomain == null) {
                            this.setBooleanDefaultValue(element, Boolean.parseBoolean((String)value));
                            break;
                        }
                        editingDomain.getCommandStack().execute(this.createOperationCommand(editingDomain, (EObject)element, this.getSetBooleanDefaultValueOperation(element), Boolean.valueOf((String)value)));
                        break;
                    }
                    case INTEGER: {
                        try {
                            int intValue = Integer.parseInt((String)value);
                            if (editingDomain == null) {
                                this.setIntegerDefaultValue(element, intValue);
                                break;
                            }
                            editingDomain.getCommandStack().execute(this.createOperationCommand(editingDomain, (EObject)element, this.getSetIntegerDefaultValueOperation(element), intValue));
                        }
                        catch (NumberFormatException intValue) {}
                        break;
                    }
                    case REAL: {
                        try {
                            double doubleValue = Double.parseDouble((String)value);
                            if (editingDomain == null) {
                                this.setRealDefaultValue(element, doubleValue);
                                break;
                            }
                            editingDomain.getCommandStack().execute(this.createOperationCommand(editingDomain, (EObject)element, this.getSetRealDefaultValueOperation(element), doubleValue));
                        }
                        catch (NumberFormatException doubleValue) {}
                        break;
                    }
                    case UNLIMITED_NATURAL: {
                        try {
                            int naturalValue;
                            int n = naturalValue = "*".equals(value) ? -1 : Integer.parseInt((String)value);
                            if (editingDomain == null) {
                                this.setUnlimitedNaturalDefaultValue(element, naturalValue);
                                break;
                            }
                            editingDomain.getCommandStack().execute(this.createOperationCommand(editingDomain, (EObject)element, this.getSetUnlimitedNaturalDefaultValueOperation(element), naturalValue));
                        }
                        catch (NumberFormatException naturalValue) {}
                        break;
                    }
                    case ENUMERATION: {
                        EnumerationLiteral literal = this.getLiteral((Enumeration)element.getType(), (String)value);
                        if (literal == null) {
                            super.setPropertyValue(object, value);
                            break;
                        }
                        EReference defaultValueFeature = this.getDefaultValueFeature(element);
                        ValueSpecification existing = (ValueSpecification)element.eGet((EStructuralFeature)defaultValueFeature);
                        if (existing instanceof InstanceValue) {
                            InstanceValue instance = (InstanceValue)existing;
                            if (editingDomain == null) {
                                instance.setInstance((InstanceSpecification)literal);
                                break;
                            }
                            editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)editingDomain, (Object)instance, (Object)UMLPackage.Literals.INSTANCE_VALUE__INSTANCE, (Object)literal));
                            break;
                        }
                        InstanceValue instance = UMLFactory.eINSTANCE.createInstanceValue();
                        instance.setInstance((InstanceSpecification)literal);
                        if (editingDomain == null) {
                            this.setDefaultValue(element, (ValueSpecification)instance);
                            break;
                        }
                        editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)editingDomain, (Object)element, (Object)defaultValueFeature, (Object)instance));
                        break;
                    }
                    default: {
                        super.setPropertyValue(object, value);
                        break;
                    }
                }
            }
        } else {
            super.setPropertyValue(object, value);
        }
    }

    protected Command createOperationCommand(EditingDomain editingDomain, final EObject object, final EOperation operation, final Object ... argument) {
        Runnable op = new Runnable(){

            public void run() {
                try {
                    object.eInvoke(operation, (EList)new BasicEList.UnmodifiableEList(argument.length, argument));
                }
                catch (Exception e) {
                    UMLEditPlugin.INSTANCE.log(e);
                }
            }
        };
        return new ChangeCommand(editingDomain, op, UMLEditPlugin.INSTANCE.getString("_UI_SetCommand_label"), UMLEditPlugin.INSTANCE.getString("_UI_SetCommand_description"));
    }

    protected boolean isDefaultableTypedElement(Object object) {
        return object instanceof Property || object instanceof Parameter;
    }

    protected void setBooleanDefaultValue(TypedElement element, boolean value) {
        if (element instanceof Parameter) {
            ((Parameter)element).setBooleanDefaultValue(value);
        } else {
            ((Property)element).setBooleanDefaultValue(value);
        }
    }

    protected EOperation getSetBooleanDefaultValueOperation(TypedElement element) {
        return element instanceof Parameter ? UMLPackage.Literals.PARAMETER___SET_BOOLEAN_DEFAULT_VALUE__BOOLEAN : UMLPackage.Literals.PROPERTY___SET_BOOLEAN_DEFAULT_VALUE__BOOLEAN;
    }

    protected void setIntegerDefaultValue(TypedElement element, int value) {
        if (element instanceof Parameter) {
            ((Parameter)element).setIntegerDefaultValue(value);
        } else {
            ((Property)element).setIntegerDefaultValue(value);
        }
    }

    protected EOperation getSetIntegerDefaultValueOperation(TypedElement element) {
        return element instanceof Parameter ? UMLPackage.Literals.PARAMETER___SET_INTEGER_DEFAULT_VALUE__INT : UMLPackage.Literals.PROPERTY___SET_INTEGER_DEFAULT_VALUE__INT;
    }

    protected void setRealDefaultValue(TypedElement element, double value) {
        if (element instanceof Parameter) {
            ((Parameter)element).setRealDefaultValue(value);
        } else {
            ((Property)element).setRealDefaultValue(value);
        }
    }

    protected EOperation getSetRealDefaultValueOperation(TypedElement element) {
        return element instanceof Parameter ? UMLPackage.Literals.PARAMETER___SET_REAL_DEFAULT_VALUE__DOUBLE : UMLPackage.Literals.PROPERTY___SET_REAL_DEFAULT_VALUE__DOUBLE;
    }

    protected void setUnlimitedNaturalDefaultValue(TypedElement element, int value) {
        if (element instanceof Parameter) {
            ((Parameter)element).setUnlimitedNaturalDefaultValue(value);
        } else {
            ((Property)element).setUnlimitedNaturalDefaultValue(value);
        }
    }

    protected EOperation getSetUnlimitedNaturalDefaultValueOperation(TypedElement element) {
        return element instanceof Parameter ? UMLPackage.Literals.PARAMETER___SET_UNLIMITED_NATURAL_DEFAULT_VALUE__INT : UMLPackage.Literals.PROPERTY___SET_UNLIMITED_NATURAL_DEFAULT_VALUE__INT;
    }

    protected void setDefaultValue(TypedElement element, ValueSpecification value) {
        if (element instanceof Parameter) {
            ((Parameter)element).setDefaultValue(value);
        } else {
            ((Property)element).setDefaultValue(value);
        }
    }

    protected EReference getDefaultValueFeature(TypedElement element) {
        return element instanceof Parameter ? UMLPackage.Literals.PARAMETER__DEFAULT_VALUE : UMLPackage.Literals.PROPERTY__DEFAULT_VALUE;
    }

    protected PropertyType getDefaultType(TypedElement element) {
        Type type = element.getType();
        if (type instanceof Enumeration) {
            return PropertyType.ENUMERATION;
        }
        if (UMLUtil.isBoolean((Type)type)) {
            return PropertyType.BOOLEAN;
        }
        if (UMLUtil.isString((Type)type)) {
            return PropertyType.STRING;
        }
        if (UMLUtil.isInteger((Type)type)) {
            return PropertyType.INTEGER;
        }
        if (UMLUtil.isReal((Type)type)) {
            return PropertyType.REAL;
        }
        if (UMLUtil.isUnlimitedNatural((Type)type)) {
            return PropertyType.UNLIMITED_NATURAL;
        }
        return PropertyType.USER;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum PropertyType {
        USER,
        BOOLEAN,
        STRING,
        INTEGER,
        REAL,
        UNLIMITED_NATURAL,
        ENUMERATION;

    }
}

