/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.builds.core.spi;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.builds.core.IBuildPlan;

public class GetBuildsRequest {
    private Set<String> ids;
    private final Kind kind;
    private final IBuildPlan plan;
    private final Scope scope;

    public GetBuildsRequest(IBuildPlan plan, Collection<String> ids, Scope scope) {
        this(plan, Kind.SELECTED, Scope.FULL);
        Assert.isNotNull(ids);
        this.ids = Collections.unmodifiableSet(new HashSet<String>(ids));
    }

    public GetBuildsRequest(IBuildPlan plan, Kind kind) {
        this(plan, kind, Scope.FULL);
    }

    public GetBuildsRequest(IBuildPlan plan, Kind kind, Scope scope) {
        Assert.isNotNull((Object)((Object)kind));
        Assert.isNotNull((Object)plan);
        Assert.isNotNull((Object)((Object)scope));
        this.kind = kind;
        this.plan = plan;
        this.scope = scope;
    }

    public Set<String> getIds() {
        return this.ids;
    }

    public Kind getKind() {
        return this.kind;
    }

    public IBuildPlan getPlan() {
        return this.plan;
    }

    public Scope getScope() {
        return this.scope;
    }

    public static enum Kind {
        ALL,
        LAST,
        SELECTED;

    }

    public static enum Scope {
        FULL,
        HISTORY;

    }
}

