/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.builds.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.mylyn.builds.core.InternalTestCaseResult;

public enum TestCaseResult implements InternalTestCaseResult
{
    PASSED(1, "PASSED", "PASSED"),
    SKIPPED(2, "SKIPPED", "SKIPPED"),
    FAILED(3, "FAILED", "FAILED"),
    FIXED(4, "FIXED", "FIXED"),
    REGRESSION(5, "REGRESSION", "REGRESSION");

    public static final int PASSED_VALUE = 1;
    public static final int SKIPPED_VALUE = 2;
    public static final int FAILED_VALUE = 3;
    public static final int FIXED_VALUE = 4;
    public static final int REGRESSION_VALUE = 5;
    private static final TestCaseResult[] VALUES_ARRAY;
    public static final List<TestCaseResult> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TestCaseResult[]{PASSED, SKIPPED, FAILED, FIXED, REGRESSION};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TestCaseResult get(String literal) {
        TestCaseResult[] testCaseResultArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            TestCaseResult result = testCaseResultArray[n2];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static TestCaseResult getByName(String name) {
        TestCaseResult[] testCaseResultArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            TestCaseResult result = testCaseResultArray[n2];
            if (result.getName().equals(name)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static TestCaseResult get(int value) {
        switch (value) {
            case 1: {
                return PASSED;
            }
            case 2: {
                return SKIPPED;
            }
            case 3: {
                return FAILED;
            }
            case 4: {
                return FIXED;
            }
            case 5: {
                return REGRESSION;
            }
        }
        return null;
    }

    private TestCaseResult(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

