/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.hnsw;

import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.util.hnsw.IntToIntFunction;

public final class OrdinalTranslatedKnnCollector
extends KnnCollector.Decorator {
    private final IntToIntFunction vectorOrdinalToDocId;

    public OrdinalTranslatedKnnCollector(KnnCollector collector, IntToIntFunction vectorOrdinalToDocId) {
        super(collector);
        this.vectorOrdinalToDocId = vectorOrdinalToDocId;
    }

    @Override
    public boolean collect(int vectorId, float similarity) {
        return super.collect(this.vectorOrdinalToDocId.apply(vectorId), similarity);
    }

    @Override
    public TopDocs topDocs() {
        TopDocs td = super.topDocs();
        return new TopDocs(new TotalHits(this.visitedCount(), this.earlyTerminated() ? TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO : TotalHits.Relation.EQUAL_TO), td.scoreDocs);
    }
}

