/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.QueryTimeout;
import org.apache.lucene.search.AbstractKnnVectorQuery;
import org.apache.lucene.search.AcceptDocs;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.HnswQueueSaturationCollector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.KnnByteVectorQuery;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.search.KnnFloatVectorQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.SeededKnnVectorQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.VectorScorer;
import org.apache.lucene.search.knn.KnnCollectorManager;
import org.apache.lucene.search.knn.KnnSearchStrategy;

public class PatienceKnnVectorQuery
extends AbstractKnnVectorQuery {
    private static final double DEFAULT_SATURATION_THRESHOLD = 0.995;
    private final int patience;
    private final double saturationThreshold;
    private AbstractKnnVectorQuery delegate;

    public static PatienceKnnVectorQuery fromFloatQuery(KnnFloatVectorQuery knnQuery, double saturationThreshold, int patience) {
        return new PatienceKnnVectorQuery(knnQuery, saturationThreshold, patience);
    }

    public static PatienceKnnVectorQuery fromFloatQuery(KnnFloatVectorQuery knnQuery) {
        return new PatienceKnnVectorQuery(knnQuery, 0.995, PatienceKnnVectorQuery.defaultPatience(knnQuery));
    }

    public static PatienceKnnVectorQuery fromByteQuery(KnnByteVectorQuery knnQuery, double saturationThreshold, int patience) {
        return new PatienceKnnVectorQuery(knnQuery, saturationThreshold, patience);
    }

    public static PatienceKnnVectorQuery fromByteQuery(KnnByteVectorQuery knnQuery) {
        return new PatienceKnnVectorQuery(knnQuery, 0.995, PatienceKnnVectorQuery.defaultPatience(knnQuery));
    }

    public static PatienceKnnVectorQuery fromSeededQuery(SeededKnnVectorQuery knnQuery, double saturationThreshold, int patience) {
        return new PatienceKnnVectorQuery(knnQuery, saturationThreshold, patience);
    }

    public static PatienceKnnVectorQuery fromSeededQuery(SeededKnnVectorQuery knnQuery) {
        return new PatienceKnnVectorQuery(knnQuery, 0.995, PatienceKnnVectorQuery.defaultPatience(knnQuery));
    }

    PatienceKnnVectorQuery(AbstractKnnVectorQuery knnQuery, String field, int k, Query filter, KnnSearchStrategy searchStrategy, double saturationThreshold, int patience) {
        super(field, k, filter, searchStrategy);
        this.delegate = knnQuery;
        this.saturationThreshold = saturationThreshold;
        this.patience = patience;
    }

    public PatienceKnnVectorQuery(SeededKnnVectorQuery knnQuery, double saturationThreshold, int patience) {
        this(knnQuery, knnQuery.field, knnQuery.k, knnQuery.filter, knnQuery.searchStrategy, saturationThreshold, patience);
    }

    public PatienceKnnVectorQuery(KnnFloatVectorQuery knnQuery, double saturationThreshold, int patience) {
        this(knnQuery, knnQuery.field, knnQuery.k, knnQuery.filter, knnQuery.searchStrategy, saturationThreshold, patience);
    }

    public PatienceKnnVectorQuery(KnnByteVectorQuery knnQuery, double saturationThreshold, int patience) {
        this(knnQuery, knnQuery.field, knnQuery.k, knnQuery.filter, knnQuery.searchStrategy, saturationThreshold, patience);
    }

    private static int defaultPatience(AbstractKnnVectorQuery delegate) {
        return Math.max(7, (int)((double)delegate.k * 0.3));
    }

    @Override
    public String toString(String field) {
        return "PatienceKnnVectorQuery{saturationThreshold=" + this.saturationThreshold + ", patience=" + this.patience + ", delegate=" + String.valueOf(this.delegate) + "}";
    }

    @Override
    protected KnnCollectorManager getKnnCollectorManager(int k, IndexSearcher searcher) {
        return new PatienceCollectorManager(this.delegate.getKnnCollectorManager(k, searcher));
    }

    @Override
    protected TopDocs approximateSearch(LeafReaderContext context, AcceptDocs acceptDocs, int visitedLimit, KnnCollectorManager knnCollectorManager) throws IOException {
        return this.delegate.approximateSearch(context, acceptDocs, visitedLimit, knnCollectorManager);
    }

    @Override
    protected TopDocs exactSearch(LeafReaderContext context, DocIdSetIterator acceptIterator, QueryTimeout queryTimeout) throws IOException {
        return this.delegate.exactSearch(context, acceptIterator, queryTimeout);
    }

    @Override
    protected TopDocs mergeLeafResults(TopDocs[] perLeafResults) {
        return this.delegate.mergeLeafResults(perLeafResults);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        this.delegate.visit(visitor);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PatienceKnnVectorQuery that = (PatienceKnnVectorQuery)o;
        return this.saturationThreshold == that.saturationThreshold && this.patience == that.patience && Objects.equals(this.delegate, that.delegate);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.saturationThreshold, this.patience, this.delegate);
    }

    @Override
    public String getField() {
        return this.delegate.getField();
    }

    @Override
    public int getK() {
        return this.delegate.getK();
    }

    @Override
    public Query getFilter() {
        return this.delegate.getFilter();
    }

    @Override
    VectorScorer createVectorScorer(LeafReaderContext context, FieldInfo fi) throws IOException {
        return this.delegate.createVectorScorer(context, fi);
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        AbstractKnnVectorQuery abstractKnnVectorQuery = this.delegate;
        if (abstractKnnVectorQuery instanceof SeededKnnVectorQuery) {
            SeededKnnVectorQuery seededKnnVectorQuery = (SeededKnnVectorQuery)abstractKnnVectorQuery;
            this.delegate = new SeededKnnVectorQuery(seededKnnVectorQuery.delegate, seededKnnVectorQuery.seed, seededKnnVectorQuery.createSeedWeight(indexSearcher), this.delegate.field, this.delegate.k, this.delegate.filter, this.delegate.searchStrategy);
        }
        return super.rewrite(indexSearcher);
    }

    class PatienceCollectorManager
    implements KnnCollectorManager {
        final KnnCollectorManager knnCollectorManager;

        PatienceCollectorManager(KnnCollectorManager knnCollectorManager) {
            this.knnCollectorManager = knnCollectorManager;
        }

        @Override
        public KnnCollector newCollector(int visitLimit, KnnSearchStrategy searchStrategy, LeafReaderContext ctx) throws IOException {
            return new HnswQueueSaturationCollector(this.knnCollectorManager.newCollector(visitLimit, searchStrategy, ctx), PatienceKnnVectorQuery.this.saturationThreshold, PatienceKnnVectorQuery.this.patience);
        }

        @Override
        public KnnCollector newOptimisticCollector(int visitLimit, KnnSearchStrategy searchStrategy, LeafReaderContext ctx, int k) throws IOException {
            if (this.knnCollectorManager.isOptimistic()) {
                return new HnswQueueSaturationCollector(this.knnCollectorManager.newOptimisticCollector(visitLimit, searchStrategy, ctx, k), PatienceKnnVectorQuery.this.saturationThreshold, PatienceKnnVectorQuery.this.patience);
            }
            return null;
        }

        @Override
        public boolean isOptimistic() {
            return this.knnCollectorManager.isOptimistic();
        }
    }
}

