/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.shared.target;

import java.net.URI;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.p2.metadata.TranslationSupport;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.NameVersionDescriptor;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.core.target.TargetFeature;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.target.DirectoryBundleContainer;
import org.eclipse.pde.internal.core.target.FeatureBundleContainer;
import org.eclipse.pde.internal.core.target.IUBundleContainer;
import org.eclipse.pde.internal.core.target.ProfileBundleContainer;
import org.eclipse.pde.internal.core.target.TargetDefinition;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.shared.target.IUContentProvider;
import org.eclipse.pde.internal.ui.shared.target.Messages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class StyledBundleLabelProvider
extends StyledCellLabelProvider
implements ILabelProvider {
    private boolean fShowVersion = true;
    private boolean fAppendResolvedVariables = false;
    private final TranslationSupport fTranslations = TranslationSupport.getInstance();

    public StyledBundleLabelProvider(boolean showVersion, boolean appendResolvedVariables) {
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
        this.fShowVersion = showVersion;
        this.fAppendResolvedVariables = appendResolvedVariables;
    }

    public void dispose() {
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
        super.dispose();
    }

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        StyledString styledString = this.getStyledString(element);
        cell.setText(styledString.toString());
        cell.setStyleRanges(styledString.getStyleRanges());
        cell.setImage(this.getImage(element));
        super.update(cell);
    }

    protected StyledString getStyledString(Object element) {
        return Optional.ofNullable((DelegatingStyledCellLabelProvider.IStyledLabelProvider)Adapters.adapt((Object)element, DelegatingStyledCellLabelProvider.IStyledLabelProvider.class)).map(styleProvider -> styleProvider.getStyledText(element)).or(() -> Optional.ofNullable((ILabelProvider)Adapters.adapt((Object)element, ILabelProvider.class)).map(provider -> {
            if (provider instanceof StyledBundleLabelProvider) {
                StyledBundleLabelProvider bundleLabelProvider = (StyledBundleLabelProvider)((Object)((Object)provider));
                return bundleLabelProvider.getInternalStyledString(element);
            }
            String text = provider.getText(element);
            if (text == null) {
                return null;
            }
            StyledString styledString = new StyledString(text);
            if (element instanceof ITargetLocation) {
                ITargetLocation location = (ITargetLocation)element;
                this.appendBundleCount(styledString, location);
            }
            return styledString;
        })).orElseGet(() -> this.getInternalStyledString(element));
    }

    private StyledString getInternalStyledString(Object element) {
        StyledString styledString = new StyledString();
        if (element instanceof BundleInfo) {
            BundleInfo info = (BundleInfo)element;
            this.appendBundleInfo(styledString, info);
        } else if (element instanceof NameVersionDescriptor) {
            NameVersionDescriptor descriptor = (NameVersionDescriptor)element;
            this.appendBundleInfo(styledString, new BundleInfo(descriptor.getId(), descriptor.getVersion(), null, -1, false));
        } else if (element instanceof TargetBundle) {
            TargetBundle bundle = (TargetBundle)element;
            IStatus status = bundle.getStatus();
            if (status.isOK()) {
                this.appendBundleInfo(styledString, bundle.getBundleInfo());
            } else {
                BundleInfo bundleInfo = bundle.getBundleInfo();
                if (bundleInfo != null && bundleInfo.getSymbolicName() != null) {
                    this.appendBundleInfo(styledString, bundleInfo);
                    styledString.append(' ');
                }
                styledString.append(status.getMessage());
            }
        } else if (element instanceof IStatus) {
            IStatus status = (IStatus)element;
            styledString.append(status.getMessage());
        } else if (element instanceof IPath) {
            IPath path = (IPath)element;
            styledString.append(path.removeFirstSegments(1).toString());
        } else if (element instanceof TargetFeature) {
            TargetFeature feature = (TargetFeature)element;
            this.appendBundleInfo(styledString, new BundleInfo(feature.getId(), feature.getVersion(), null, -1, false));
        } else if (element instanceof FeatureBundleContainer) {
            FeatureBundleContainer container = (FeatureBundleContainer)element;
            styledString.append(container.getFeatureId());
            String version = container.getFeatureVersion();
            if (version != null) {
                styledString.append(' ');
                styledString.append('[', StyledString.QUALIFIER_STYLER);
                styledString.append(version, StyledString.QUALIFIER_STYLER);
                styledString.append(']', StyledString.QUALIFIER_STYLER);
            }
            if (this.fAppendResolvedVariables) {
                this.appendLocation(styledString, (ITargetLocation)container, true);
            }
            this.appendLocation(styledString, (ITargetLocation)container, false);
            this.appendBundleCount(styledString, (ITargetLocation)container);
        } else if (element instanceof DirectoryBundleContainer) {
            DirectoryBundleContainer container = (DirectoryBundleContainer)element;
            try {
                styledString.append(container.getLocation(false));
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            if (this.fAppendResolvedVariables) {
                this.appendLocation(styledString, (ITargetLocation)container, true);
            }
            this.appendBundleCount(styledString, (ITargetLocation)container);
        } else if (element instanceof ProfileBundleContainer) {
            ProfileBundleContainer container = (ProfileBundleContainer)element;
            try {
                styledString.append(container.getLocation(false));
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            if (this.fAppendResolvedVariables) {
                this.appendLocation(styledString, (ITargetLocation)container, true);
            }
            this.appendBundleCount(styledString, (ITargetLocation)container);
        } else if (element instanceof IUBundleContainer) {
            IUBundleContainer container = (IUBundleContainer)element;
            List repos = container.getRepositories();
            styledString.append(repos.isEmpty() ? Messages.BundleContainerTable_8 : ((URI)repos.get(0)).toString());
            this.appendBundleCount(styledString, (ITargetLocation)container);
        } else if (element instanceof IUContentProvider.IUWrapper) {
            IUContentProvider.IUWrapper wrapper = (IUContentProvider.IUWrapper)element;
            styledString = this.getStyledString(wrapper.iu());
        } else if (element instanceof IInstallableUnit) {
            IInstallableUnit iu = (IInstallableUnit)element;
            String name = this.fTranslations.getIUProperty(iu, "org.eclipse.equinox.p2.name");
            if (name == null) {
                name = iu.getId();
            }
            styledString.append(name);
            styledString.append(' ');
            styledString.append(iu.getVersion().toString(), StyledString.QUALIFIER_STYLER);
        } else {
            styledString.append(String.valueOf(element));
        }
        return styledString;
    }

    private void appendBundleInfo(StyledString styledString, BundleInfo info) {
        String version;
        URI location;
        String name = info.getSymbolicName();
        if (name == null && (location = info.getLocation()) != null) {
            name = location.toString();
        }
        if (name != null) {
            styledString.append(name);
        }
        if (this.fShowVersion && (version = info.getVersion()) != null && !version.equals("0.0.0")) {
            styledString.append(' ');
            styledString.append('(', StyledString.QUALIFIER_STYLER);
            styledString.append(version, StyledString.QUALIFIER_STYLER);
            styledString.append(')', StyledString.QUALIFIER_STYLER);
        }
    }

    private void appendLocation(StyledString styledString, ITargetLocation container, boolean resolved) {
        try {
            String location = container.getLocation(resolved);
            styledString.append(" - ", StyledString.DECORATIONS_STYLER);
            styledString.append(location, StyledString.DECORATIONS_STYLER);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private void appendBundleCount(StyledString styledString, ITargetLocation container) {
        if (!container.isResolved() || !container.getStatus().isOK() && !container.getStatus().isMultiStatus() || container.getBundles() == null) {
            return;
        }
        int bundleCount = container.getBundles().length;
        String bundleCountString = Integer.toString(bundleCount);
        styledString.append(' ');
        styledString.append(MessageFormat.format(Messages.BundleContainerTable_10, bundleCountString), StyledString.COUNTER_STYLER);
    }

    public Image getImage(Object element) {
        return Optional.ofNullable((DelegatingStyledCellLabelProvider.IStyledLabelProvider)Adapters.adapt((Object)element, DelegatingStyledCellLabelProvider.IStyledLabelProvider.class)).map(styleProvider -> styleProvider.getImage(element)).or(() -> Optional.ofNullable((ILabelProvider)Adapters.adapt((Object)element, ILabelProvider.class)).map(provider -> {
            if (provider instanceof StyledBundleLabelProvider) {
                StyledBundleLabelProvider styleLabelProvider = (StyledBundleLabelProvider)((Object)((Object)provider));
                return styleLabelProvider.getInternalImage(element);
            }
            Image image = provider.getImage(element);
            if (image == null) {
                return null;
            }
            return image;
        })).orElseGet(() -> this.getInternalImage(element));
    }

    private Image getInternalImage(Object element) {
        block28: {
            block30: {
                int flag;
                block33: {
                    ITargetLocation container;
                    block31: {
                        IStatus status;
                        block32: {
                            block29: {
                                block27: {
                                    if (element instanceof TargetBundle) {
                                        int flag2;
                                        TargetBundle bundle = (TargetBundle)element;
                                        switch (bundle.getStatus().getSeverity()) {
                                            case 1: 
                                            case 2: {
                                                int n = 2;
                                                break;
                                            }
                                            case 4: {
                                                int n = 1;
                                                break;
                                            }
                                            default: {
                                                int n = flag2 = 0;
                                            }
                                        }
                                        if (bundle.getStatus().getSeverity() == 4 && bundle.getStatus().getCode() == 110) {
                                            return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_FEATURE_OBJ, flag2);
                                        }
                                        if (bundle.isFragment()) {
                                            return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_FRAGMENT_OBJ, flag2);
                                        }
                                        if (bundle.isSourceBundle()) {
                                            return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_PLUGIN_MF_OBJ, flag2);
                                        }
                                        return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_PLUGIN_OBJ, flag2);
                                    }
                                    if (element instanceof BundleInfo) {
                                        return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_PLUGIN_OBJ);
                                    }
                                    if (!(element instanceof NameVersionDescriptor)) break block27;
                                    NameVersionDescriptor descriptor = (NameVersionDescriptor)element;
                                    if ("feature".equals(descriptor.getType())) {
                                        return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_FEATURE_OBJ);
                                    }
                                    if ("plugin".equals(descriptor.getType())) {
                                        return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_PLUGIN_OBJ);
                                    }
                                    break block28;
                                }
                                if (!(element instanceof IStatus)) break block29;
                                IStatus status2 = (IStatus)element;
                                int severity = status2.getSeverity();
                                if (severity == 2 || severity == 1) {
                                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
                                }
                                if (severity == 4) {
                                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
                                }
                                break block28;
                            }
                            if (element instanceof IPath) {
                                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
                            }
                            if (element instanceof TargetFeature) {
                                return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_FEATURE_OBJ);
                            }
                            if (!(element instanceof ITargetLocation)) break block30;
                            container = (ITargetLocation)element;
                            flag = 0;
                            if (!container.isResolved()) break block31;
                            status = container.getStatus();
                            if (status.getSeverity() != 2 && status.getSeverity() != 1) break block32;
                            flag = 2;
                            break block33;
                        }
                        if (status.getSeverity() != 4) break block33;
                        flag = 1;
                        break block33;
                    }
                    Collection targetFlags = TargetPlatformHelper.getTargetDefinitionMap().values();
                    for (List targetDefinitionValues : targetFlags) {
                        ITargetLocation[] locs;
                        if (targetDefinitionValues.isEmpty() || (locs = ((TargetDefinition)targetDefinitionValues.get(0)).getTargetLocations()) == null) continue;
                        ITargetLocation[] iTargetLocationArray = locs;
                        int n = locs.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IStatus status;
                            ITargetLocation loc = iTargetLocationArray[n2];
                            if (container.equals(loc) && (status = loc.getStatus()) != null) {
                                if (status.getSeverity() == 2 || status.getSeverity() == 1) {
                                    flag = 2;
                                } else if (status.getSeverity() == 4) {
                                    flag = 1;
                                }
                            }
                            ++n2;
                        }
                    }
                }
                if (element instanceof FeatureBundleContainer) {
                    return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_FEATURE_OBJ, flag);
                }
                if (element instanceof DirectoryBundleContainer) {
                    ImageDescriptor image = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER");
                    return PDEPlugin.getDefault().getLabelProvider().get(image, flag);
                }
                if (element instanceof ProfileBundleContainer) {
                    return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_PRODUCT_DEFINITION, flag);
                }
                if (element instanceof IUBundleContainer) {
                    return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_REPOSITORY_OBJ, flag);
                }
                break block28;
            }
            if (element instanceof IUContentProvider.IUWrapper) {
                IUContentProvider.IUWrapper wrapper = (IUContentProvider.IUWrapper)element;
                return this.getImage(wrapper.iu());
            }
            if (element instanceof IInstallableUnit) {
                return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_NOREF_FEATURE_OBJ);
            }
        }
        return null;
    }

    public String getText(Object element) {
        StyledString string = this.getStyledString(element);
        return string.getString();
    }
}

