/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.parts;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.function.UnaryOperator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.core.target.NameVersionDescriptor;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.core.bundle.Bundle;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.text.bundle.ManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.PackageObject;
import org.eclipse.pde.internal.core.util.UtilMessages;
import org.eclipse.pde.internal.core.util.VersionUtil;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.parts.TablePart;
import org.eclipse.pde.internal.ui.util.PDELabelUtility;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

public class PluginVersionPart {
    private Text fMinVersionText;
    private Text fMaxVersionText;
    private Combo fMinVersionBound;
    private Combo fMaxVersionBound;
    private VersionRange fVersionRange;
    private boolean fIsRanged;
    private final boolean fRangeAllowed;
    private final boolean isPlugin;

    public PluginVersionPart(boolean rangeAllowed) {
        this(rangeAllowed, false);
    }

    public PluginVersionPart(boolean rangeAllowed, boolean isPlugin) {
        this.isPlugin = isPlugin;
        this.fRangeAllowed = rangeAllowed;
    }

    public void setVersion(String version) {
        try {
            if (version != null && !version.equals("")) {
                this.fVersionRange = new VersionRange(version);
                Version max = this.fVersionRange.getRight();
                if (max != null && this.fVersionRange.getLeft().compareTo(max) < 0) {
                    this.fIsRanged = true;
                }
            }
        }
        catch (IllegalArgumentException e) {
            this.fVersionRange = new VersionRange("[1.0.0,1.0.0]");
        }
    }

    private void setVersion(String min, String max) {
        this.fMinVersionBound.select(0);
        this.fMinVersionText.setText(min);
        this.fMaxVersionBound.select(1);
        this.fMaxVersionText.setText(max);
    }

    public void createVersionFields(Composite comp, boolean createGroup, boolean editable) {
        if (this.fRangeAllowed) {
            this.createRangeField(comp, createGroup, editable);
        } else {
            this.createSingleField(comp, createGroup, editable);
        }
        this.preloadFields();
    }

    public void createVersionSelectionField(Composite comp, String id) {
        Group group = new Group(comp, 0);
        group.setText(PDEUIMessages.PluginVersionPart_groupTitle);
        group.setLayoutData((Object)new GridData(770));
        group.setLayout((Layout)new GridLayout(2, false));
        PluginVersionTablePart part = new PluginVersionTablePart(new String[]{PDEUIMessages.PluginVersionPart_buttonTitle});
        part.createControl((Composite)group, 66050, 1, null);
        part.setMinimumSize(0, 75);
        part.getViewer().setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        if (this.isPlugin) {
            part.getViewer().setContentProvider((IContentProvider)new PluginVersionContentProvider());
            part.getViewer().setComparator(new ViewerComparator());
            part.getViewer().setInput((Object)PluginRegistry.findEntry((String)id));
        } else {
            part.getViewer().setContentProvider((IContentProvider)new ImportPackageVersionContentProvider());
            part.getViewer().setComparator(new ViewerComparator());
            part.getViewer().setInput((Object)id);
        }
        part.setButtonEnabled(0, false);
    }

    private void createRangeField(Composite parent, boolean createGroup, boolean editable) {
        if (createGroup) {
            parent = new Group(parent, 0);
            ((Group)parent).setText(this.getGroupText());
            parent.setLayoutData((Object)new GridData(768));
            parent.setLayout((Layout)new GridLayout(3, false));
        }
        String[] comboItems = new String[]{PDEUIMessages.DependencyPropertiesDialog_comboInclusive, PDEUIMessages.DependencyPropertiesDialog_comboExclusive};
        Label minlabel = new Label(parent, 0);
        minlabel.setText(PDEUIMessages.DependencyPropertiesDialog_minimumVersion);
        this.fMinVersionText = new Text(parent, 2052);
        this.fMinVersionText.setLayoutData((Object)new GridData(768));
        this.fMinVersionText.setEnabled(editable);
        this.fMinVersionBound = new Combo(parent, 2060);
        this.fMinVersionBound.setEnabled(editable);
        this.fMinVersionBound.setItems(comboItems);
        Label maxlabel = new Label(parent, 0);
        maxlabel.setText(PDEUIMessages.DependencyPropertiesDialog_maximumVersion);
        this.fMaxVersionText = new Text(parent, 2052);
        this.fMaxVersionText.setLayoutData((Object)new GridData(768));
        this.fMaxVersionText.setEnabled(editable);
        this.fMaxVersionBound = new Combo(parent, 2060);
        this.fMaxVersionBound.setEnabled(editable);
        this.fMaxVersionBound.setItems(comboItems);
    }

    private void createSingleField(Composite parent, boolean createGroup, boolean editable) {
        if (createGroup) {
            parent = new Group(parent, 0);
            ((Group)parent).setText(this.getGroupText());
            parent.setLayoutData((Object)new GridData(770));
            parent.setLayout((Layout)new GridLayout(2, false));
        }
        Label label = new Label(parent, 0);
        label.setText(PDEUIMessages.DependencyPropertiesDialog_version);
        this.fMinVersionText = new Text(parent, 2052);
        this.fMinVersionText.setLayoutData((Object)new GridData(768));
        this.fMinVersionText.setEnabled(editable);
        if (!this.fRangeAllowed) {
            Label incrLabel = new Label(parent, 0);
            incrLabel.setText(PDEUIMessages.PluginVersionPart_incrementTitle);
            incrLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            Composite btnBar = new Composite(parent, 0);
            btnBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            GridLayout btnBarLayout = new GridLayout(3, true);
            btnBarLayout.marginWidth = 0;
            btnBar.setLayout((Layout)btnBarLayout);
            Button majorBtn = this.createIncrementButton(btnBar, PDEUIMessages.PluginVersionPart_incrementMajor, editable, v -> new Version(v.getMajor() + 1, 0, 0));
            Button minorBtn = this.createIncrementButton(btnBar, PDEUIMessages.PluginVersionPart_incrementMinor, editable, v -> new Version(v.getMajor(), v.getMinor() + 1, 0));
            Button microBtn = this.createIncrementButton(btnBar, PDEUIMessages.PluginVersionPart_incrementMicro, editable, v -> new Version(v.getMajor(), v.getMinor(), v.getMicro() + 1));
            if (editable) {
                this.updateIncrementButtonsEnabled(majorBtn, minorBtn, microBtn);
                this.fMinVersionText.addModifyListener(e -> this.updateIncrementButtonsEnabled(majorBtn, minorBtn, microBtn));
            }
        }
    }

    public void preloadFields() {
        if (this.fRangeAllowed) {
            this.fMinVersionText.setText(this.fVersionRange != null ? this.fVersionRange.getLeft().toString() : "");
            this.fMaxVersionText.setText(this.fVersionRange != null && this.fVersionRange.getRight() != null ? this.fVersionRange.getRight().toString() : "");
            if (this.fVersionRange != null) {
                this.fMinVersionBound.select(this.fVersionRange.getLeftType() == '[' ? 0 : 1);
            } else {
                this.fMinVersionBound.select(0);
            }
            if (this.fVersionRange != null && this.getMaxVersion().length() > 0) {
                this.fMaxVersionBound.select(this.fVersionRange.getRightType() == ']' ? 0 : 1);
            } else {
                this.fMaxVersionBound.select(1);
            }
        }
        this.fMinVersionText.setText(this.fVersionRange != null ? this.fVersionRange.getLeft().toString() : "");
    }

    private IStatus validateVersion(String text, Text textWidget, boolean shortErrorMessage) {
        if (text.length() == 0) {
            return Status.OK_STATUS;
        }
        if (!VersionUtil.validateVersion((String)text).isOK()) {
            String errorMessage = null;
            errorMessage = shortErrorMessage ? PDEUIMessages.DependencyPropertiesDialog_invalidFormat : UtilMessages.BundleErrorReporter_InvalidFormatInBundleVersion;
            return Status.error((String)PDELabelUtility.qualifyMessage(PDELabelUtility.getFieldLabel((Control)textWidget), errorMessage), null);
        }
        return Status.OK_STATUS;
    }

    private IStatus validateVersionRange(boolean shortErrorMessage) {
        Version v2;
        Version v1;
        if (!this.fRangeAllowed && this.getMinVersion().length() == 0 || this.fRangeAllowed && (this.getMinVersion().length() == 0 || this.getMaxVersion().length() == 0)) {
            this.fIsRanged = false;
            return Status.OK_STATUS;
        }
        String errorMessage = null;
        errorMessage = shortErrorMessage ? PDEUIMessages.DependencyPropertiesDialog_invalidFormat : UtilMessages.BundleErrorReporter_InvalidFormatInBundleVersion;
        try {
            v1 = new Version(this.getMinVersion());
        }
        catch (IllegalArgumentException e) {
            return Status.error((String)PDELabelUtility.qualifyMessage(PDELabelUtility.getFieldLabel((Control)this.fMinVersionText), errorMessage));
        }
        if (!this.fRangeAllowed) {
            return Status.OK_STATUS;
        }
        try {
            v2 = new Version(this.getMaxVersion());
        }
        catch (IllegalArgumentException e) {
            return Status.error((String)PDELabelUtility.qualifyMessage(PDELabelUtility.getFieldLabel((Control)this.fMaxVersionText), errorMessage));
        }
        if (v1.compareTo(v2) == 0 || v1.compareTo(v2) < 0) {
            this.fIsRanged = true;
            return Status.OK_STATUS;
        }
        return Status.error((String)PDEUIMessages.DependencyPropertiesDialog_versionRangeError);
    }

    public IStatus validateFullVersionRangeText(boolean shortErrorMessage) {
        IStatus status = this.validateVersion(this.getMinVersion(), this.fMinVersionText, shortErrorMessage);
        if (status.isOK()) {
            status = this.validateVersion(this.getMaxVersion(), this.fMaxVersionText, shortErrorMessage);
        }
        if (status.isOK()) {
            status = this.validateVersionRange(shortErrorMessage);
        }
        return status;
    }

    private String getMinVersion() {
        return this.fMinVersionText.getText().trim();
    }

    private String getMaxVersion() {
        if (this.fMaxVersionText != null) {
            return this.fMaxVersionText.getText().trim();
        }
        return "";
    }

    private boolean getMinInclusive() {
        if (this.fMinVersionBound != null) {
            return this.fMinVersionBound.getSelectionIndex() == 0;
        }
        return false;
    }

    private boolean getMaxInclusive() {
        if (this.fMaxVersionBound != null) {
            return this.fMaxVersionBound.getSelectionIndex() == 0;
        }
        return true;
    }

    public String getVersion() {
        if (this.fIsRanged) {
            String minV = this.getMinVersion();
            String maxV = this.getMaxVersion();
            boolean minI = this.getMinInclusive();
            boolean maxI = this.getMaxInclusive();
            if (minV.equals(maxV)) {
                maxI = true;
                minI = true;
            }
            return Utils.createVersionRange((String)minV, (boolean)minI, (String)maxV, (boolean)maxI).toString();
        }
        if (!this.fRangeAllowed) {
            if (this.getMinVersion().length() > 0) {
                return new Version(this.getMinVersion()).toString();
            }
            return "";
        }
        if (this.getMinVersion().length() == 0 && this.getMaxVersion().length() > 0) {
            return Utils.createVersionRange(null, (boolean)this.getMinInclusive(), (String)this.getMaxVersion(), (boolean)this.getMaxInclusive()).toString();
        }
        if (this.getMinVersion().length() > 0) {
            return new Version(this.getMinVersion()).toString();
        }
        return "";
    }

    public void addListeners(ModifyListener minListener, ModifyListener maxListener) {
        if (this.fMinVersionText != null && minListener != null) {
            this.fMinVersionText.addModifyListener(minListener);
        }
        if (this.fRangeAllowed && this.fMaxVersionText != null && maxListener != null) {
            this.fMaxVersionText.addModifyListener(maxListener);
        }
    }

    protected String getGroupText() {
        return PDEUIMessages.DependencyPropertiesDialog_groupText;
    }

    private Button createIncrementButton(Composite btnBar, String label, boolean enabled, UnaryOperator<Version> versionModifier) {
        Button btn = new Button(btnBar, 8);
        btn.setText(label);
        btn.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            String originalText = this.getMinVersion();
            Version originalVersion = new Version(originalText);
            Object target = ((Version)versionModifier.apply(originalVersion)).toString();
            String qualifier = originalVersion.getQualifier();
            if (!qualifier.isEmpty()) {
                target = (String)target + "." + qualifier;
            }
            this.setVersion((String)target);
            this.preloadFields();
        }));
        btn.setLayoutData((Object)new GridData(4, 4, true, true));
        btn.setEnabled(enabled);
        return btn;
    }

    private void updateIncrementButtonsEnabled(Button majorBtn, Button minorBtn, Button microBtn) {
        boolean valid = VersionUtil.validateVersion((String)this.getMinVersion()).isOK();
        if (majorBtn != null && !majorBtn.isDisposed()) {
            majorBtn.setEnabled(valid);
        }
        if (minorBtn != null && !minorBtn.isDisposed()) {
            minorBtn.setEnabled(valid);
        }
        if (microBtn != null && !microBtn.isDisposed()) {
            microBtn.setEnabled(valid);
        }
    }

    private static class ImportPackageVersionContentProvider
    implements IStructuredContentProvider {
        private ImportPackageVersionContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            IPluginModelBase[] models = PluginRegistry.getActiveModels();
            ArrayList<PackageObject> list = new ArrayList<PackageObject>();
            HashSet<NameVersionDescriptor> nameVersions = new HashSet<NameVersionDescriptor>();
            IPluginModelBase[] iPluginModelBaseArray = models;
            int n = models.length;
            int n2 = 0;
            while (n2 < n) {
                String id;
                IPluginModelBase pluginModel = iPluginModelBaseArray[n2];
                BundleDescription desc = pluginModel.getBundleDescription();
                String string = id = desc == null ? null : desc.getSymbolicName();
                if (id != null) {
                    ExportPackageDescription[] exported;
                    ExportPackageDescription[] exportPackageDescriptionArray = exported = desc.getExportPackages();
                    int n3 = exported.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ExportPackageDescription exportedPackage = exportPackageDescriptionArray[n4];
                        String name = exportedPackage.getName();
                        ManifestHeader mHeader = new ManifestHeader("Export-Package", "", (IBundle)new Bundle(), "\n");
                        PackageObject po = new PackageObject(mHeader, exportedPackage.getName(), exportedPackage.getVersion().toString(), "version");
                        NameVersionDescriptor nameVersion = new NameVersionDescriptor(exportedPackage.getName(), exportedPackage.getVersion().toString(), "package");
                        exportedPackage.getExporter().getBundle();
                        if (!"java".equals(name) && !name.startsWith("java.") && nameVersions.add(nameVersion) && name.equalsIgnoreCase(inputElement.toString())) {
                            list.add(po);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            return list.toArray();
        }
    }

    private static class PluginVersionContentProvider
    implements IStructuredContentProvider {
        private PluginVersionContentProvider() {
        }

        public Object[] getElements(Object element) {
            if (element instanceof ModelEntry) {
                ModelEntry entry = (ModelEntry)element;
                return entry.getActiveModels();
            }
            return new Object[0];
        }
    }

    private class PluginVersionTablePart
    extends TablePart {
        public PluginVersionTablePart(String[] buttonLabels) {
            super(buttonLabels);
        }

        @Override
        protected void selectionChanged(IStructuredSelection selection) {
            if (selection.size() < 1) {
                this.setButtonEnabled(0, false);
            } else {
                this.setButtonEnabled(0, true);
            }
        }

        @Override
        protected void handleDoubleClick(IStructuredSelection selection) {
            if (selection.size() == 1) {
                String version = this.getVersion(selection.getFirstElement());
                PluginVersionPart.this.setVersion(version, "");
            }
        }

        @Override
        protected void buttonSelected(Button button, int index) {
            IStructuredSelection selection = this.getTableViewer().getStructuredSelection();
            if (selection.size() == 1) {
                String version = this.getVersion(selection.getFirstElement());
                String upperBound = this.computeUpperBound(version, this.getCurrentUpperBound());
                PluginVersionPart.this.setVersion(version, upperBound);
            } else {
                String maxVersion;
                String minVersion;
                if (PluginVersionPart.this.isPlugin) {
                    objects = selection.toArray();
                    IPluginModelBase min = (IPluginModelBase)objects[0];
                    IPluginModelBase max = (IPluginModelBase)objects[objects.length - 1];
                    minVersion = VersionUtil.computeInitialPluginVersion((String)min.getBundleDescription().getVersion().toString());
                    maxVersion = VersionUtil.computeInitialPluginVersion((String)max.getBundleDescription().getVersion().toString());
                } else {
                    objects = selection.toArray();
                    PackageObject poMin = (PackageObject)objects[0];
                    PackageObject poMax = (PackageObject)objects[objects.length - 1];
                    minVersion = poMin.getVersion();
                    maxVersion = poMax.getVersion();
                }
                String upperBound = this.computeUpperBound(maxVersion, this.getCurrentUpperBound());
                PluginVersionPart.this.setVersion(minVersion, upperBound);
            }
        }

        private String getVersion(Object firstElement) {
            if (PluginVersionPart.this.isPlugin) {
                IPluginModelBase entry = (IPluginModelBase)firstElement;
                return VersionUtil.computeInitialPluginVersion((String)entry.getBundleDescription().getVersion().toString());
            }
            PackageObject po = (PackageObject)firstElement;
            return po.getVersion();
        }

        private Version getCurrentUpperBound() {
            if (PluginVersionPart.this.fVersionRange != null) {
                return PluginVersionPart.this.fVersionRange.getRight();
            }
            return null;
        }

        private String computeUpperBound(String newLowerBound, Version existingUpperBound) {
            try {
                int existingUpperMajor;
                Version lowerVersion = Version.parseVersion((String)newLowerBound);
                int newMajor = lowerVersion.getMajor();
                if (existingUpperBound != null && newMajor < (existingUpperMajor = existingUpperBound.getMajor())) {
                    return existingUpperBound.toString();
                }
                Version nextMajor = new Version(newMajor + 1, 0, 0);
                return nextMajor.toString();
            }
            catch (IllegalArgumentException e) {
                return "";
            }
        }
    }
}

