/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.util;

import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.lm.util.LMMerger;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.transaction.CDOMerger;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.spi.cdo.DefaultCDOMerger;

public class CoreDeliveryMerger
implements LMMerger {
    @Override
    public long mergeDelivery(CDOSession session, CDOBranchPoint sourceBranchPoint, CDOBranch targetBranch) {
        try (CDOTransaction transaction = this.openTransaction(session, targetBranch);){
            CDOMerger merger = this.createMerger();
            if (transaction.merge(sourceBranchPoint, merger) != null) {
                CDOCommitInfo commitInfo = transaction.commit();
                long l = commitInfo.getTimeStamp();
                return l;
            }
        }
        return -1L;
    }

    protected CDOTransaction openTransaction(CDOSession session, CDOBranch branch) {
        return session.openTransaction(branch);
    }

    protected CDOMerger createMerger() {
        return new DefaultCDOMerger.PerFeature.ManyValued();
    }
}

