/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.gpg.bc.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.bouncycastle.bcpg.sig.IssuerFingerprint;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import org.bouncycastle.util.encoders.Hex;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.gpg.bc.internal.BCText;
import org.eclipse.jgit.gpg.bc.internal.BouncyCastleGpgKeyLocator;
import org.eclipse.jgit.gpg.bc.internal.BouncyCastleGpgPublicKey;
import org.eclipse.jgit.gpg.bc.internal.BouncyCastleGpgSigner;
import org.eclipse.jgit.lib.GpgConfig;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.SignatureVerifier;
import org.eclipse.jgit.util.LRUMap;
import org.eclipse.jgit.util.StringUtils;

public class BouncyCastleGpgSignatureVerifier
implements SignatureVerifier {
    private static final String NAME = "bc";
    private static final Object NO_KEY = new Object();
    private LRUMap<String, Object> byFingerprint = new LRUMap(16, 200);
    private LRUMap<String, Object> bySigner = new LRUMap(16, 200);

    public String getName() {
        return NAME;
    }

    static PGPSignature parseSignature(InputStream in) throws IOException, PGPException {
        InputStream sigIn;
        block11: {
            PGPSignature pGPSignature;
            block12: {
                Throwable throwable = null;
                Object var2_3 = null;
                sigIn = PGPUtil.getDecoderStream((InputStream)in);
                try {
                    JcaPGPObjectFactory pgpFactory = new JcaPGPObjectFactory(sigIn);
                    Object obj = pgpFactory.nextObject();
                    if (obj instanceof PGPCompressedData) {
                        obj = new JcaPGPObjectFactory(((PGPCompressedData)obj).getDataStream()).nextObject();
                    }
                    if (!(obj instanceof PGPSignatureList)) break block11;
                    pGPSignature = ((PGPSignatureList)obj).get(0);
                    if (sigIn == null) break block12;
                }
                catch (Throwable throwable2) {
                    try {
                        if (sigIn != null) {
                            sigIn.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                sigIn.close();
            }
            return pGPSignature;
        }
        if (sigIn != null) {
            sigIn.close();
        }
        return null;
    }

    public SignatureVerifier.SignatureVerification verify(Repository repository, GpgConfig config, byte[] data, byte[] signatureData) throws IOException {
        String keyId;
        String signer;
        String fingerprint;
        PGPSignature signature;
        block40: {
            signature = null;
            fingerprint = null;
            signer = null;
            keyId = null;
            try {
                Throwable throwable = null;
                Object var10_12 = null;
                try (ByteArrayInputStream sigIn = new ByteArrayInputStream(signatureData);){
                    signature = BouncyCastleGpgSignatureVerifier.parseSignature(sigIn);
                    if (signature != null) {
                        if (signature.hasSubpackets()) {
                            PGPSignatureSubpacketVector packets = signature.getHashedSubPackets();
                            IssuerFingerprint fingerprintPacket = packets.getIssuerFingerprint();
                            if (fingerprintPacket != null) {
                                fingerprint = Hex.toHexString((byte[])fingerprintPacket.getFingerprint()).toLowerCase(Locale.ROOT);
                            }
                            if ((signer = packets.getSignerUserID()) != null) {
                                signer = BouncyCastleGpgSigner.extractSignerId(signer);
                            }
                        }
                        keyId = Long.toUnsignedString(signature.getKeyID(), 16).toLowerCase(Locale.ROOT);
                        break block40;
                    }
                    throw new JGitInternalException(BCText.get().nonSignatureError);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (NumberFormatException | PGPException e) {
                throw new JGitInternalException(BCText.get().signatureParseError, e);
            }
        }
        Date signatureCreatedAt = signature.getCreationTime();
        if (fingerprint == null && signer == null && keyId == null) {
            return new SignatureVerifier.SignatureVerification(NAME, signatureCreatedAt, null, null, null, false, false, SignatureVerifier.TrustLevel.UNKNOWN, BCText.get().signatureNoKeyInfo);
        }
        if (fingerprint != null && keyId != null && !fingerprint.endsWith(keyId)) {
            return new SignatureVerifier.SignatureVerification(NAME, signatureCreatedAt, signer, fingerprint, signer, false, false, SignatureVerifier.TrustLevel.UNKNOWN, MessageFormat.format(BCText.get().signatureInconsistent, keyId, fingerprint));
        }
        if (fingerprint == null && keyId != null) {
            fingerprint = keyId;
        }
        String keySpec = "<" + signer + ">";
        Object cached = null;
        BouncyCastleGpgPublicKey publicKey = null;
        try {
            cached = this.byFingerprint.get((Object)fingerprint);
            if (cached != null) {
                if (cached instanceof BouncyCastleGpgPublicKey) {
                    publicKey = (BouncyCastleGpgPublicKey)cached;
                }
            } else if (!StringUtils.isEmptyOrNull((String)signer) && (cached = this.bySigner.get((Object)signer)) != null && cached instanceof BouncyCastleGpgPublicKey) {
                publicKey = (BouncyCastleGpgPublicKey)cached;
            }
            if (cached == null) {
                publicKey = BouncyCastleGpgKeyLocator.findPublicKey(fingerprint, keySpec);
            }
        }
        catch (IOException | PGPException e) {
            throw new JGitInternalException(BCText.get().signatureKeyLookupError, e);
        }
        if (publicKey == null) {
            if (cached == null) {
                this.byFingerprint.put((Object)fingerprint, NO_KEY);
                this.byFingerprint.put((Object)keyId, NO_KEY);
                if (signer != null) {
                    this.bySigner.put((Object)signer, NO_KEY);
                }
            }
            return new SignatureVerifier.SignatureVerification(NAME, signatureCreatedAt, signer, fingerprint, signer, false, false, SignatureVerifier.TrustLevel.UNKNOWN, BCText.get().signatureNoPublicKey);
        }
        if (fingerprint != null && !publicKey.isExactMatch()) {
            return new SignatureVerifier.SignatureVerification(NAME, signatureCreatedAt, signer, fingerprint, signer, false, false, SignatureVerifier.TrustLevel.UNKNOWN, MessageFormat.format(BCText.get().signatureNoSigningKey, fingerprint));
        }
        if (cached == null) {
            this.byFingerprint.put((Object)fingerprint, (Object)publicKey);
            this.byFingerprint.put((Object)keyId, (Object)publicKey);
            if (signer != null) {
                this.bySigner.put((Object)signer, (Object)publicKey);
            }
        }
        String user = null;
        List<String> userIds = publicKey.getUserIds();
        if (userIds != null && !userIds.isEmpty()) {
            if (!StringUtils.isEmptyOrNull((String)signer)) {
                for (String userId : publicKey.getUserIds()) {
                    if (!BouncyCastleGpgKeyLocator.containsSigningKey(userId, keySpec)) continue;
                    user = userId;
                    break;
                }
            }
            if (user == null) {
                user = userIds.get(0);
            }
        } else if (signer != null) {
            user = signer;
        }
        PGPPublicKey pubKey = publicKey.getPublicKey();
        boolean expired = false;
        long validFor = pubKey.getValidSeconds();
        if (validFor > 0L && signatureCreatedAt != null) {
            Instant expiredAt = pubKey.getCreationTime().toInstant().plusSeconds(validFor);
            expired = expiredAt.isBefore(signatureCreatedAt.toInstant());
        }
        byte[] trustData = pubKey.getTrustData();
        SignatureVerifier.TrustLevel trust = this.parseGpgTrustPacket(trustData);
        boolean verified = false;
        try {
            signature.init((PGPContentVerifierBuilderProvider)new JcaPGPContentVerifierBuilderProvider(), pubKey);
            signature.update(data);
            verified = signature.verify();
        }
        catch (PGPException e) {
            throw new JGitInternalException(BCText.get().signatureVerificationError, (Throwable)e);
        }
        return new SignatureVerifier.SignatureVerification(NAME, signatureCreatedAt, signer, fingerprint, user, verified, expired, trust, null);
    }

    private SignatureVerifier.TrustLevel parseGpgTrustPacket(byte[] packet) {
        if (packet == null || packet.length < 6) {
            return SignatureVerifier.TrustLevel.UNKNOWN;
        }
        if (packet[2] != 103 || packet[3] != 112 || packet[4] != 103) {
            return SignatureVerifier.TrustLevel.UNKNOWN;
        }
        int trust = packet[0] & 0xF;
        switch (trust) {
            case 0: 
            case 1: 
            case 2: {
                return SignatureVerifier.TrustLevel.UNKNOWN;
            }
            case 3: {
                return SignatureVerifier.TrustLevel.NEVER;
            }
            case 4: {
                return SignatureVerifier.TrustLevel.MARGINAL;
            }
            case 5: {
                return SignatureVerifier.TrustLevel.FULL;
            }
            case 6: {
                return SignatureVerifier.TrustLevel.ULTIMATE;
            }
        }
        return SignatureVerifier.TrustLevel.UNKNOWN;
    }

    public void clear() {
        this.byFingerprint.clear();
        this.bySigner.clear();
    }
}

