/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.layout.ordering;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.tools.api.DiagramPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.layout.ordering.ViewOrderingProvider;

public final class ViewOrderingProviderRegistry {
    private static ViewOrderingProviderRegistry instance = new ViewOrderingProviderRegistry();
    private static final String VIEW_ORDERING_PROVIDER_EXTENSION_POINT = "org.eclipse.sirius.diagram.ui.viewOrderingProvider";
    private static final String TAG_ENGINE = "viewOrderingProvider";
    private Collection<ViewOrderingProvider> viewOrderingProviders;

    private ViewOrderingProviderRegistry() {
        this.parseExtensionMetadata();
    }

    private void parseExtensionMetadata() {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            IExtension[] extensions;
            this.viewOrderingProviders = new LinkedList<ViewOrderingProvider>();
            IExtension[] iExtensionArray = extensions = Platform.getExtensionRegistry().getExtensionPoint(VIEW_ORDERING_PROVIDER_EXTENSION_POINT).getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = extension.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configElement = iConfigurationElementArray[n4];
                    if (configElement.getName().equals(TAG_ENGINE)) {
                        try {
                            ViewOrderingProvider viewOrderingProvider = (ViewOrderingProvider)configElement.createExecutableExtension("providerClass");
                            this.viewOrderingProviders.add(viewOrderingProvider);
                        }
                        catch (CoreException e) {
                            DiagramPlugin.getDefault().logError(MessageFormat.format(Messages.ViewOrderingProviderRegistry_viewOrderingProvider_loadingProblem, configElement.getName()), (Throwable)e);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    public static ViewOrderingProviderRegistry getInstance() {
        return instance;
    }

    public Collection<ViewOrderingProvider> getAllProviders() {
        return this.viewOrderingProviders;
    }

    public ViewOrderingProvider getProvider(DiagramElementMapping mapping) {
        for (ViewOrderingProvider currentProvider : this.getAllProviders()) {
            if (!currentProvider.provides(mapping)) continue;
            return currentProvider;
        }
        return null;
    }
}

