/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.io;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.eclipse.net4j.util.io.DataInputExtender;
import org.eclipse.net4j.util.io.DataOutputExtender;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.io.IORuntimeException;
import org.eclipse.net4j.util.io.IOUtil;

public abstract class SortedFileMap<K extends Comparable<K>, V>
implements Closeable {
    private File file;
    private RandomAccessFile randomAccessFile;
    private ExtendedDataInput input;
    private ExtendedDataOutput output;
    private long entrySize;
    private long entryCount;

    public SortedFileMap(File file, String mode) {
        try {
            this.file = file;
            this.randomAccessFile = new RandomAccessFile(file, mode);
            this.input = new DataInputExtender(this.randomAccessFile);
            this.output = new DataOutputExtender(this.randomAccessFile);
            this.entrySize = this.getKeySize() + this.getValueSize();
            this.entryCount = this.randomAccessFile.length() / this.entrySize;
        }
        catch (IOException ex) {
            throw new IORuntimeException(ex);
        }
    }

    @Override
    public void close() throws IOException {
        IOUtil.close(this.randomAccessFile);
    }

    public File getFile() {
        return this.file;
    }

    public RandomAccessFile getRandomAccessFile() {
        return this.randomAccessFile;
    }

    public long getEntryCount() {
        return this.entryCount;
    }

    public int getEntrySize() {
        return (int)this.entrySize;
    }

    public long getPosition(long index) {
        return index * this.entrySize;
    }

    public long getValuePosition(long index) {
        return this.getPosition(index) + (long)this.getKeySize();
    }

    public K getMaxKey() {
        if (this.entryCount == 0L) {
            return null;
        }
        return this.getKey(this.entryCount - 1L);
    }

    public K getKey(long index) {
        try {
            long pos = this.getPosition(index);
            this.randomAccessFile.seek(pos);
            return this.readKey(this.input);
        }
        catch (IOException ex) {
            throw new IORuntimeException(ex);
        }
    }

    public V getValue(long index) {
        try {
            long pos = this.getValuePosition(index);
            this.randomAccessFile.seek(pos);
            return this.readValue(this.input);
        }
        catch (IOException ex) {
            throw new IORuntimeException(ex);
        }
    }

    public V get(K key) {
        block3: {
            try {
                long index = this.search(key);
                if (index >= 0L) break block3;
            }
            catch (IOException ex) {
                throw new IORuntimeException(ex);
            }
            return null;
        }
        return this.readValue(this.input);
    }

    public V put(K key, V value) {
        try {
            long index = this.search(key);
            if (index >= 0L) {
                long pos = this.getValuePosition(index);
                this.randomAccessFile.seek(pos);
                V oldValue = this.readValue(this.input);
                this.randomAccessFile.seek(pos);
                this.writeValue(this.output, value);
                return oldValue;
            }
            index = -index - 1L;
            long i = this.entryCount;
            while (i > index) {
                this.randomAccessFile.seek(this.getPosition(i - 1L));
                K k = this.readKey(this.input);
                this.randomAccessFile.seek(this.getValuePosition(i - 1L));
                V v = this.readValue(this.input);
                this.randomAccessFile.seek(this.getPosition(i));
                this.writeKey(this.output, k);
                this.randomAccessFile.seek(this.getValuePosition(i));
                this.writeValue(this.output, v);
                --i;
            }
            ++this.entryCount;
            this.randomAccessFile.seek(this.getPosition(index));
            this.writeKey(this.output, key);
            this.randomAccessFile.seek(this.getValuePosition(index));
            this.writeValue(this.output, value);
        }
        catch (IOException ex) {
            throw new IORuntimeException(ex);
        }
        return null;
    }

    protected long search(K key) throws IOException {
        long low = 0L;
        long high = this.entryCount - 1L;
        while (low <= high) {
            long mid = low + high >> 1;
            this.randomAccessFile.seek(this.getPosition(mid));
            K midVal = this.readKey(this.input);
            int cmp = midVal.compareTo(key);
            if (cmp < 0) {
                low = mid + 1L;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1L;
                continue;
            }
            return mid;
        }
        return -(low + 1L);
    }

    public abstract int getKeySize();

    protected abstract K readKey(ExtendedDataInput var1) throws IOException;

    protected abstract void writeKey(ExtendedDataOutput var1, K var2) throws IOException;

    public abstract int getValueSize();

    protected abstract V readValue(ExtendedDataInput var1) throws IOException;

    protected abstract void writeValue(ExtendedDataOutput var1, V var2) throws IOException;
}

