/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.event;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.net4j.util.event.Event;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.event.IPropertiesEvent;
import org.eclipse.net4j.util.event.Notifier;

public class PropertiesEvent
extends Event
implements IPropertiesEvent {
    private static final long serialVersionUID = 1L;
    private final Map<String, Object> properties;

    public PropertiesEvent(INotifier notifier, Map<String, Object> properties) {
        super(notifier);
        this.properties = Objects.requireNonNull(properties);
    }

    public PropertiesEvent(INotifier notifier) {
        this(notifier, new HashMap<String, Object>());
    }

    @Override
    public final Map<String, Object> properties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public final Map<String, Object> modifiableProperties() {
        return this.properties;
    }

    public final PropertiesEvent setType(String type) {
        return this.addProperty("type", type);
    }

    public final PropertiesEvent addProperty(Object value) {
        String name = value.getClass().getName();
        return this.addProperty(name, value);
    }

    public final <T> PropertiesEvent addProperty(Class<T> name, T value) {
        return this.addProperty(name.getName(), value);
    }

    public final PropertiesEvent addProperty(String name, Object value) {
        this.properties.put(name, value);
        return this;
    }

    public final PropertiesEvent removeProperty(String name) {
        this.properties.remove(name);
        return this;
    }

    public final PropertiesEvent removeProperties(String ... names) {
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.removeProperty(name);
            ++n2;
        }
        return this;
    }

    public PropertiesEvent fire() {
        INotifier source = this.getSource();
        if (source instanceof Notifier) {
            Notifier notifier = (Notifier)source;
            notifier.fireEvent(this);
        }
        return this;
    }

    @Override
    protected String formatAdditionalParameters() {
        return this.properties.entrySet().stream().map(entry -> String.valueOf((String)entry.getKey()) + "=" + entry.getValue()).collect(Collectors.joining(", "));
    }
}

