/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.discovery;

import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.discovery.AbstractClassNameFilter;

class IncludeClassNameFilter
extends AbstractClassNameFilter {
    IncludeClassNameFilter(String ... patterns) {
        super(patterns);
    }

    @Override
    public FilterResult apply(String className) {
        return this.findMatchingPattern(className).map(pattern -> FilterResult.included(this.formatInclusionReason(className, (Pattern)pattern))).orElseGet(() -> FilterResult.excluded(this.formatExclusionReason(className)));
    }

    private String formatInclusionReason(String className, Pattern pattern) {
        return "Class name [%s] matches included pattern: '%s'".formatted(className, pattern);
    }

    private String formatExclusionReason(String className) {
        return "Class name [%s] does not match any included pattern: %s".formatted(className, this.patternDescription);
    }

    @Override
    public Predicate<String> toPredicate() {
        return className -> this.findMatchingPattern((String)className).isPresent();
    }

    public String toString() {
        return "%s that includes class names that match one of the following regular expressions: %s".formatted(this.getClass().getSimpleName(), this.patternDescription);
    }
}

