/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.commons.core.XmlStringConverter;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SaxRepositoriesContentHandler
extends DefaultHandler {
    static final String ATTRIBUTE_INTERACTION_EVENT = "InteractionEvent";
    private final Set<TaskRepository> taskRepositories = new HashSet<TaskRepository>();
    private TaskRepository currentRepository;

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            if (localName.equals("TaskRepository")) {
                this.handleRepositoryElement(attributes);
            } else if (localName.equals("Property") && this.currentRepository != null) {
                this.handleProperty(attributes);
            }
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Could not read repositories", (Throwable)e));
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (this.currentRepository != null && localName.equals("TaskRepository")) {
            this.taskRepositories.add(this.currentRepository);
            this.currentRepository = null;
        }
    }

    private void handleRepositoryElement(Attributes attributes) throws SAXException {
        String kind = XmlStringConverter.convertXmlToString((String)attributes.getValue("kind"));
        String url = XmlStringConverter.convertXmlToString((String)attributes.getValue("url"));
        if (StringUtils.isNotEmpty((CharSequence)kind) && StringUtils.isNotEmpty((CharSequence)url)) {
            this.currentRepository = new TaskRepository(kind, url);
            int index = 0;
            while (index < attributes.getLength()) {
                String key = XmlStringConverter.convertXmlToString((String)attributes.getLocalName(index));
                String value = XmlStringConverter.convertXmlToString((String)attributes.getValue(index));
                this.currentRepository.setProperty(key, value);
                ++index;
            }
        }
    }

    private void handleProperty(Attributes attributes) throws SAXException {
        String key = attributes.getValue("key");
        String value = attributes.getValue("value");
        if (key != null && value != null) {
            this.currentRepository.setProperty(key, value);
        }
    }

    public Set<TaskRepository> getRepositories() {
        return this.taskRepositories;
    }
}

