/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tools.layout.spy.internal.displayfilter;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public final class Painter {
    private static final int BUFFER_SIZE = 2048;
    private static final Color[] COLORS = new Color[]{Painter.getSystemColor(3), Painter.getSystemColor(9), Painter.getSystemColor(7), Painter.getSystemColor(5), Painter.getSystemColor(13), Painter.getSystemColor(11), Painter.getSystemColor(4), Painter.getSystemColor(10), Painter.getSystemColor(8), Painter.getSystemColor(6), Painter.getSystemColor(14), Painter.getSystemColor(12)};
    private static final String LINE_SEPARATOR = System.lineSeparator();

    private static void createCompositeToolTip(StringBuilder buffer, Composite composite) {
        Layout layout = composite.getLayout();
        buffer.append(LINE_SEPARATOR);
        buffer.append("  layout=");
        if (layout instanceof GridLayout) {
            GridLayout gridLayout = (GridLayout)layout;
            Painter.createGridLayoutToolTip(buffer, gridLayout);
        } else if (layout instanceof FormLayout) {
            FormLayout formLayout = (FormLayout)layout;
            Painter.createFormLayoutToolTip(buffer, formLayout);
        } else if (layout instanceof FillLayout) {
            FillLayout fillLayout = (FillLayout)layout;
            Painter.createFillLayoutToolTip(buffer, fillLayout);
        } else if (layout instanceof RowLayout) {
            RowLayout rowLayout = (RowLayout)layout;
            Painter.createRowLayoutToolTip(buffer, rowLayout);
        } else {
            buffer.append(layout);
        }
    }

    private static void createFillLayoutToolTip(StringBuilder buffer, FillLayout layout) {
        buffer.append("FormLayout");
        buffer.append(LINE_SEPARATOR);
        buffer.append("    marginHeight=");
        buffer.append(layout.marginHeight);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    marginWidth=");
        buffer.append(layout.marginWidth);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    spacing=");
        buffer.append(layout.spacing);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    type=");
        buffer.append(layout.type);
        buffer.append(" (");
        buffer.append(Painter.getLayoutTypeText(layout.type));
        buffer.append(')');
    }

    private static void createFormDataToolTip(StringBuilder buffer, FormData data) {
        buffer.append("FormData");
        buffer.append(LINE_SEPARATOR);
        buffer.append("    bottom=");
        buffer.append(data.bottom);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    height=");
        buffer.append(data.height);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    left=");
        buffer.append(data.left);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    right=");
        buffer.append(data.right);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    top=");
        buffer.append(data.top);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    width=");
        buffer.append(data.width);
    }

    private static void createFormLayoutToolTip(StringBuilder buffer, FormLayout layout) {
        buffer.append("FormLayout");
        buffer.append(LINE_SEPARATOR);
        buffer.append("    marginBottom=");
        buffer.append(layout.marginBottom);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    marginHeight=");
        buffer.append(layout.marginHeight);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    marginLeft=");
        buffer.append(layout.marginLeft);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    marginRight=");
        buffer.append(layout.marginRight);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    marginTop=");
        buffer.append(layout.marginTop);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    marginWidth=");
        buffer.append(layout.marginWidth);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    spacing=");
        buffer.append(layout.spacing);
    }

    private static void createGridDataToolTip(StringBuilder buffer, GridData gridData) {
        buffer.append("GridData");
        buffer.append(LINE_SEPARATOR);
        buffer.append("    exclude=");
        buffer.append(gridData.exclude);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    grabExcessHorizontalSpace=");
        buffer.append(gridData.grabExcessHorizontalSpace);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    grabExcessVerticalSpace=");
        buffer.append(gridData.grabExcessVerticalSpace);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    heightHint=");
        buffer.append(gridData.heightHint);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    horizontalAlignment=");
        buffer.append(Painter.getAlignmentText(gridData.horizontalAlignment));
        buffer.append(LINE_SEPARATOR);
        buffer.append("    horizontalIndent=");
        buffer.append(gridData.horizontalIndent);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    horizontalSpan=");
        buffer.append(gridData.horizontalSpan);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    minimumHeight=");
        buffer.append(gridData.minimumHeight);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    minimumWidth=");
        buffer.append(gridData.minimumWidth);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    verticalAlignment=");
        buffer.append(Painter.getAlignmentText(gridData.verticalAlignment));
        buffer.append(LINE_SEPARATOR);
        buffer.append("    verticalIndent=");
        buffer.append(gridData.verticalIndent);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    verticalSpan=");
        buffer.append(gridData.verticalSpan);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    widthHint=");
        buffer.append(gridData.widthHint);
    }

    private static void createGridLayoutToolTip(StringBuilder buffer, GridLayout layout) {
        buffer.append("GridLayout");
        buffer.append(LINE_SEPARATOR);
        buffer.append("    horizontalSpacing=");
        buffer.append(layout.horizontalSpacing);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    makeColumnsEqualWidth=");
        buffer.append(layout.makeColumnsEqualWidth);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    marginBottom=");
        buffer.append(layout.marginBottom);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    marginHeight=");
        buffer.append(layout.marginHeight);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    marginLeft=");
        buffer.append(layout.marginLeft);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    marginRight=");
        buffer.append(layout.marginRight);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    marginTop=");
        buffer.append(layout.marginBottom);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    marginWidth=");
        buffer.append(layout.marginWidth);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    numColumns=");
        buffer.append(layout.numColumns);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    verticalSpacing=");
        buffer.append(layout.verticalSpacing);
    }

    private static void createRowDataToolTip(StringBuilder buffer, RowData data) {
        buffer.append("RowData");
        buffer.append(LINE_SEPARATOR);
        buffer.append("    exclude=");
        buffer.append(data.exclude);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    height=");
        buffer.append(data.height);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    width=");
        buffer.append(data.width);
    }

    private static void createRowLayoutToolTip(StringBuilder buffer, RowLayout layout) {
        buffer.append("RowLayout");
        buffer.append(LINE_SEPARATOR);
        buffer.append("    fill=");
        buffer.append(layout.fill);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    justify=");
        buffer.append(layout.justify);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    marginBottom=");
        buffer.append(layout.marginBottom);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    marginHeight=");
        buffer.append(layout.marginHeight);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    marginLeft=");
        buffer.append(layout.marginLeft);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    marginRight=");
        buffer.append(layout.marginRight);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    marginTop=");
        buffer.append(layout.marginTop);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    marginWidth=");
        buffer.append(layout.marginWidth);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    pack=");
        buffer.append(layout.pack);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    spacing=");
        buffer.append(layout.spacing);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    type=");
        buffer.append(layout.type);
        buffer.append(" (");
        buffer.append(Painter.getLayoutTypeText(layout.type));
        buffer.append(')');
        buffer.append(LINE_SEPARATOR);
        buffer.append("    wrap=");
        buffer.append(layout.wrap);
    }

    private static void createToolTip(StringBuilder buffer, Control control, int childIndex) {
        if (childIndex != 0) {
            buffer.append(childIndex);
            buffer.append(". ");
        }
        buffer.append(control);
        buffer.append(Painter.getHashCodeText(control));
        buffer.append(LINE_SEPARATOR);
        buffer.append("  parent=");
        Composite parent = control.getParent();
        buffer.append(parent);
        if (parent != null) {
            buffer.append(Painter.getHashCodeText(parent));
        }
        buffer.append(LINE_SEPARATOR);
        buffer.append("  border width=");
        buffer.append(control.getBorderWidth());
        buffer.append(LINE_SEPARATOR);
        buffer.append("  bounds=");
        buffer.append(control.getBounds());
        buffer.append(LINE_SEPARATOR);
        buffer.append("  data=");
        buffer.append(control.getData());
        buffer.append(LINE_SEPARATOR);
        buffer.append("  font=");
        Font font = control.getFont();
        FontData[] fontData = font.getFontData();
        buffer.append(fontData[0]);
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            Painter.createCompositeToolTip(buffer, composite);
        }
        Object layoutData = control.getLayoutData();
        buffer.append(LINE_SEPARATOR);
        buffer.append("  layout data=");
        if (layoutData instanceof GridData) {
            GridData gridData = (GridData)layoutData;
            Painter.createGridDataToolTip(buffer, gridData);
        } else if (layoutData instanceof FormData) {
            FormData formData = (FormData)layoutData;
            Painter.createFormDataToolTip(buffer, formData);
        } else if (layoutData instanceof RowData) {
            RowData rowData = (RowData)layoutData;
            Painter.createRowDataToolTip(buffer, rowData);
        } else {
            buffer.append(layoutData);
        }
        buffer.append(LINE_SEPARATOR);
        buffer.append("  location=");
        buffer.append(control.getLocation());
        buffer.append(LINE_SEPARATOR);
        buffer.append("  size=");
        buffer.append(control.getSize());
        buffer.append(LINE_SEPARATOR);
        buffer.append("  style=");
        buffer.append(control.getStyle());
    }

    public static void decorate(Control control) {
        Painter.decorate(control, true);
    }

    public static void decorate(Control control, boolean toolTip) {
        Painter.decorate(control, 0, toolTip);
    }

    public static void decorate(Control control, int extraCompositeMargin, boolean toolTip) {
        if (control == null) {
            throw new IllegalArgumentException("The argument 'control' must not be null");
        }
        if (!"IGNORE_BY_LayoutIssuesDebugFilter".equals(control.getData())) {
            StringBuilder buffer = new StringBuilder(2048);
            Painter.decorate(buffer, control, extraCompositeMargin, 0, 0, toolTip);
        }
    }

    private static void decorate(StringBuilder buffer, Control control, int extraCompositeMargin, int colorIndex, int childIndex, boolean toolTip) {
        int count = COLORS.length;
        int index = colorIndex == count ? 0 : colorIndex;
        Color color = COLORS[index];
        control.setBackground(color);
        if (toolTip) {
            Painter.createToolTip(buffer, control, childIndex);
            String tip = Painter.getBufferValue(buffer);
            control.setToolTipText(tip);
        }
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            Painter.padComposite(composite, extraCompositeMargin);
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                Control child = children[i];
                Painter.decorate(buffer, child, extraCompositeMargin, index + 1, i + 1, toolTip);
                ++i;
            }
        }
    }

    private static String getAlignmentText(int alignment) {
        String text = null;
        switch (alignment) {
            case 2: {
                text = "GridData.CENTER";
                break;
            }
            case 3: {
                text = "GridData.END";
                break;
            }
            case 1: {
                text = "SWT.BEGINNING";
                break;
            }
            case 1024: {
                text = "SWT.BOTTOM";
                break;
            }
            case 0x1000000: {
                text = "SWT.CENTER";
                break;
            }
            case 0x1000008: {
                text = "SWT.END";
                break;
            }
            case 4: {
                text = "SWT.FILL";
                break;
            }
            case 16384: {
                text = "SWT.LEFT";
                break;
            }
            case 131072: {
                text = "SWT.RIGHT";
                break;
            }
            case 128: {
                text = "SWT.TOP";
                break;
            }
            default: {
                text = Integer.toString(alignment);
            }
        }
        return text;
    }

    private static String getBufferValue(StringBuilder buffer) {
        String value = buffer.toString();
        buffer.setLength(0);
        return value;
    }

    private static String getHashCodeText(Object object) {
        long hashCode = object.hashCode();
        String hexString = Long.toHexString(hashCode);
        StringBuilder buffer = new StringBuilder(15);
        buffer.append('(');
        buffer.append(hexString);
        buffer.append(')');
        String result = Painter.getBufferValue(buffer);
        return result;
    }

    private static String getLayoutTypeText(int type) {
        return switch (type) {
            case 256 -> "SWT.HORIZONTAL";
            case 512 -> "SWT.VERTICAL";
            default -> Integer.toString(type);
        };
    }

    private static Color getSystemColor(int id) {
        Display device = Display.getDefault();
        Color color = device.getSystemColor(id);
        return color;
    }

    private static void padComposite(Composite composite, int extraCompositeMargin) {
        Layout compositeLayout = composite.getLayout();
        if (compositeLayout == null) {
            return;
        }
        if (extraCompositeMargin < 0) {
            return;
        }
        if (compositeLayout instanceof GridLayout) {
            GridLayout layout = (GridLayout)compositeLayout;
            layout.marginWidth += extraCompositeMargin;
            layout.marginHeight += extraCompositeMargin;
        } else if (compositeLayout instanceof RowLayout) {
            RowLayout layout = (RowLayout)compositeLayout;
            layout.marginWidth += extraCompositeMargin;
            layout.marginHeight += extraCompositeMargin;
        } else if (compositeLayout instanceof FillLayout) {
            FillLayout layout = (FillLayout)compositeLayout;
            layout.marginWidth += extraCompositeMargin;
            layout.marginHeight += extraCompositeMargin;
        } else if (compositeLayout instanceof FormLayout) {
            FormLayout layout = (FormLayout)compositeLayout;
            layout.marginWidth += extraCompositeMargin;
            layout.marginHeight += extraCompositeMargin;
        }
    }

    public static void setBackground(Control control, int id) {
        Color color = Painter.getSystemColor(id);
        control.setBackground(color);
    }

    private Painter() {
    }
}

