/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.util.Iterator;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionProvider;
import org.eclipse.emf.cdo.common.security.CDOPermission;
import org.eclipse.emf.cdo.internal.server.LDAPUserAuthenticator;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.server.IRepositoryProtector;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.net4j.util.StringTester;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.collection.ConcurrentArray;
import org.eclipse.net4j.util.factory.AnnotationFactory;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.registry.IRegistry;

public class DefaultRevisionAuthorizer
extends IRepositoryProtector.RevisionAuthorizer {
    private CDOPermission permission;
    private Matcher matcher;

    public final CDOPermission getPermission() {
        return this.permission;
    }

    @AnnotationFactory.InjectAttribute(name="permission")
    public final void setPermission(CDOPermission permission) {
        this.checkInactive();
        this.permission = permission;
    }

    public final Matcher getMatcher() {
        return this.matcher;
    }

    @AnnotationFactory.InjectElement(productGroup="org.eclipse.emf.cdo.server.revisionAuthorizerMatchers")
    public final void setMatcher(Matcher matcher) {
        this.checkInactive();
        this.matcher = matcher;
    }

    @Override
    public CDOPermission authorizeRevision(ISession session, IRepositoryProtector.UserInfo userInfo, CDOBranchPoint securityContext, CDORevisionProvider revisionProvider, CDORevision revision) {
        if (this.matcher.matches(session, userInfo, securityContext, revisionProvider, revision)) {
            return this.permission;
        }
        return null;
    }

    @Override
    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(this.permission, "permission");
        this.checkState((Object)this.matcher, "matcher");
    }

    protected void doActivate() throws Exception {
        this.matcher.setRevisionAuthorizer(this);
        this.matcher.activate();
    }

    protected void doDeactivate() throws Exception {
        this.matcher.deactivate();
        this.matcher.setRevisionAuthorizer(null);
    }

    public static abstract class KeyValueMatcher
    extends ValueMatcher {
        private String key;

        public final String getKey() {
            return this.key;
        }

        @AnnotationFactory.InjectAttribute(name="key")
        public final void setKey(String key) {
            this.checkInactive();
            this.key = key;
        }

        @Override
        protected void doBeforeActivate() throws Exception {
            super.doBeforeActivate();
            this.checkState(this.key, "key");
        }

        public static class LDAPGroupAttribute
        extends KeyValueMatcher {
            private LDAPUserAuthenticator ldapAuthenticator;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean matches(ISession session, IRepositoryProtector.UserInfo userInfo, CDOBranchPoint securityContext, CDORevisionProvider revisionProvider, CDORevision revision) {
                StringTester test = this.getTest();
                String value = this.getValue();
                String key = this.getKey();
                Set<LDAPUserAuthenticator.LDAPDN> groupDNs = ((LDAPUserAuthenticator.LDAPUserInfo)userInfo).groupDNs();
                for (LDAPUserAuthenticator.LDAPDN groupDN : groupDNs) {
                    Attribute attribute;
                    LDAPUserAuthenticator.LDAPEntry entry = this.ldapAuthenticator.ldapEntry(groupDN);
                    if (entry == null || (attribute = entry.attributes().get(key)) == null) continue;
                    try {
                        NamingEnumeration<?> enumeration = attribute.getAll();
                        while (enumeration.hasMore()) {
                            Object extractedValue = enumeration.next();
                            if (extractedValue == null || !test.test(extractedValue.toString(), value)) continue;
                            return true;
                        }
                    }
                    catch (NamingException ex) {
                        OM.LOG.error((Throwable)ex);
                    }
                }
                return false;
            }

            @Override
            protected Object extractValue(ISession session, IRepositoryProtector.UserInfo userInfo, CDOBranchPoint securityContext, CDORevisionProvider revisionProvider, CDORevision revision) throws Exception {
                throw new UnsupportedOperationException();
            }

            protected void doActivate() throws Exception {
                this.ldapAuthenticator = (LDAPUserAuthenticator)this.getRevisionAuthorizer().getRepositoryProtector().getUserAuthenticator();
            }

            protected void doDeactivate() throws Exception {
                this.ldapAuthenticator = null;
            }
        }

        public static class LDAPUserAttribute
        extends KeyValueMatcher {
            private LDAPUserAuthenticator ldapAuthenticator;

            @Override
            protected Object extractValue(ISession session, IRepositoryProtector.UserInfo userInfo, CDOBranchPoint securityContext, CDORevisionProvider revisionProvider, CDORevision revision) {
                NamingEnumeration<?> enumeration;
                LDAPUserAuthenticator.LDAPDN userDN = ((LDAPUserAuthenticator.LDAPUserInfo)userInfo).userDN();
                LDAPUserAuthenticator.LDAPEntry entry = this.ldapAuthenticator.ldapEntry(userDN);
                if (entry == null) {
                    return null;
                }
                Attribute attribute = entry.attributes().get(this.getKey());
                if (attribute == null) {
                    return null;
                }
                try {
                    enumeration = attribute.getAll();
                }
                catch (NamingException ex) {
                    OM.LOG.error((Throwable)ex);
                    return null;
                }
                final Iterator<String> iterator = new Iterator<String>(){

                    @Override
                    public boolean hasNext() {
                        try {
                            return enumeration.hasMore();
                        }
                        catch (NamingException ex) {
                            OM.LOG.error((Throwable)ex);
                            return false;
                        }
                    }

                    @Override
                    public String next() {
                        try {
                            Object next = enumeration.next();
                            return next == null ? null : next.toString();
                        }
                        catch (NamingException ex) {
                            OM.LOG.error((Throwable)ex);
                            return null;
                        }
                    }
                };
                return new Iterable<String>(){

                    @Override
                    public Iterator<String> iterator() {
                        return iterator;
                    }
                };
            }

            protected void doActivate() throws Exception {
                this.ldapAuthenticator = (LDAPUserAuthenticator)this.getRevisionAuthorizer().getRepositoryProtector().getUserAuthenticator();
            }

            protected void doDeactivate() throws Exception {
                this.ldapAuthenticator = null;
            }
        }

        public static class RepositoryProperty
        extends KeyValueMatcher {
            @Override
            protected Object extractValue(ISession session, IRepositoryProtector.UserInfo userInfo, CDOBranchPoint securityContext, CDORevisionProvider revisionProvider, CDORevision revision) {
                IRegistry properties = session.getRepository().properties();
                return properties.get((Object)this.getKey());
            }
        }

        public static class RevisionFeature
        extends KeyValueMatcher {
            private ValueMatcher.RevisionInstanceOf instanceOfMatcher;

            public final String getInstanceOf() {
                return this.instanceOfMatcher == null ? null : this.instanceOfMatcher.getValue();
            }

            @AnnotationFactory.InjectAttribute(name="instanceOf")
            public final void setInstanceOf(String instanceOf) {
                this.checkInactive();
                if (StringUtil.isEmpty((String)instanceOf)) {
                    this.instanceOfMatcher = null;
                } else {
                    this.instanceOfMatcher = new ValueMatcher.RevisionInstanceOf();
                    this.instanceOfMatcher.setValue(instanceOf);
                }
            }

            @Override
            public boolean matches(ISession session, IRepositoryProtector.UserInfo userInfo, CDOBranchPoint securityContext, CDORevisionProvider revisionProvider, CDORevision revision) {
                if (!super.matches(session, userInfo, securityContext, revisionProvider, revision)) {
                    return false;
                }
                return this.instanceOfMatcher == null || this.instanceOfMatcher.matches(session, userInfo, securityContext, revisionProvider, revision);
            }

            @Override
            protected Object extractValue(ISession session, IRepositoryProtector.UserInfo userInfo, CDOBranchPoint securityContext, CDORevisionProvider revisionProvider, CDORevision revision) {
                EStructuralFeature feature = revision.getEClass().getEStructuralFeature(this.getKey());
                if (feature == null) {
                    return null;
                }
                return ((InternalCDORevision)revision).getValue(feature);
            }

            protected void doActivate() throws Exception {
                super.doActivate();
                LifecycleUtil.activate((Object)((Object)this.instanceOfMatcher));
            }

            protected void doDeactivate() throws Exception {
                LifecycleUtil.deactivate((Object)((Object)this.instanceOfMatcher));
                super.doDeactivate();
            }
        }

        public static class SessionProperty
        extends KeyValueMatcher {
            @Override
            protected Object extractValue(ISession session, IRepositoryProtector.UserInfo userInfo, CDOBranchPoint securityContext, CDORevisionProvider revisionProvider, CDORevision revision) {
                IRegistry properties = session.properties();
                return properties.get((Object)this.getKey());
            }
        }
    }

    public static abstract class Matcher
    extends Lifecycle {
        public static final String PRODUCT_GROUP = "org.eclipse.emf.cdo.server.revisionAuthorizerMatchers";
        private DefaultRevisionAuthorizer revisionAuthorizer;
        private String id;

        public final DefaultRevisionAuthorizer getRevisionAuthorizer() {
            return this.revisionAuthorizer;
        }

        public final void setRevisionAuthorizer(DefaultRevisionAuthorizer revisionAuthorizer) {
            this.checkInactive();
            this.revisionAuthorizer = revisionAuthorizer;
        }

        public final String getID() {
            return this.id;
        }

        @AnnotationFactory.InjectAttribute(name="id")
        public final void setID(String id) {
            this.checkInactive();
            this.id = id;
        }

        public Matcher findMatcher(String id) {
            if (id != null && id.equals(this.id)) {
                return this;
            }
            return null;
        }

        public abstract boolean matches(ISession var1, IRepositoryProtector.UserInfo var2, CDOBranchPoint var3, CDORevisionProvider var4, CDORevision var5);

        public String toString() {
            String str = ((Object)((Object)this)).getClass().getSimpleName();
            if (this.id != null) {
                str = String.valueOf(str) + "[" + this.id + "]";
            }
            return str;
        }

        public static class False
        extends Matcher {
            @Override
            public boolean matches(ISession session, IRepositoryProtector.UserInfo userInfo, CDOBranchPoint securityContext, CDORevisionProvider revisionProvider, CDORevision revision) {
                return false;
            }
        }

        public static class True
        extends Matcher {
            @Override
            public boolean matches(ISession session, IRepositoryProtector.UserInfo userInfo, CDOBranchPoint securityContext, CDORevisionProvider revisionProvider, CDORevision revision) {
                return true;
            }
        }
    }

    public static abstract class OperationMatcher
    extends Matcher {
        private final ConcurrentArray<Matcher> arguments = new ConcurrentArray<Matcher>(){

            protected Matcher[] newArray(int length) {
                return new Matcher[length];
            }
        };

        public final Matcher[] getArguments() {
            return (Matcher[])this.arguments.get();
        }

        @AnnotationFactory.InjectElement(productGroup="org.eclipse.emf.cdo.server.revisionAuthorizerMatchers")
        public final void addArgument(Matcher argument) {
            this.checkInactive();
            this.arguments.add((Object)argument);
        }

        public final void removeArgument(Matcher argument) {
            this.checkInactive();
            this.arguments.remove((Object)argument);
        }

        @Override
        public Matcher findMatcher(String matcherID) {
            Matcher matcher = super.findMatcher(matcherID);
            if (matcher != null) {
                return matcher;
            }
            Matcher[] matcherArray = this.getArguments();
            int n = matcherArray.length;
            int n2 = 0;
            while (n2 < n) {
                Matcher argument = matcherArray[n2];
                matcher = argument.findMatcher(matcherID);
                if (matcher != null) {
                    return matcher;
                }
                ++n2;
            }
            return null;
        }

        protected void doBeforeActivate() throws Exception {
            this.checkState(((Matcher[])this.arguments.get()).length > 0, "arguments");
        }

        protected void doActivate() throws Exception {
            DefaultRevisionAuthorizer revisionAuthorizer = this.getRevisionAuthorizer();
            Matcher[] matcherArray = this.getArguments();
            int n = matcherArray.length;
            int n2 = 0;
            while (n2 < n) {
                Matcher argument = matcherArray[n2];
                argument.setRevisionAuthorizer(revisionAuthorizer);
                argument.activate();
                ++n2;
            }
        }

        protected void doDeactivate() throws Exception {
            Matcher[] matcherArray = this.getArguments();
            int n = matcherArray.length;
            int n2 = 0;
            while (n2 < n) {
                Matcher argument = matcherArray[n2];
                argument.deactivate();
                argument.setRevisionAuthorizer(null);
                ++n2;
            }
        }

        public static class And
        extends OperationMatcher {
            @Override
            public boolean matches(ISession session, IRepositoryProtector.UserInfo userInfo, CDOBranchPoint securityContext, CDORevisionProvider revisionProvider, CDORevision revision) {
                Matcher[] matcherArray = this.getArguments();
                int n = matcherArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Matcher argument = matcherArray[n2];
                    if (!argument.matches(session, userInfo, securityContext, revisionProvider, revision)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
        }

        public static class Not
        extends OperationMatcher {
            @Override
            public boolean matches(ISession session, IRepositoryProtector.UserInfo userInfo, CDOBranchPoint securityContext, CDORevisionProvider revisionProvider, CDORevision revision) {
                Matcher[] matcherArray = this.getArguments();
                int n = matcherArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Matcher argument = matcherArray[n2];
                    if (!argument.matches(session, userInfo, securityContext, revisionProvider, revision)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
        }

        public static class Or
        extends OperationMatcher {
            @Override
            public boolean matches(ISession session, IRepositoryProtector.UserInfo userInfo, CDOBranchPoint securityContext, CDORevisionProvider revisionProvider, CDORevision revision) {
                Matcher[] matcherArray = this.getArguments();
                int n = matcherArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Matcher argument = matcherArray[n2];
                    if (argument.matches(session, userInfo, securityContext, revisionProvider, revision)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        }

        public static class Xor
        extends OperationMatcher {
            @Override
            public boolean matches(ISession session, IRepositoryProtector.UserInfo userInfo, CDOBranchPoint securityContext, CDORevisionProvider revisionProvider, CDORevision revision) {
                int count = 0;
                Matcher[] matcherArray = this.getArguments();
                int n = matcherArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Matcher argument = matcherArray[n2];
                    if (argument.matches(session, userInfo, securityContext, revisionProvider, revision) && ++count > 1) {
                        return false;
                    }
                    ++n2;
                }
                return count == 1;
            }
        }
    }

    public static class RefMatcher
    extends Matcher {
        private String ref;
        private Matcher target;

        public final String getRef() {
            return this.ref;
        }

        @AnnotationFactory.InjectAttribute(name="ref")
        public final void setRef(String ref) {
            this.checkInactive();
            this.ref = ref;
        }

        @Override
        public boolean matches(ISession session, IRepositoryProtector.UserInfo userInfo, CDOBranchPoint securityContext, CDORevisionProvider revisionProvider, CDORevision revision) {
            return this.target.matches(session, userInfo, securityContext, revisionProvider, revision);
        }

        protected void doBeforeActivate() throws Exception {
            this.checkState(this.ref, "ref");
        }

        protected void doActivate() throws Exception {
            IRepositoryProtector protector = this.getRevisionAuthorizer().getRepositoryProtector();
            IRepositoryProtector.RevisionAuthorizer[] revisionAuthorizerArray = protector.getRevisionAuthorizers();
            int n = revisionAuthorizerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Matcher matcher;
                IRepositoryProtector.RevisionAuthorizer authorizer = revisionAuthorizerArray[n2];
                if (authorizer instanceof DefaultRevisionAuthorizer && (matcher = ((DefaultRevisionAuthorizer)authorizer).getMatcher().findMatcher(this.ref)) != null) {
                    this.target = matcher;
                    break;
                }
                ++n2;
            }
            if (this.target == null) {
                throw new IllegalStateException("Matcher '" + this.ref + "' not found");
            }
        }

        protected void doDeactivate() throws Exception {
            this.target = null;
        }
    }

    public static abstract class ValueMatcher
    extends Matcher {
        private StringTester test;
        private String value;
        private boolean recursive;

        public final StringTester getTest() {
            return this.test;
        }

        @AnnotationFactory.InjectAttribute(name="test", productGroup="org.eclipse.net4j.util.stringTesters")
        public final void setTest(StringTester test) {
            this.checkInactive();
            this.test = test;
        }

        public final String getValue() {
            return this.value;
        }

        @AnnotationFactory.InjectAttribute(name="value")
        public final void setValue(String value) {
            this.checkInactive();
            this.value = value;
        }

        public final boolean isRecursive() {
            return this.recursive;
        }

        public final void setRecursive(boolean recursive) {
            this.checkInactive();
            this.recursive = recursive;
        }

        @Override
        public boolean matches(ISession session, IRepositoryProtector.UserInfo userInfo, CDOBranchPoint securityContext, CDORevisionProvider revisionProvider, CDORevision revision) {
            Object extractedValue;
            try {
                extractedValue = this.extractValue(session, userInfo, securityContext, revisionProvider, revision);
            }
            catch (Exception ex) {
                return false;
            }
            if (extractedValue == null) {
                return false;
            }
            StringTester test = this.getTest();
            String value = this.getValue();
            return this.matchesValue(extractedValue, test, value);
        }

        protected boolean matchesValue(Object extractedValue, StringTester test, String value) {
            if (extractedValue instanceof Iterable) {
                for (Object element : (Iterable)extractedValue) {
                    if (element == null || !test.test(this.convertValue(element), value)) continue;
                    return true;
                }
                return this.matchesRecursively(extractedValue, test, value);
            }
            if (test.test(this.convertValue(extractedValue), value)) {
                return true;
            }
            return this.matchesRecursively(extractedValue, test, value);
        }

        protected boolean matchesRecursively(Object object, StringTester test, String value) {
            if (!this.recursive) {
                return false;
            }
            Object successor = this.computeSuccessor(object);
            if (successor == null) {
                return false;
            }
            if (successor instanceof Iterable) {
                for (Object element : (Iterable)successor) {
                    if (element == null || !this.matchesValue(element, test, value)) continue;
                    return true;
                }
                return false;
            }
            return this.matchesValue(successor, test, value);
        }

        protected Object computeSuccessor(Object object) {
            return null;
        }

        protected String convertValue(Object object) {
            return object.toString();
        }

        protected abstract Object extractValue(ISession var1, IRepositoryProtector.UserInfo var2, CDOBranchPoint var3, CDORevisionProvider var4, CDORevision var5) throws Exception;

        protected void doBeforeActivate() throws Exception {
            if (this.test == null) {
                this.test = StringTester.EQ;
            }
            this.checkState(this.value, "value");
        }

        public static class ContextBranchID
        extends ValueMatcher {
            @AnnotationFactory.InjectAttribute(name="subBranches")
            public final void setSubBranches(boolean subBranches) {
                this.setRecursive(subBranches);
            }

            @Override
            protected Object extractValue(ISession session, IRepositoryProtector.UserInfo userInfo, CDOBranchPoint securityContext, CDORevisionProvider revisionProvider, CDORevision revision) {
                return securityContext.getBranch();
            }

            @Override
            protected String convertValue(Object object) {
                return Integer.toString(((CDOBranch)object).getID());
            }

            @Override
            protected Object computeSuccessor(Object object) {
                CDOBranch branch = (CDOBranch)object;
                return branch.isMainBranch() ? null : branch.getBranch();
            }
        }

        public static class ContextBranchMain
        extends ValueMatcher {
            @Override
            protected Object extractValue(ISession session, IRepositoryProtector.UserInfo userInfo, CDOBranchPoint securityContext, CDORevisionProvider revisionProvider, CDORevision revision) {
                return securityContext.getBranch().isMainBranch();
            }
        }

        public static class ContextBranchName
        extends ContextBranchID {
            @Override
            protected String convertValue(Object object) {
                return ((CDOBranch)object).getName();
            }
        }

        public static class ContextBranchPath
        extends ContextBranchID {
            @Override
            protected String convertValue(Object object) {
                return ((CDOBranch)object).getPathName();
            }
        }

        public static class ContextHistorical
        extends ValueMatcher {
            @Override
            protected Object extractValue(ISession session, IRepositoryProtector.UserInfo userInfo, CDOBranchPoint securityContext, CDORevisionProvider revisionProvider, CDORevision revision) {
                if (securityContext.getBranch().getTimeStamp() != 0L) {
                    return true;
                }
                return false;
            }
        }

        public static class ContextTimeStamp
        extends ValueMatcher {
            @Override
            protected Object extractValue(ISession session, IRepositoryProtector.UserInfo userInfo, CDOBranchPoint securityContext, CDORevisionProvider revisionProvider, CDORevision revision) {
                return securityContext.getBranch().getTimeStamp();
            }
        }

        public static class LDAPGroupDN
        extends ValueMatcher {
            @Override
            protected Object extractValue(ISession session, IRepositoryProtector.UserInfo userInfo, CDOBranchPoint securityContext, CDORevisionProvider revisionProvider, CDORevision revision) {
                return ((LDAPUserAuthenticator.LDAPUserInfo)userInfo).groupDNs();
            }
        }

        public static class LDAPUserDN
        extends ValueMatcher {
            @Override
            protected Object extractValue(ISession session, IRepositoryProtector.UserInfo userInfo, CDOBranchPoint securityContext, CDORevisionProvider revisionProvider, CDORevision revision) {
                return ((LDAPUserAuthenticator.LDAPUserInfo)userInfo).userDN();
            }
        }

        public static class RepositoryName
        extends ValueMatcher {
            @Override
            protected Object extractValue(ISession session, IRepositoryProtector.UserInfo userInfo, CDOBranchPoint securityContext, CDORevisionProvider revisionProvider, CDORevision revision) {
                return session.getRepository().getName();
            }
        }

        public static class RepositoryPrimary
        extends ValueMatcher {
            @Override
            protected Object extractValue(ISession session, IRepositoryProtector.UserInfo userInfo, CDOBranchPoint securityContext, CDORevisionProvider revisionProvider, CDORevision revision) {
                if (session.getRepository() == this.getRevisionAuthorizer().getRepositoryProtector().getRepository()) {
                    return true;
                }
                return false;
            }
        }

        public static class RepositoryUUID
        extends ValueMatcher {
            @Override
            protected Object extractValue(ISession session, IRepositoryProtector.UserInfo userInfo, CDOBranchPoint securityContext, CDORevisionProvider revisionProvider, CDORevision revision) {
                return session.getRepository().getUUID();
            }
        }

        public static class RevisionBranchID
        extends ValueMatcher {
            @AnnotationFactory.InjectAttribute(name="subBranches")
            public final void setSubBranches(boolean subBranches) {
                this.setRecursive(subBranches);
            }

            @Override
            protected Object extractValue(ISession session, IRepositoryProtector.UserInfo userInfo, CDOBranchPoint securityContext, CDORevisionProvider revisionProvider, CDORevision revision) {
                return revision.getBranch();
            }

            @Override
            protected String convertValue(Object object) {
                return Integer.toString(((CDOBranch)object).getID());
            }

            @Override
            protected Object computeSuccessor(Object object) {
                CDOBranch branch = (CDOBranch)object;
                return branch.isMainBranch() ? null : branch.getBranch();
            }
        }

        public static class RevisionBranchMain
        extends ValueMatcher {
            @Override
            protected Object extractValue(ISession session, IRepositoryProtector.UserInfo userInfo, CDOBranchPoint securityContext, CDORevisionProvider revisionProvider, CDORevision revision) {
                return revision.getBranch().isMainBranch();
            }
        }

        public static class RevisionBranchName
        extends RevisionBranchID {
            @Override
            protected String convertValue(Object object) {
                return ((CDOBranch)object).getName();
            }
        }

        public static class RevisionBranchPath
        extends RevisionBranchID {
            @Override
            protected String convertValue(Object object) {
                return ((CDOBranch)object).getPathName();
            }
        }

        public static class RevisionClass
        extends ValueMatcher {
            @AnnotationFactory.InjectAttribute(name="subClasses")
            public final void setSubClasses(boolean subClasses) {
                this.setRecursive(subClasses);
            }

            @Override
            protected Object extractValue(ISession session, IRepositoryProtector.UserInfo userInfo, CDOBranchPoint securityContext, CDORevisionProvider revisionProvider, CDORevision revision) {
                return revision.getEClass();
            }

            @Override
            protected String convertValue(Object object) {
                return EcoreUtil.getURI((EObject)((EClass)object)).toString();
            }

            @Override
            protected Object computeSuccessor(Object object) {
                EList superTypes = ((EClass)object).getESuperTypes();
                return superTypes.isEmpty() ? null : superTypes;
            }
        }

        public static class RevisionClassName
        extends RevisionClass {
            @Override
            protected String convertValue(Object object) {
                return ((EClass)object).getName();
            }
        }

        public static class RevisionID
        extends ValueMatcher {
            @Override
            protected Object extractValue(ISession session, IRepositoryProtector.UserInfo userInfo, CDOBranchPoint securityContext, CDORevisionProvider revisionProvider, CDORevision revision) {
                return revision.getID();
            }
        }

        public static class RevisionInstanceOf
        extends RevisionClass {
            public RevisionInstanceOf() {
                this.setSubClasses(true);
            }
        }

        public static class RevisionPackage
        extends ValueMatcher {
            @AnnotationFactory.InjectAttribute(name="subPackages")
            public final void setSubPackages(boolean subPackages) {
                this.setRecursive(subPackages);
            }

            @Override
            protected Object extractValue(ISession session, IRepositoryProtector.UserInfo userInfo, CDOBranchPoint securityContext, CDORevisionProvider revisionProvider, CDORevision revision) {
                return revision.getEClass().getEPackage();
            }

            @Override
            protected String convertValue(Object object) {
                return ((EPackage)object).getNsURI();
            }

            @Override
            protected Object computeSuccessor(Object object) {
                EObject container = ((EPackage)object).eContainer();
                return container instanceof EPackage ? container : null;
            }
        }

        public static class RevisionPackageName
        extends RevisionPackage {
            @Override
            protected String convertValue(Object object) {
                return ((EPackage)object).getName();
            }
        }

        public static class RevisionRevised
        extends ValueMatcher {
            @Override
            protected Object extractValue(ISession session, IRepositoryProtector.UserInfo userInfo, CDOBranchPoint securityContext, CDORevisionProvider revisionProvider, CDORevision revision) {
                return revision.getRevised();
            }
        }

        public static class RevisionTimeStamp
        extends ValueMatcher {
            @Override
            protected Object extractValue(ISession session, IRepositoryProtector.UserInfo userInfo, CDOBranchPoint securityContext, CDORevisionProvider revisionProvider, CDORevision revision) {
                return revision.getTimeStamp();
            }
        }

        public static class UserAdministrator
        extends ValueMatcher {
            @Override
            protected Object extractValue(ISession session, IRepositoryProtector.UserInfo userInfo, CDOBranchPoint securityContext, CDORevisionProvider revisionProvider, CDORevision revision) {
                String userID = userInfo.userID();
                IRepositoryProtector.UserAuthenticator authenticator = this.getRevisionAuthorizer().getRepositoryProtector().getUserAuthenticator();
                return authenticator.isAdministrator(userID);
            }
        }

        public static class UserID
        extends ValueMatcher {
            @Override
            protected Object extractValue(ISession session, IRepositoryProtector.UserInfo userInfo, CDOBranchPoint securityContext, CDORevisionProvider revisionProvider, CDORevision revision) {
                return userInfo.userID();
            }
        }
    }
}

