/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.revision;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.egit.core.internal.storage.CommitFileRevision;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.PreferenceBasedDateFormatter;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class FileRevisionEditorInput
extends PlatformObject
implements IWorkbenchAdapter,
IStorageEditorInput,
IPathEditorInput {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMdd_HHmmss");
    private final IFileRevision fileRevision;
    private final IStorage storage;
    private IPath tmpFile;

    public static FileRevisionEditorInput createEditorInputFor(IFileRevision revision, IProgressMonitor monitor) throws CoreException {
        IStorage storage = revision.getStorage(monitor);
        return new FileRevisionEditorInput(revision, storage);
    }

    private static IStorage wrapStorage(final IStorage storage, final String charset) {
        if (charset == null) {
            return storage;
        }
        if (storage instanceof IFileState) {
            return new IFileState(){

                public <T> T getAdapter(Class<T> adapter) {
                    return (T)Adapters.adapt((Object)storage, adapter);
                }

                public boolean isReadOnly() {
                    return storage.isReadOnly();
                }

                public String getName() {
                    return storage.getName();
                }

                public IPath getFullPath() {
                    return storage.getFullPath();
                }

                public InputStream getContents() throws CoreException {
                    return storage.getContents();
                }

                public String getCharset() throws CoreException {
                    return charset;
                }

                public boolean exists() {
                    return ((IFileState)storage).exists();
                }

                public long getModificationTime() {
                    return ((IFileState)storage).getModificationTime();
                }
            };
        }
        return new IEncodedStorage(){

            public <T> T getAdapter(Class<T> adapter) {
                return (T)Adapters.adapt((Object)storage, adapter);
            }

            public boolean isReadOnly() {
                return storage.isReadOnly();
            }

            public String getName() {
                return storage.getName();
            }

            public IPath getFullPath() {
                return storage.getFullPath();
            }

            public InputStream getContents() throws CoreException {
                return storage.getContents();
            }

            public String getCharset() throws CoreException {
                return charset;
            }
        };
    }

    public FileRevisionEditorInput(IFileRevision revision, IStorage storage) {
        Assert.isNotNull((Object)revision);
        Assert.isNotNull((Object)storage);
        this.fileRevision = revision;
        this.storage = storage;
    }

    public FileRevisionEditorInput(IFileRevision revision, IStorage storage, String charset) {
        this(revision, FileRevisionEditorInput.wrapStorage(storage, charset));
    }

    public IStorage getStorage() throws CoreException {
        return this.storage;
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    private String abbreviate(String id) {
        if (id.length() > 7) {
            return id.substring(0, 7);
        }
        return id;
    }

    public String getName() {
        IFileRevision rev = (IFileRevision)Adapters.adapt((Object)((Object)this), IFileRevision.class);
        if (rev != null) {
            String identifier = rev instanceof CommitFileRevision ? this.abbreviate(rev.getContentIdentifier()) : rev.getContentIdentifier();
            return MessageFormat.format(UIText.FileRevisionEditorInput_NameAndRevisionTitle, rev.getName(), identifier);
        }
        IFileState state = (IFileState)Adapters.adapt((Object)((Object)this), IFileState.class);
        if (state != null) {
            return state.getName() + " " + PreferenceBasedDateFormatter.create().formatDate(new Date(state.getModificationTime()));
        }
        return this.storage.getName();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.storage.getFullPath().toString();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IWorkbenchAdapter.class) {
            return adapter.cast((Object)this);
        }
        if (adapter == IStorage.class) {
            return adapter.cast(this.storage);
        }
        Object object = super.getAdapter(adapter);
        if (object != null) {
            return adapter.cast(object);
        }
        return (T)Adapters.adapt((Object)this.fileRevision, adapter);
    }

    public Object[] getChildren(Object o) {
        return new Object[0];
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public String getLabel(Object o) {
        IFileRevision rev = (IFileRevision)Adapters.adapt((Object)((Object)this), IFileRevision.class);
        if (rev != null) {
            return rev.getName();
        }
        return this.storage.getName();
    }

    public Object getParent(Object o) {
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FileRevisionEditorInput) {
            FileRevisionEditorInput other = (FileRevisionEditorInput)((Object)obj);
            return other.fileRevision.equals(this.fileRevision);
        }
        return false;
    }

    public int hashCode() {
        return this.fileRevision.hashCode();
    }

    public IFileRevision getFileRevision() {
        return this.fileRevision;
    }

    public URI getURI() {
        return this.fileRevision.getURI();
    }

    public IPath getPath() {
        if (this.tmpFile == null) {
            this.tmpFile = this.writeTempFile();
        }
        return this.tmpFile;
    }

    private IPath writeTempFile() {
        java.nio.file.Path path;
        try {
            Object tempName = this.getRevisionPrefix() + this.storage.getName();
            if (((String)tempName).length() > 200) {
                tempName = this.storage.getName();
            }
            path = Files.createTempDirectory(Activator.getDefault().getStateLocation().toFile().toPath(), "egit", new FileAttribute[0]).resolve((String)tempName);
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream in = this.storage.getContents();){
                Files.copy(in, path, new CopyOption[0]);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            path = path.toAbsolutePath();
        }
        catch (IOException | CoreException e) {
            Activator.logError(MessageFormat.format(UIText.FileRevisionEditorInput_cannotWriteTempFile, this.storage.getName()), e);
            return new Path("");
        }
        File file = path.toFile();
        file.setReadOnly();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (file.setWritable(true) && file.delete()) {
                file.getParentFile().delete();
            } else {
                file.setReadOnly();
            }
        }));
        return new Path(path.toString());
    }

    private String getRevisionPrefix() {
        IFileRevision rev = (IFileRevision)Adapters.adapt((Object)((Object)this), IFileRevision.class);
        if (rev != null) {
            return this.abbreviate(rev.getContentIdentifier()) + "_";
        }
        IFileState state = (IFileState)Adapters.adapt((Object)((Object)this), IFileState.class);
        if (state != null) {
            return DATE_FORMAT.format(new Date(state.getModificationTime())) + "_";
        }
        return "";
    }
}

