/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.history.FindResults;
import org.eclipse.egit.ui.internal.history.FindToolbarJob;
import org.eclipse.egit.ui.internal.history.IFindListener;
import org.eclipse.egit.ui.internal.history.SWTCommit;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class FindToolbar
extends Composite {
    private static final String NO_RESULTS_CLASS = "org-eclipse-egit-ui-FindToolbar-noResults";
    public static final int PREFS_FINDIN_ALL = 0;
    private static final int PREFS_FINDIN_COMMENTS = 1;
    private static final int PREFS_FINDIN_AUTHOR = 2;
    private static final int PREFS_FINDIN_COMMITID = 3;
    private static final int PREFS_FINDIN_COMMITTER = 4;
    private static final int PREFS_FINDIN_REFERENCE = 5;
    private final FindResults findResults;
    private IFindListener listener;
    private IPersistentPreferenceStore store = (IPersistentPreferenceStore)Activator.getDefault().getPreferenceStore();
    private List<Listener> eventList = new ArrayList<Listener>();
    private Table historyTable;
    private SWTCommit[] fileRevisions;
    private Text patternField;
    private ModifyListener patternModifyListener;
    private Action findNextAction;
    private Action findPreviousAction;
    private String lastSearchPattern;
    private String lastErrorPattern;
    private ToolItem prefsDropDown;
    private Menu prefsMenu;
    private MenuItem caseItem;
    private MenuItem allItem;
    private MenuItem commitIdItem;
    private MenuItem commentsItem;
    private MenuItem authorItem;
    private MenuItem committerItem;
    private MenuItem referenceItem;
    private Image allIcon;
    private Image commitIdIcon;
    private Image commentsIcon;
    private Image authorIcon;
    private Image committerIcon;
    private Image branchesIcon;
    private FindToolbarJob job;
    private int currentPosition = -1;
    private ObjectId preselect;
    private CopyOnWriteArrayList<StatusListener> layoutListeners = new CopyOnWriteArrayList();
    private boolean noResults = false;

    public FindToolbar(Composite parent) {
        super(parent, 0);
        this.findResults = new FindResults();
        this.listener = this.createFindListener();
        this.findResults.addFindListener(this.listener);
        this.setBackground(null);
        this.createToolbar();
    }

    private void createToolbar() {
        ResourceManager resourceManager = Activator.getDefault().getResourceManager();
        this.allIcon = UIIcons.getImage(resourceManager, UIIcons.SEARCH_COMMIT);
        this.commitIdIcon = UIIcons.getImage(resourceManager, UIIcons.ELCL16_ID);
        this.commentsIcon = UIIcons.getImage(resourceManager, UIIcons.ELCL16_COMMENTS);
        this.authorIcon = UIIcons.getImage(resourceManager, UIIcons.ELCL16_AUTHOR);
        this.committerIcon = UIIcons.getImage(resourceManager, UIIcons.ELCL16_COMMITTER);
        this.branchesIcon = UIIcons.getImage(resourceManager, UIIcons.BRANCHES);
        GridLayout findLayout = new GridLayout();
        findLayout.marginHeight = 0;
        findLayout.marginBottom = 1;
        findLayout.marginWidth = 0;
        findLayout.numColumns = 2;
        this.setLayout((Layout)findLayout);
        this.setLayoutData(new GridData(4, 128, false, false));
        this.patternField = new Text((Composite)this, 896);
        GridData findTextData = new GridData(4, 128, true, false);
        findTextData.minimumWidth = 150;
        this.patternField.setLayoutData((Object)findTextData);
        this.patternField.setMessage(UIText.HistoryPage_findbar_find_msg);
        this.patternField.setTextLimit(100);
        ToolBarManager manager = new ToolBarManager(256);
        this.findNextAction = new Action(){

            public void run() {
                FindToolbar.this.findNext();
            }
        };
        this.findNextAction.setImageDescriptor(UIIcons.ELCL16_NEXT);
        this.findNextAction.setText(UIText.HistoryPage_findbar_next);
        this.findNextAction.setToolTipText(UIText.FindToolbar_NextTooltip);
        this.findNextAction.setEnabled(false);
        manager.add((IAction)this.findNextAction);
        this.findPreviousAction = new Action(){

            public void run() {
                FindToolbar.this.findPrevious();
            }
        };
        this.findPreviousAction.setImageDescriptor(UIIcons.ELCL16_PREVIOUS);
        this.findPreviousAction.setText(UIText.HistoryPage_findbar_previous);
        this.findPreviousAction.setToolTipText(UIText.FindToolbar_PreviousTooltip);
        this.findPreviousAction.setEnabled(false);
        manager.add((IAction)this.findPreviousAction);
        final ToolBar toolBar = manager.createControl((Composite)this);
        toolBar.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.prefsDropDown = new ToolItem(toolBar, 4);
        this.prefsMenu = new Menu((Decorations)this.getShell(), 8);
        this.caseItem = new MenuItem(this.prefsMenu, 32);
        this.caseItem.setText(UIText.HistoryPage_findbar_ignorecase);
        new MenuItem(this.prefsMenu, 2);
        this.allItem = this.createFindInMenuItem();
        this.allItem.setText(UIText.HistoryPage_findbar_all);
        this.allItem.setImage(this.allIcon);
        this.commentsItem = this.createFindInMenuItem();
        this.commentsItem.setText(UIText.HistoryPage_findbar_comments);
        this.commentsItem.setImage(this.commentsIcon);
        this.authorItem = this.createFindInMenuItem();
        this.authorItem.setText(UIText.HistoryPage_findbar_author);
        this.authorItem.setImage(this.authorIcon);
        this.commitIdItem = this.createFindInMenuItem();
        this.commitIdItem.setText(UIText.HistoryPage_findbar_commit);
        this.commitIdItem.setImage(this.commitIdIcon);
        this.committerItem = this.createFindInMenuItem();
        this.committerItem.setText(UIText.HistoryPage_findbar_committer);
        this.committerItem.setImage(this.committerIcon);
        this.referenceItem = this.createFindInMenuItem();
        this.referenceItem.setText(UIText.HistoryPage_findbar_reference);
        this.referenceItem.setImage(this.branchesIcon);
        this.prefsDropDown.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 4) {
                    Rectangle itemBounds = FindToolbar.this.prefsDropDown.getBounds();
                    Point point = toolBar.toDisplay(itemBounds.x, itemBounds.y + itemBounds.height);
                    FindToolbar.this.prefsMenu.setLocation(point);
                    FindToolbar.this.prefsMenu.setVisible(true);
                } else if (FindToolbar.this.allItem.getSelection()) {
                    FindToolbar.this.selectFindInItem(FindToolbar.this.commentsItem);
                } else if (FindToolbar.this.commentsItem.getSelection()) {
                    FindToolbar.this.selectFindInItem(FindToolbar.this.authorItem);
                } else if (FindToolbar.this.authorItem.getSelection()) {
                    FindToolbar.this.selectFindInItem(FindToolbar.this.commitIdItem);
                } else if (FindToolbar.this.commitIdItem.getSelection()) {
                    FindToolbar.this.selectFindInItem(FindToolbar.this.committerItem);
                } else if (FindToolbar.this.committerItem.getSelection()) {
                    FindToolbar.this.selectFindInItem(FindToolbar.this.referenceItem);
                } else if (FindToolbar.this.referenceItem.getSelection()) {
                    FindToolbar.this.selectFindInItem(FindToolbar.this.allItem);
                }
            }
        });
        this.patternModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String pattern = FindToolbar.this.getSearchPattern();
                if (pattern.equals(FindToolbar.this.lastSearchPattern)) {
                    return;
                }
                if (pattern.isEmpty()) {
                    FindToolbar.this.setNormalBackgroundColor();
                }
                FindToolbarJob finder = FindToolbar.this.createFinder();
                finder.setUser(false);
                finder.schedule(200L);
            }
        };
        this.patternField.addModifyListener(this.patternModifyListener);
        this.patternField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (e.detail != 256 && !FindToolbar.this.getSearchPattern().isEmpty()) {
                    FindToolbarJob finder = FindToolbar.this.createFinder();
                    finder.setUser(false);
                    finder.schedule();
                }
            }
        });
        this.patternField.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    FindToolbar.this.findNext();
                } else if (e.keyCode == 0x1000001) {
                    FindToolbar.this.findPrevious();
                }
            }
        });
        this.caseItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindToolbar.this.store.setValue("findtoolbar_ignore_case", FindToolbar.this.caseItem.getSelection());
                if (FindToolbar.this.store.needsSaving()) {
                    try {
                        FindToolbar.this.store.save();
                    }
                    catch (IOException e1) {
                        Activator.handleError(e1.getMessage(), e1, false);
                    }
                }
                FindToolbar.this.clear();
            }
        });
        this.caseItem.setSelection(this.store.getBoolean("findtoolbar_ignore_case"));
        int selectedPrefsItem = this.store.getInt("findtoolbar_find_in");
        if (selectedPrefsItem == 0) {
            this.selectFindInItem(this.allItem);
        } else if (selectedPrefsItem == 1) {
            this.selectFindInItem(this.commentsItem);
        } else if (selectedPrefsItem == 2) {
            this.selectFindInItem(this.authorItem);
        } else if (selectedPrefsItem == 3) {
            this.selectFindInItem(this.commitIdItem);
        } else if (selectedPrefsItem == 4) {
            this.selectFindInItem(this.committerItem);
        } else if (selectedPrefsItem == 5) {
            this.selectFindInItem(this.referenceItem);
        }
        this.registerDisposal();
    }

    private void registerDisposal() {
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FindToolbar.this.findResults.removeFindListener(FindToolbar.this.listener);
                FindToolbar.this.findResults.clear();
                FindToolbar.this.listener = null;
                if (FindToolbar.this.job != null) {
                    FindToolbar.this.job.cancel();
                    FindToolbar.this.job = null;
                }
                FindToolbar.this.prefsMenu.dispose();
                if (FindToolbar.this.historyTable != null && !FindToolbar.this.historyTable.isDisposed()) {
                    FindToolbar.this.historyTable.clearAll();
                }
            }
        });
    }

    private void setNotFoundBackgroundColor() {
        UIUtils.setCssClass((Widget)this.patternField, NO_RESULTS_CLASS);
        this.patternField.reskin(1);
        this.noResults = true;
    }

    private void setNormalBackgroundColor() {
        if (this.noResults) {
            Color currentColor = this.patternField.getBackground();
            UIUtils.setCssClass((Widget)this.patternField, null);
            this.patternField.reskin(1);
            if (currentColor.equals((Object)this.patternField.getBackground())) {
                this.patternField.setBackground(null);
            }
            this.noResults = false;
        }
    }

    public void setPreselect(ObjectId commitId) {
        this.preselect = commitId;
    }

    public boolean setFocus() {
        return this.patternField.setFocus();
    }

    public void setText(String text, boolean search) {
        if (!search) {
            this.patternField.removeModifyListener(this.patternModifyListener);
        }
        this.patternField.setText(text);
        if (!search) {
            this.patternField.addModifyListener(this.patternModifyListener);
        }
    }

    public void setText(String text) {
        this.setText(text, false);
    }

    public String getText() {
        return this.patternField.getText();
    }

    private String getSearchPattern() {
        return this.getText().trim();
    }

    public void addListener(int evtType, Listener mouseListener) {
        this.patternField.addListener(evtType, mouseListener);
    }

    public void removeListener(int evtType, Listener mouseListener) {
        this.patternField.removeListener(evtType, mouseListener);
    }

    public void addKeyListener(KeyListener keyListener) {
        this.patternField.addKeyListener(keyListener);
    }

    public void removeKeyListener(KeyListener keyListener) {
        this.patternField.removeKeyListener(keyListener);
    }

    public void addStatusListener(StatusListener layoutListener) {
        this.layoutListeners.addIfAbsent(layoutListener);
    }

    public void removeStatusListener(StatusListener layoutListener) {
        this.layoutListeners.remove(layoutListener);
    }

    private void notifyStatus(String text) {
        for (StatusListener l : this.layoutListeners) {
            l.setMessage(this, text);
        }
    }

    private void findNext() {
        this.find(true);
    }

    private void findPrevious() {
        this.find(false);
    }

    private void find(boolean next) {
        if (!this.getSearchPattern().isEmpty() && this.findResults.size() == 0) {
            FindToolbarJob finder = this.createFinder();
            finder.setUser(false);
            finder.schedule();
            this.patternField.setSelection(0, 0);
        } else {
            int currentIx = this.historyTable.getSelectionIndex();
            int newIx = -1;
            if (next) {
                newIx = this.findResults.getIndexAfter(currentIx);
                if (newIx == -1) {
                    newIx = this.findResults.getFirstIndex();
                }
            } else {
                newIx = this.findResults.getIndexBefore(currentIx);
                if (newIx == -1) {
                    newIx = this.findResults.getLastIndex();
                }
            }
            this.notifyListeners(newIx);
            String current = null;
            this.currentPosition = this.findResults.getMatchNumberFor(newIx);
            current = this.currentPosition == -1 ? "-" : String.valueOf(this.currentPosition);
            this.notifyStatus(current + "/" + this.findResults.size());
        }
    }

    private MenuItem createFindInMenuItem() {
        final MenuItem menuItem = new MenuItem(this.prefsMenu, 16);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindToolbar.this.selectFindInItem(menuItem);
            }
        });
        return menuItem;
    }

    private void selectFindInItem(MenuItem menuItem) {
        if (menuItem == this.allItem) {
            this.selectFindInItem(menuItem, 0, this.allIcon, UIText.HistoryPage_findbar_changeto_comments);
        } else if (menuItem == this.commentsItem) {
            this.selectFindInItem(menuItem, 1, this.commentsIcon, UIText.HistoryPage_findbar_changeto_author);
        } else if (menuItem == this.authorItem) {
            this.selectFindInItem(menuItem, 2, this.authorIcon, UIText.HistoryPage_findbar_changeto_commit);
        } else if (menuItem == this.commitIdItem) {
            this.selectFindInItem(menuItem, 3, this.commitIdIcon, UIText.HistoryPage_findbar_changeto_committer);
        } else if (menuItem == this.committerItem) {
            this.selectFindInItem(menuItem, 4, this.committerIcon, UIText.HistoryPage_findbar_changeto_reference);
        } else if (menuItem == this.referenceItem) {
            this.selectFindInItem(menuItem, 5, this.branchesIcon, UIText.HistoryPage_findbar_changeto_all);
        }
    }

    private void selectFindInItem(MenuItem menuItem, int preferenceValue, Image dropDownIcon, String dropDownToolTip) {
        this.prefsDropDown.setImage(dropDownIcon);
        this.prefsDropDown.setToolTipText(dropDownToolTip);
        this.findInPreferenceChanged(preferenceValue, menuItem);
    }

    private void findInPreferenceChanged(int findin, MenuItem item) {
        this.store.setValue("findtoolbar_find_in", findin);
        if (this.store.needsSaving()) {
            try {
                this.store.save();
            }
            catch (IOException e) {
                Activator.handleError(e.getMessage(), e, false);
            }
        }
        this.allItem.setSelection(false);
        this.commitIdItem.setSelection(false);
        this.commentsItem.setSelection(false);
        this.authorItem.setSelection(false);
        this.committerItem.setSelection(false);
        this.referenceItem.setSelection(false);
        item.setSelection(true);
        this.clear();
    }

    private FindToolbarJob createFinder() {
        if (this.job != null) {
            this.job.cancel();
        }
        final String currentPattern = this.getSearchPattern();
        this.job = new FindToolbarJob(MessageFormat.format(UIText.HistoryPage_findbar_find, currentPattern), this.findResults);
        this.job.pattern = currentPattern;
        this.job.fileRevisions = this.fileRevisions;
        this.job.ignoreCase = this.caseItem.getSelection();
        if (this.allItem.getSelection()) {
            this.job.findInCommitId = true;
            this.job.findInComments = true;
            this.job.findInAuthor = true;
            this.job.findInCommitter = true;
            this.job.findInReference = true;
        } else {
            this.job.findInCommitId = this.commitIdItem.getSelection();
            this.job.findInComments = this.commentsItem.getSelection();
            this.job.findInAuthor = this.authorItem.getSelection();
            this.job.findInCommitter = this.committerItem.getSelection();
            this.job.findInReference = this.referenceItem.getSelection();
        }
        this.job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){
            private final FindToolbarJob myJob;
            {
                this.myJob = FindToolbar.this.job;
            }

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    FindToolbar.this.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (myJob != (this).FindToolbar.this.job || myJob.fileRevisions != (this).FindToolbar.this.fileRevisions) {
                                return;
                            }
                            if (!FindToolbar.this.isDisposed()) {
                                FindToolbar.this.findCompletionUpdate(currentPattern, (this).FindToolbar.this.findResults.isOverflow());
                            }
                        }
                    });
                }
            }
        });
        return this.job;
    }

    void setInput(RevFlag hFlag, Table historyTable, SWTCommit[] commitArray) {
        if (this.job != null) {
            this.job.cancel();
        }
        this.lastSearchPattern = null;
        this.fileRevisions = commitArray;
        this.historyTable = historyTable;
        this.findResults.setHighlightFlag(hFlag);
    }

    private void findCompletionUpdate(String pattern, boolean overflow) {
        Object label;
        this.lastSearchPattern = pattern;
        int total = this.findResults.size();
        if (total > 0) {
            String position = this.currentPosition < 0 ? "1" : Integer.toString(this.currentPosition);
            label = overflow ? UIText.HistoryPage_findbar_exceeded + " " + position + "/" + total : position + "/" + total;
            if (this.currentPosition < 0) {
                this.currentPosition = 1;
                int ix = this.findResults.getFirstIndex();
                this.notifyListeners(ix);
            }
            this.setNormalBackgroundColor();
            this.findNextAction.setEnabled(total > 1);
            this.findPreviousAction.setEnabled(total > 1);
            this.lastErrorPattern = null;
        } else {
            this.currentPosition = -1;
            if (pattern.length() > 0) {
                this.setNotFoundBackgroundColor();
                label = UIText.HistoryPage_findbar_notFound;
                if (this.lastErrorPattern == null || !this.lastErrorPattern.startsWith(pattern)) {
                    this.getDisplay().beep();
                    this.findNextAction.setEnabled(false);
                    this.findPreviousAction.setEnabled(false);
                }
                this.lastErrorPattern = pattern;
            } else {
                this.setNormalBackgroundColor();
                label = "";
                this.findNextAction.setEnabled(false);
                this.findPreviousAction.setEnabled(false);
                this.lastErrorPattern = null;
            }
        }
        this.historyTable.clearAll();
        if (overflow) {
            Display display = this.getDisplay();
            display.beep();
        }
        this.notifyStatus((String)label);
    }

    void clear() {
        if (!this.isDisposed()) {
            this.setNormalBackgroundColor();
            if (this.patternField.getText().length() > 0) {
                this.patternField.selectAll();
            }
        }
        this.lastErrorPattern = null;
        if (this.job != null) {
            this.job.cancel();
            this.job = null;
        }
        this.findResults.clear();
    }

    private void notifyListeners(int index) {
        if (index >= 0) {
            Event event = new Event();
            event.type = 13;
            event.index = index;
            event.widget = this;
            event.data = this.fileRevisions[index];
            for (Listener toNotify : this.eventList) {
                toNotify.handleEvent(event);
            }
        }
    }

    public void addSelectionListener(Listener selectionListener) {
        this.eventList.add(selectionListener);
    }

    public void removeSelectionListener(Listener selectionListener) {
        this.eventList.remove(selectionListener);
    }

    private IFindListener createFindListener() {
        return new IFindListener(){
            private static final long UPDATE_INTERVAL = 200L;
            private long lastUpdate = 0L;

            @Override
            public void itemAdded(final int index, RevObject rev) {
                long now = System.currentTimeMillis();
                if (FindToolbar.this.preselect != null && FindToolbar.this.preselect.equals((AnyObjectId)rev.getId()) || FindToolbar.this.preselect == null && FindToolbar.this.currentPosition < 0) {
                    FindToolbar.this.currentPosition = FindToolbar.this.findResults.getMatchNumberFor(index);
                    FindToolbar.this.preselect = null;
                    FindToolbar.this.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            FindToolbar.this.notifyListeners(index);
                        }
                    });
                }
                if (now - this.lastUpdate > 200L && !FindToolbar.this.isDisposed()) {
                    final boolean firstUpdate = this.lastUpdate == 0L;
                    this.lastUpdate = now;
                    FindToolbar.this.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (FindToolbar.this.isDisposed()) {
                                return;
                            }
                            int total = (this).FindToolbar.this.findResults.size();
                            if (total > 0) {
                                String label = (this).FindToolbar.this.currentPosition == -1 ? "-/" + total : Integer.toString((this).FindToolbar.this.currentPosition) + "/" + total;
                                (this).FindToolbar.this.findNextAction.setEnabled(total > 1);
                                (this).FindToolbar.this.findPreviousAction.setEnabled(total > 1);
                                FindToolbar.this.setNormalBackgroundColor();
                                if (firstUpdate) {
                                    (this).FindToolbar.this.historyTable.clearAll();
                                }
                                FindToolbar.this.notifyStatus(label);
                            } else {
                                this.clear();
                            }
                        }
                    });
                }
            }

            @Override
            public void cleared() {
                this.lastUpdate = 0L;
                if (Display.getCurrent() == null) {
                    FindToolbar.this.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            this.clear();
                        }
                    });
                } else {
                    this.clear();
                }
            }

            private void clear() {
                FindToolbar.this.currentPosition = -1;
                if (!FindToolbar.this.isDisposed()) {
                    FindToolbar.this.findNextAction.setEnabled(false);
                    FindToolbar.this.findPreviousAction.setEnabled(false);
                    FindToolbar.this.notifyStatus("");
                }
                if (FindToolbar.this.historyTable != null && !FindToolbar.this.historyTable.isDisposed()) {
                    FindToolbar.this.historyTable.clearAll();
                }
            }
        };
    }

    public static interface StatusListener {
        public void setMessage(FindToolbar var1, String var2);
    }
}

