/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.expressions.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.cdo.expressions.EvaluationContext;
import org.eclipse.emf.cdo.expressions.Expression;
import org.eclipse.emf.cdo.expressions.ExpressionsPackage;
import org.eclipse.emf.cdo.expressions.Invocation;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.internal.cdo.CDOObjectImpl;
import org.eclipse.net4j.util.WrappedException;

public abstract class InvocationImpl
extends CDOObjectImpl
implements Invocation {
    protected InvocationImpl() {
    }

    protected EClass eStaticClass() {
        return ExpressionsPackage.Literals.INVOCATION;
    }

    protected int eStaticFeatureCount() {
        return 0;
    }

    @Override
    public EList<Expression> getArguments() {
        return (EList)this.eDynamicGet(0, (EStructuralFeature)ExpressionsPackage.Literals.INVOCATION__ARGUMENTS, true, true);
    }

    @Override
    public Expression getName() {
        return (Expression)this.eDynamicGet(1, (EStructuralFeature)ExpressionsPackage.Literals.INVOCATION__NAME, true, true);
    }

    public NotificationChain basicSetName(Expression newName, NotificationChain msgs) {
        msgs = this.eDynamicInverseAdd((InternalEObject)newName, 1, msgs);
        return msgs;
    }

    @Override
    public void setName(Expression newName) {
        this.eDynamicSet(1, (EStructuralFeature)ExpressionsPackage.Literals.INVOCATION__NAME, newName);
    }

    @Override
    public Object evaluate(EvaluationContext context) {
        String name = (String)this.getName().evaluate(context);
        EList<Expression> arguments = this.getArguments();
        int size = arguments.size();
        Object[] evaluatedArguments = new Object[size];
        int i = 0;
        while (i < evaluatedArguments.length) {
            Expression argument = (Expression)arguments.get(i);
            evaluatedArguments[i] = argument.evaluate(context);
            ++i;
        }
        BasicEList invocables = new BasicEList();
        this.collectInvocables(context, name, (List<Invocable>)invocables);
        Invocable invocable = this.selectInvocable((List<Invocable>)invocables, evaluatedArguments);
        return invocable.invoke(evaluatedArguments);
    }

    protected abstract boolean staticModifier();

    protected abstract void collectInvocables(EvaluationContext var1, String var2, List<Invocable> var3);

    protected void collectMethods(Object object, Class<?> c, String name, List<Invocable> invocables) {
        Method[] methodArray = c.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            boolean static1 = Modifier.isStatic(method.getModifiers());
            boolean staticModifier = this.staticModifier();
            String name2 = method.getName();
            if (name2.equals(name) && static1 == staticModifier) {
                invocables.add(this.createMethod(object, method));
            }
            ++n2;
        }
    }

    protected Invocable createMethod(final Object object, final Method method) {
        return new Invocable(){

            @Override
            public String getName() {
                return method.getName();
            }

            @Override
            public Class<?>[] getParameterTypes() {
                return method.getParameterTypes();
            }

            @Override
            public Object invoke(Object[] arguments) {
                try {
                    return method.invoke(object, arguments);
                }
                catch (RuntimeException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw WrappedException.wrap((Exception)ex);
                }
            }

            public String toString() {
                return method.toString();
            }
        };
    }

    protected Invocable selectInvocable(List<Invocable> invocables, Object[] arguments) {
        Invocable result = null;
        for (Invocable invocable : invocables) {
            Class<?>[] parameterTypes = invocable.getParameterTypes();
            if (!this.isAssignable(parameterTypes, arguments)) continue;
            if (result != null) {
                throw new IllegalStateException("Ambiguous invocation: " + invocable.getName() + arguments);
            }
            result = invocable;
        }
        return result;
    }

    protected boolean isAssignable(Class<?>[] parameterTypes, Object[] arguments) {
        if (parameterTypes.length != arguments.length) {
            return false;
        }
        int i = 0;
        while (i < parameterTypes.length) {
            Class<?> argumentType;
            Class<?> parameterType = this.box(parameterTypes[i]);
            if (!parameterType.isAssignableFrom(argumentType = arguments[i].getClass())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected Class<?> box(Class<?> type) {
        if (type.isPrimitive()) {
            if (type == Boolean.TYPE) {
                return Boolean.class;
            }
            if (type == Character.TYPE) {
                return Character.class;
            }
            if (type == Byte.TYPE) {
                return Byte.class;
            }
            if (type == Short.TYPE) {
                return Short.class;
            }
            if (type == Integer.TYPE) {
                return Integer.class;
            }
            if (type == Long.TYPE) {
                return Long.class;
            }
            if (type == Float.TYPE) {
                return Float.class;
            }
            if (type == Double.TYPE) {
                return Double.class;
            }
        }
        return type;
    }

    protected Class<?>[] getTypes(Object[] objects) {
        Class[] types = new Class[objects.length];
        int i = 0;
        while (i < objects.length) {
            Object object = objects[i];
            types[i] = object == null ? Object.class : object.getClass();
            ++i;
        }
        return types;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getArguments()).basicRemove((Object)otherEnd, msgs);
            }
            case 1: {
                return this.basicSetName(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getArguments();
            }
            case 1: {
                return this.getName();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getArguments().clear();
                this.getArguments().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.setName((Expression)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getArguments().clear();
                return;
            }
            case 1: {
                this.setName(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return !this.getArguments().isEmpty();
            }
            case 1: {
                return this.getName() != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 0: {
                return this.evaluate((EvaluationContext)arguments.get(0));
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    public static interface Invocable {
        public String getName();

        public Class<?>[] getParameterTypes();

        public Object invoke(Object[] var1);
    }
}

