/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.text.StringMatcher;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class PatternFilter
extends ViewerFilter {
    private final Map cache = new HashMap();
    private final Map foundAnyCache = new HashMap();
    private boolean useCache = false;
    private boolean includeLeadingWildcard = false;
    private StringMatcher matcher;
    private boolean useEarlyReturnIfMatcherIsNull = true;
    private static Object[] EMPTY = new Object[0];

    public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
        if (this.matcher == null && this.useEarlyReturnIfMatcherIsNull) {
            return elements;
        }
        if (!this.useCache) {
            return super.filter(viewer, parent, elements);
        }
        Object[] filtered = (Object[])this.cache.get(parent);
        if (filtered == null) {
            Boolean foundAny = (Boolean)this.foundAnyCache.get(parent);
            filtered = foundAny != null && foundAny == false ? EMPTY : super.filter(viewer, parent, elements);
            this.cache.put(parent, filtered);
        }
        return filtered;
    }

    private boolean isAnyVisible(Viewer viewer, Object parent, Object[] elements) {
        if (this.matcher == null) {
            return true;
        }
        if (!this.useCache) {
            return this.computeAnyVisible(viewer, elements);
        }
        Object[] filtered = (Object[])this.cache.get(parent);
        if (filtered != null) {
            return filtered.length > 0;
        }
        Boolean foundAny = (Boolean)this.foundAnyCache.get(parent);
        if (foundAny == null) {
            foundAny = this.computeAnyVisible(viewer, elements) ? Boolean.TRUE : Boolean.FALSE;
            this.foundAnyCache.put(parent, foundAny);
        }
        return foundAny;
    }

    private boolean computeAnyVisible(Viewer viewer, Object[] elements) {
        boolean elementFound = false;
        int i = 0;
        while (i < elements.length && !elementFound) {
            Object element = elements[i];
            elementFound = this.isElementVisible(viewer, element);
            ++i;
        }
        return elementFound;
    }

    public final boolean select(Viewer viewer, Object parentElement, Object element) {
        return this.isElementVisible(viewer, element);
    }

    public final void setIncludeLeadingWildcard(boolean includeLeadingWildcard) {
        this.includeLeadingWildcard = includeLeadingWildcard;
    }

    public void setPattern(String patternString) {
        if ("org.eclipse.ui.keys.optimization.true".equals(patternString)) {
            this.useEarlyReturnIfMatcherIsNull = true;
            return;
        }
        if ("org.eclipse.ui.keys.optimization.false".equals(patternString)) {
            this.useEarlyReturnIfMatcherIsNull = false;
            return;
        }
        this.clearCaches();
        if (patternString == null || patternString.isEmpty()) {
            this.matcher = null;
        } else {
            Object pattern = patternString;
            if (!patternString.endsWith(" ")) {
                pattern = (String)pattern + "*";
            }
            if (this.includeLeadingWildcard) {
                pattern = "*" + (String)pattern;
            }
            this.matcher = new StringMatcher(((String)pattern).trim(), true, false);
        }
    }

    void clearCaches() {
        this.cache.clear();
        this.foundAnyCache.clear();
    }

    private boolean match(String string) {
        if (this.matcher == null) {
            return true;
        }
        return this.matcher.matchWords(string);
    }

    public boolean isElementSelectable(Object element) {
        return element != null;
    }

    public boolean isElementVisible(Viewer viewer, Object element) {
        return this.isParentMatch(viewer, element) || this.isLeafMatch(viewer, element);
    }

    protected boolean isParentMatch(Viewer viewer, Object element) {
        if (viewer instanceof AbstractTreeViewer && ((AbstractTreeViewer)viewer).getContentProvider() instanceof ITreeContentProvider) {
            Object[] children = ((ITreeContentProvider)((AbstractTreeViewer)viewer).getContentProvider()).getChildren(element);
            return children != null && children.length > 0 && this.isAnyVisible(viewer, element, children);
        }
        return false;
    }

    protected boolean isLeafMatch(Viewer viewer, Object element) {
        String labelText = ((ILabelProvider)((ContentViewer)viewer).getLabelProvider()).getText(element);
        if (labelText == null) {
            return false;
        }
        return this.wordMatches(labelText);
    }

    protected boolean wordMatches(String text) {
        String[] words;
        if (text == null) {
            return false;
        }
        if (this.match(text)) {
            return true;
        }
        String[] stringArray = words = StringMatcher.getWords((String)text);
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            if (!this.match(word)) {
                return false;
            }
            ++n2;
        }
        return words.length > 0;
    }

    void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }
}

