/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.breakpoints;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.Breakpoint;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class BreakpointLabelAction
implements IViewActionDelegate {
    private IViewPart fView;

    protected IViewPart getView() {
        return this.fView;
    }

    protected void setView(IViewPart view) {
        this.fView = view;
    }

    /*
     * WARNING - void declaration
     */
    public void run(IAction action) {
        void treeItem;
        void breakpointView;
        IViewPart iViewPart;
        Breakpoint breakpoint;
        TreeSelection treeSelect;
        block5: {
            block4: {
                Object object;
                IStructuredSelection selection = this.getSelection();
                if (!(selection instanceof TreeSelection) || (treeSelect = (TreeSelection)selection).size() != 1 || !((object = selection.getFirstElement()) instanceof Breakpoint)) break block4;
                breakpoint = (Breakpoint)object;
                iViewPart = this.fView;
                if (iViewPart instanceof BreakpointsView) break block5;
            }
            return;
        }
        BreakpointsView breakpointsView = (BreakpointsView)iViewPart;
        TreeModelViewer treeViewer = breakpointView.getTreeModelViewer();
        Widget item = treeViewer.findItem(treeSelect.getPaths()[0]);
        if (!(item instanceof TreeItem)) {
            return;
        }
        TreeItem treeItem2 = (TreeItem)item;
        Rectangle editorBounds = BreakpointLabelAction.computeInlineEditorBounds((TreeItem)treeItem);
        Label label = new Label((Composite)treeItem.getParent(), 64);
        label.setText(ActionMessages.BreakpointLabelDialog);
        Point defaultLabelSize = label.computeSize(-1, -1);
        label.setBounds(editorBounds.x, editorBounds.y - 20, defaultLabelSize.x, defaultLabelSize.y);
        label.setBackground(treeItem.getDisplay().getSystemColor(29));
        final String current = treeItem.getText();
        final Text textEditor = new Text((Composite)treeItem.getParent(), 2048);
        textEditor.setBounds(editorBounds.x, editorBounds.y, editorBounds.width, editorBounds.height);
        textEditor.setText(current);
        textEditor.selectAll();
        textEditor.setFocus();
        final InlineEditor inlineEditor = new InlineEditor(label, textEditor);
        textEditor.addListener(16, event -> inlineEditor.dispose());
        textEditor.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 27) {
                    inlineEditor.dispose();
                } else if (e.keyCode == 13) {
                    String newLabel = textEditor.getText().strip();
                    if (newLabel.equals(current)) {
                        inlineEditor.dispose();
                        return;
                    }
                    if (newLabel.isEmpty()) {
                        newLabel = null;
                    }
                    try {
                        breakpoint.setBreakpointLabel(newLabel);
                    }
                    catch (CoreException e1) {
                        DebugUIPlugin.log(e1);
                    }
                    inlineEditor.dispose();
                }
            }
        });
    }

    private static Rectangle computeInlineEditorBounds(TreeItem treeItem) {
        Rectangle bounds;
        try {
            bounds = treeItem.getBounds();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            bounds = BreakpointLabelAction.macBugWorkaround(treeItem);
        }
        int editorWidth = Math.max(BreakpointLabelAction.computeEditorExtent(treeItem), bounds.width);
        return new Rectangle(bounds.x, bounds.y, editorWidth, bounds.height);
    }

    private static Rectangle macBugWorkaround(TreeItem treeItem) {
        treeItem.setFont(null);
        Rectangle bounds = treeItem.getBounds(0);
        bounds.x += 10;
        bounds.width = BreakpointLabelAction.computeEditorExtent(treeItem);
        return bounds;
    }

    private static int computeEditorExtent(TreeItem treeItem) {
        GC gc = new GC((Drawable)treeItem.getParent());
        try {
            Point textWidth = gc.textExtent(treeItem.getText());
            int width = textWidth.x + 20;
            int n = width = Math.max(100, width);
            return n;
        }
        finally {
            gc.dispose();
        }
    }

    protected IStructuredSelection getSelection() {
        return (IStructuredSelection)this.getView().getViewSite().getSelectionProvider().getSelection();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void init(IViewPart view) {
        this.setView(view);
    }

    private record InlineEditor(Label label, Text text) {
        void dispose() {
            this.label.dispose();
            this.text.dispose();
        }
    }
}

