/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.parts;

import java.lang.ref.WeakReference;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramEditorInput;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPersistableElement;

public class DiagramEditorInput
implements IDiagramEditorInput {
    private WeakReference diagram;

    public DiagramEditorInput(Diagram diagram) {
        Assert.isNotNull((Object)diagram);
        this.setDiagram(diagram);
    }

    @Override
    public Diagram getDiagram() {
        return (Diagram)this.diagram.get();
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getQName() {
        try {
            return (String)TransactionUtil.getEditingDomain((EObject)this.getDiagram()).runExclusive((Runnable)new RunnableWithResult.Impl(){

                public void run() {
                    this.setResult(EMFCoreUtil.getQualifiedName((EObject)DiagramEditorInput.this.getDiagram(), (boolean)false));
                }
            });
        }
        catch (Exception e) {
            Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String getName() {
        try {
            return (String)TransactionUtil.getEditingDomain((EObject)this.getDiagram()).runExclusive((Runnable)new RunnableWithResult.Impl(){

                public void run() {
                    this.setResult(EMFCoreUtil.getName((EObject)DiagramEditorInput.this.getDiagram()));
                }
            });
        }
        catch (Exception e) {
            Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.getQName();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == Diagram.class) {
            return this.getDiagram();
        }
        if (adapter == IFile.class) {
            return this.getStorageUnitFile();
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DiagramEditorInput)) {
            return false;
        }
        DiagramEditorInput other = (DiagramEditorInput)obj;
        if (this.getDiagram() != null) {
            return this.getDiagram().equals(other.getDiagram());
        }
        return this.getDiagram() == other.getDiagram();
    }

    public int hashCode() {
        if (this.getDiagram() != null) {
            return this.getDiagram().hashCode();
        }
        return super.hashCode();
    }

    protected void setDiagram(Diagram diagram) {
        this.diagram = new WeakReference<Diagram>(diagram);
    }

    private IFile getStorageUnitFile() {
        TransactionalEditingDomain editingDomain;
        block3: {
            try {
                editingDomain = TransactionUtil.getEditingDomain((EObject)this.getDiagram());
                if (editingDomain != null) break block3;
                return null;
            }
            catch (Exception e) {
                Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)e.getMessage(), (Throwable)e);
                return null;
            }
        }
        return (IFile)editingDomain.runExclusive((Runnable)new RunnableWithResult.Impl(){

            public void run() {
                Resource model = DiagramEditorInput.this.getDiagram().eResource();
                this.setResult(model != null ? WorkspaceSynchronizer.getFile((Resource)model) : null);
            }
        });
    }
}

