/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.dialogs.sortfilter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.ui.dialogs.sortfilter.SortFilterCollectionColumn;
import org.eclipse.gmf.runtime.diagram.ui.dialogs.sortfilter.SortFilterElement;
import org.eclipse.gmf.runtime.diagram.ui.dialogs.sortfilter.SortFilterLabelProvider;
import org.eclipse.gmf.runtime.diagram.ui.dialogs.sortfilter.SortFilterViewerSorter;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ListCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.dialogs.sortfilter.SortFilterContentProvider;
import org.eclipse.gmf.runtime.diagram.ui.internal.dialogs.sortfilter.SortFilterDialog;
import org.eclipse.gmf.runtime.diagram.ui.internal.l10n.DiagramUIPluginImages;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.ChangeSortFilterRequest;
import org.eclipse.gmf.runtime.notation.Filtering;
import org.eclipse.gmf.runtime.notation.FilteringStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Sorting;
import org.eclipse.gmf.runtime.notation.SortingDirection;
import org.eclipse.gmf.runtime.notation.SortingStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;

public class SortFilterPage
extends PropertyPage {
    private static final String MOVE_UP_TOOL_TIP = DiagramUIMessages.SortFilter_moveItemUp;
    private static final String MOVE_DOWN_TOOL_TIP = DiagramUIMessages.SortFilter_moveItemDown;
    private static final String FILTER_ITEMS_CONTAINING = DiagramUIMessages.SortFilter_filterItemsListLabel;
    private static final String FILTER_ITEMS_LIST = DiagramUIMessages.SortFilter_fitlerListLabel;
    private static final String ADD_TO = DiagramUIMessages.SortFilter_addTo;
    private final String ADD_TO_LABEL = "<";
    private static final String REMOVE_FROM = DiagramUIMessages.SortFilter_removeFrom;
    private final String REMOVE_FROM_LABEL = ">";
    private static final String ADD_ALL = DiagramUIMessages.SortFilter_addAll;
    private final String ADD_ALL_LABEL = "<<";
    private static final String REMOVE_ALL = DiagramUIMessages.SortFilter_removeAll;
    private final String REMOVE_ALL_LABEL = ">>";
    private List elementCollection = null;
    private List baseElements = null;
    private TableViewer tableViewer = null;
    private ToolItem moveUpToolItem = null;
    private ToolItem moveDownToolItem = null;
    private org.eclipse.swt.widgets.List filterList = null;
    private org.eclipse.swt.widgets.List filters = null;
    private Button addTo = null;
    private Button removeFrom = null;
    private Button addAllTo = null;
    private Button removeAllFrom = null;
    private final int ADD_TO_ID = 0;
    private final int REMOVE_FROM_ID = 1;
    private final int ADD_ALL_TO_ID = 2;
    private final int REMOVE_ALL_FROM_ID = 3;
    private int LIST_HEIGHT = 8;
    private List collectionColumns = null;
    private SortFilterLabelProvider labelProvider = null;
    private Map filterMap = null;
    private String[] filterStrings = null;
    private String filterAppliesTo = null;
    private Sorting _sorting = Sorting.NONE_LITERAL;
    private List _sortedObjects = Collections.EMPTY_LIST;
    private Map _sortingKeys = Collections.EMPTY_MAP;
    private String _sortColumn;
    private SortingDirection _sortingDirection = SortingDirection.ASCENDING_LITERAL;
    private Filtering _filtering = Filtering.NONE_LITERAL;
    private List _filteredObjects = Collections.EMPTY_LIST;
    private List _filteringKeys = Collections.EMPTY_LIST;
    private List elementCollectionBackUp = Collections.EMPTY_LIST;
    private Sorting _sortingBackUp = this._sorting;
    private Filtering _filteringBackUp = this._filtering;
    private List _shownAsAlternateViewItems = Collections.EMPTY_LIST;
    private GraphicalEditPart editPart = null;
    public static final String ROOT_PAGE = "root_page";
    public static final String CHILD_PAGE = "child_page";
    private String pageType;
    private ButtonSelectionAdapter buttonSelectionAdapter = new ButtonSelectionAdapter();

    public SortFilterPage(String pageType, GraphicalEditPart editPart, List collectionColumns, SortFilterLabelProvider labelProvider) {
        this.pageType = pageType;
        this.editPart = editPart;
        if (pageType.equals(CHILD_PAGE)) {
            Assert.isTrue((boolean)(editPart instanceof ListCompartmentEditPart));
            Assert.isTrue((labelProvider != null ? 1 : 0) != 0);
            this.tokenizeSortProperty();
            this.tokenizeFilterProperty();
        }
        this.collectionColumns = collectionColumns;
        this.labelProvider = labelProvider;
    }

    protected Control createContents(Composite ancestor) {
        if (this.pageType == ROOT_PAGE) {
            this.noDefaultAndApplyButton();
        }
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        parent.setLayout((Layout)layout);
        if (this.filterStrings != null && this.filterStrings.length != 0) {
            this.createFilterLists(parent);
        }
        if (this.pageType == CHILD_PAGE) {
            this.createTable(parent);
            this.createToolBar(parent);
            if (this.elementCollection != null && !this.elementCollection.isEmpty()) {
                this.tableViewer.setSelection((ISelection)new StructuredSelection(this.elementCollection.get(0)));
            }
            if (this._filtering == Filtering.AUTOMATIC_LITERAL) {
                this.refreshList();
            }
            this.tableViewer.getTable().setFocus();
            this.handleSelection();
        }
        if (ROOT_PAGE.equals(this.pageType)) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)ancestor, "org.eclipse.gmf.runtime.diagram.ui.egmf0400");
        } else {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)ancestor, "org.eclipse.gmf.runtime.diagram.ui.egmf0500");
        }
        return parent;
    }

    private void createFilterLists(Composite ancestor) {
        if (this.filterStrings.length == 0) {
            return;
        }
        Composite parent = new Composite(ancestor, 0);
        Composite dummy = new Composite(ancestor, 0);
        GridData dgd = new GridData();
        dgd.widthHint = 0;
        dummy.setLayoutData((Object)dgd);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        parent.setLayout((Layout)layout);
        Label filterItemsLabel = new Label(parent, 16384);
        filterItemsLabel.setText(FILTER_ITEMS_CONTAINING);
        GridData gd = new GridData();
        gd.horizontalAlignment = 32;
        filterItemsLabel.setLayoutData((Object)gd);
        new Label(parent, 16384);
        Label filterItemLabel = new Label(parent, 16384);
        filterItemLabel.setText(FILTER_ITEMS_LIST);
        GridData gd2 = new GridData();
        gd2.horizontalAlignment = 1;
        filterItemLabel.setLayoutData((Object)gd2);
        this.filters = new org.eclipse.swt.widgets.List(parent, 2562);
        GridData gridData = new GridData(16);
        gridData.verticalSpan = 1;
        gridData.widthHint = 80;
        int listHeight = this.filters.getItemHeight() * this.LIST_HEIGHT;
        Rectangle trim = this.filters.computeTrim(0, 0, 0, listHeight);
        gridData.heightHint = trim.height;
        this.filters.setLayoutData((Object)gridData);
        Composite buttonComposite = new Composite(parent, 0);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.marginHeight = 0;
        buttonLayout.marginWidth = 0;
        buttonLayout.numColumns = 1;
        buttonComposite.setLayout((Layout)buttonLayout);
        GridData buttGD = new GridData(1042);
        buttGD.horizontalSpan = 1;
        buttGD.widthHint = 30;
        buttonComposite.setLayoutData((Object)buttGD);
        this.removeFrom = new Button(buttonComposite, 8);
        this.removeFrom.setText(">");
        this.removeFrom.setToolTipText(REMOVE_FROM);
        this.removeFrom.setLayoutData((Object)this.makeArrowButtonGridData((Control)this.removeFrom));
        this.removeFrom.setData((Object)1);
        this.removeFrom.addSelectionListener((SelectionListener)this.buttonSelectionAdapter);
        this.removeFrom.setEnabled(false);
        this.addTo = new Button(buttonComposite, 8);
        this.addTo.setText("<");
        this.addTo.setToolTipText(ADD_TO);
        this.addTo.setLayoutData((Object)this.makeArrowButtonGridData((Control)this.addTo));
        this.addTo.setData((Object)0);
        this.addTo.addSelectionListener((SelectionListener)this.buttonSelectionAdapter);
        this.addTo.setEnabled(false);
        this.removeAllFrom = new Button(buttonComposite, 8);
        this.removeAllFrom.setText(">>");
        this.removeAllFrom.setToolTipText(REMOVE_ALL);
        this.removeAllFrom.setLayoutData((Object)this.makeArrowButtonGridData((Control)this.removeAllFrom));
        this.removeAllFrom.setData((Object)3);
        this.removeAllFrom.addSelectionListener((SelectionListener)this.buttonSelectionAdapter);
        this.addAllTo = new Button(buttonComposite, 8);
        this.addAllTo.setText("<<");
        this.addAllTo.setToolTipText(ADD_ALL);
        this.addAllTo.setLayoutData((Object)this.makeArrowButtonGridData((Control)this.addAllTo));
        this.addAllTo.setData((Object)2);
        this.addAllTo.addSelectionListener((SelectionListener)this.buttonSelectionAdapter);
        this.filterList = new org.eclipse.swt.widgets.List(parent, 2562);
        GridData gridData2 = new GridData(16);
        gridData2.verticalSpan = 1;
        gridData2.widthHint = 80;
        int listHeight2 = this.filterList.getItemHeight() * this.LIST_HEIGHT;
        Rectangle trim2 = this.filterList.computeTrim(0, 0, 0, listHeight2);
        gridData.heightHint = trim2.height;
        this.filterList.setLayoutData((Object)gridData2);
        this.filters.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                SortFilterPage.this.removeFrom.setEnabled(SortFilterPage.this.filters.getSelectionCount() > 0);
            }
        });
        this.filterList.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                SortFilterPage.this.addTo.setEnabled(SortFilterPage.this.filterList.getSelectionCount() > 0);
            }
        });
        this.populateFilterLists();
    }

    protected GridData makeArrowButtonGridData(Control control) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        GridData gridData = new GridData(768);
        gridData.heightHint = 24;
        gc.dispose();
        return gridData;
    }

    private void buttonPressed(int buttonId) {
        String[] items = new String[]{};
        switch (buttonId) {
            case 0: {
                items = this.filterList.getSelection();
                int i = 0;
                while (i < items.length) {
                    this.filters.add(items[i]);
                    this.filterList.remove(items[i]);
                    ++i;
                }
                this.addTo.setEnabled(false);
                break;
            }
            case 1: {
                items = this.filters.getSelection();
                int i = 0;
                while (i < items.length) {
                    this.filterList.add(items[i]);
                    this.filters.remove(items[i]);
                    ++i;
                }
                this.removeFrom.setEnabled(false);
                break;
            }
            case 2: {
                items = this.filterList.getItems();
                int i = 0;
                while (i < items.length) {
                    this.filters.add(items[i]);
                    this.filterList.remove(items[i]);
                    ++i;
                }
                break;
            }
            case 3: {
                items = this.filters.getItems();
                int i = 0;
                while (i < items.length) {
                    this.filters.remove(items[i]);
                    this.filterList.add(items[i]);
                    ++i;
                }
                break;
            }
        }
        this.updateFilteringKeysFromControls();
        if (this.pageType == CHILD_PAGE) {
            this.refreshList();
        } else if (this.pageType == ROOT_PAGE) {
            PreferenceManager preferenceManager = ((SortFilterDialog)this.getContainer()).getPreferenceManager();
            for (PreferenceNode node : preferenceManager.getElements(0)) {
                SortFilterPage page = (SortFilterPage)node.getPage();
                if (page == this || !Arrays.equals(this.filterStrings, page.getFilterList())) continue;
                page._filteringKeys = new ArrayList(this._filteringKeys.size());
                page._filteringKeys.addAll(this._filteringKeys);
                page._filtering = this._filtering;
                page.populateFilterLists();
                page.refreshList();
                page.updateApplyButton();
            }
        }
        this.updateApplyButton();
    }

    private String[] getColumnProperties() {
        String[] columnProperties = new String[this.tableViewer.getColumnProperties().length];
        Object[] columnNames = this.tableViewer.getColumnProperties();
        int i = 0;
        while (i < columnNames.length) {
            columnProperties[i] = (String)columnNames[i];
            ++i;
        }
        return columnProperties;
    }

    private void updateFilteringKeysFromControls() {
        String[] theFilterStrings = this.filters.getItems();
        if (theFilterStrings.length == 0) {
            this._filtering = Filtering.NONE_LITERAL;
            this._filteringKeys = Collections.EMPTY_LIST;
        } else {
            this._filtering = Filtering.AUTOMATIC_LITERAL;
            if (this._filteringKeys != null) {
                this._filteringKeys = new ArrayList();
            }
            int i = 0;
            while (i < theFilterStrings.length) {
                this._filteringKeys.add(theFilterStrings[i]);
                ++i;
            }
        }
    }

    void refreshList() {
        int filterColumn = this.findColumnIndexFromProperty(this.filterAppliesTo);
        if (filterColumn == -1) {
            return;
        }
        int j = 0;
        while (j < this.elementCollection.size()) {
            String cell = this.labelProvider.getColumnText(this.elementCollection.get(j), filterColumn);
            ((SortFilterElement)this.elementCollection.get(j)).setVisible(!this._filteringKeys.contains(cell));
            ++j;
        }
        if (this.tableViewer != null) {
            this.tableViewer.refresh();
        }
    }

    private void createTable(Composite parent) {
        this.tableViewer = new TableViewer(parent, 68354);
        this.tableViewer.setUseHashlookup(true);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalSpan = 1;
        data.widthHint = this.convertWidthInCharsToPixels(30);
        table.setLayoutData((Object)data);
        table.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                SortFilterPage.this.handleSelection();
            }
        });
        String[] columnNames = new String[this.collectionColumns.size()];
        int i = 0;
        for (SortFilterCollectionColumn columnInfo : this.collectionColumns) {
            TableColumn column = new TableColumn(table, columnInfo.getAlignment());
            column.setText(columnInfo.getCaption());
            column.setResizable(columnInfo.isResizable());
            column.setWidth(columnInfo.getWidth());
            column.setAlignment(columnInfo.getAlignment());
            if (columnInfo.getColumnSorter() != null) {
                column.addSelectionListener((SelectionListener)new HeaderSelectionListener((SortFilterViewerSorter)columnInfo.getColumnSorter(), this.tableViewer));
                if (this._sortColumn != null && column.getText().equals(this._sortColumn)) {
                    SortFilterViewerSorter sorter = (SortFilterViewerSorter)columnInfo.getColumnSorter();
                    if (sorter != null) {
                        if (SortingDirection.ASCENDING_LITERAL.equals(this._sortingDirection)) {
                            image = DiagramUIPluginImages.DESC_SORT_ARROW_UP.createImage();
                            column.setImage(image);
                            column.pack();
                        } else if (SortingDirection.DESCENDING_LITERAL.equals(this._sortingDirection)) {
                            sorter.toggleSortingDirection();
                            image = DiagramUIPluginImages.DESC_SORT_ARROW_DN.createImage();
                            column.setImage(image);
                            column.pack();
                        }
                    }
                    this.tableViewer.setSorter((ViewerSorter)sorter);
                }
            }
            columnNames[i++] = columnInfo.getCaption();
        }
        this.tableViewer.setContentProvider((IContentProvider)new SortFilterContentProvider());
        if (this.labelProvider != null) {
            this.tableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        }
        this.tableViewer.setColumnProperties(columnNames);
        this.tableViewer.setCellModifier((ICellModifier)new SortFilterCellModifier());
        CellEditor[] editors = new CellEditor[this.collectionColumns.size()];
        editors[0] = new CheckboxCellEditor((Composite)table);
        i = 1;
        while (i < this.collectionColumns.size()) {
            editors[i] = null;
            ++i;
        }
        this.tableViewer.setCellEditors(editors);
        if (this.elementCollection != null && !this.elementCollection.isEmpty()) {
            this.tableViewer.setInput((Object)this.elementCollection);
        }
        TableItem[] tableItems = this.tableViewer.getTable().getItems();
        ArrayList<SortFilterElement> newModel = new ArrayList<SortFilterElement>();
        i = 0;
        while (i < tableItems.length) {
            SortFilterElement ey = (SortFilterElement)tableItems[i].getData();
            newModel.add(i, ey);
            ++i;
        }
        this.tableViewer.setInput(newModel);
        this.elementCollection = newModel;
        this.createBackUp();
        TableColumn[] tableColumns = table.getColumns();
        i = 0;
        while (i < tableColumns.length) {
            tableColumns[i].pack();
            ++i;
        }
    }

    private void createToolBar(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        parent.setLayout((Layout)layout);
        GridData gridData = new GridData(2);
        parent.setLayoutData((Object)gridData);
        ToolBar toolBar = new ToolBar(parent, 0x800000);
        Image imageUp = DiagramUIPluginImages.DESC_UP_PATH.createImage();
        this.moveUpToolItem = new ToolItem(toolBar, 8);
        this.moveUpToolItem.setEnabled(false);
        this.moveUpToolItem.setToolTipText(MOVE_UP_TOOL_TIP);
        this.moveUpToolItem.setImage(imageUp);
        this.moveUpToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SortFilterPage.this.moveUpElements();
            }
        });
        ToolBar toolBarDown = new ToolBar(parent, 0x800000);
        Image imageDown = DiagramUIPluginImages.DESC_DOWN_PATH.createImage();
        this.moveDownToolItem = new ToolItem(toolBarDown, 8);
        this.moveDownToolItem.setEnabled(false);
        this.moveDownToolItem.setToolTipText(MOVE_DOWN_TOOL_TIP);
        this.moveDownToolItem.setImage(imageDown);
        this.moveDownToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SortFilterPage.this.moveDownElements();
            }
        });
    }

    private void moveUpElements() {
        int c = this.tableViewer.getTable().getSelectionCount();
        if (c == 0) {
            return;
        }
        int[] selectionIndexes = this.tableViewer.getTable().getSelectionIndices();
        ArrayList model = (ArrayList)this.tableViewer.getInput();
        int i = 0;
        while (i < selectionIndexes.length) {
            SortFilterElement element = (SortFilterElement)model.get(selectionIndexes[i] - 1);
            model.set(selectionIndexes[i] - 1, model.get(selectionIndexes[i]));
            model.set(selectionIndexes[i], element);
            ++i;
        }
        this.tableViewer.setSorter(null);
        this.tableViewer.refresh();
        this._sorting = this.isSameOrder(this.elementCollection, this.baseElements) ? Sorting.NONE_LITERAL : Sorting.MANUAL_LITERAL;
        this._sortingKeys = Collections.EMPTY_MAP;
        this.handleSelection();
        this.updateApplyButton();
    }

    private void moveDownElements() {
        int selectionCount = this.tableViewer.getTable().getSelectionCount();
        if (selectionCount == 0) {
            return;
        }
        ArrayList model = (ArrayList)this.tableViewer.getInput();
        int[] selectionIndexes = this.tableViewer.getTable().getSelectionIndices();
        int i = selectionIndexes.length - 1;
        while (i >= 0) {
            SortFilterElement element = (SortFilterElement)model.get(selectionIndexes[i] + 1);
            model.set(selectionIndexes[i] + 1, model.get(selectionIndexes[i]));
            model.set(selectionIndexes[i], element);
            --i;
        }
        this.tableViewer.setSorter(null);
        this.tableViewer.refresh();
        this._sorting = this.isSameOrder(this.elementCollection, this.baseElements) ? Sorting.NONE_LITERAL : Sorting.MANUAL_LITERAL;
        this._sortingKeys = Collections.EMPTY_MAP;
        this.handleSelection();
        this.updateApplyButton();
    }

    private boolean isSameOrder(List elements1, List elements2) {
        Iterator itr1 = elements1.iterator();
        Iterator itr2 = elements2.iterator();
        while (itr1.hasNext() && itr2.hasNext()) {
            SortFilterElement element1 = (SortFilterElement)itr1.next();
            SortFilterElement element2 = (SortFilterElement)itr2.next();
            if (element1.getData().equals(element2.getData())) continue;
            return false;
        }
        return !itr1.hasNext() && !itr2.hasNext();
    }

    private void handleSelection() {
        ISelection selection = this.tableViewer.getSelection();
        if (selection == null || !(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        List selectionList = structuredSelection.toList();
        boolean selectionEmpty = structuredSelection.isEmpty();
        boolean firstRowSelected = true;
        boolean lastRowSelected = true;
        if (!selectionEmpty) {
            SortFilterElement element = (SortFilterElement)selectionList.get(0);
            firstRowSelected = this.tableViewer.getElementAt(0).equals(element);
            element = (SortFilterElement)selectionList.get(selectionList.size() - 1);
            lastRowSelected = this.tableViewer.getElementAt(this.tableViewer.getTable().getItemCount() - 1).equals(element);
        }
        if (this.moveUpToolItem != null) {
            this.moveUpToolItem.setEnabled(!firstRowSelected && !selectionEmpty);
        }
        if (this.moveDownToolItem != null) {
            this.moveDownToolItem.setEnabled(!lastRowSelected && !selectionEmpty);
        }
    }

    private String[] getFilterList() {
        return this.filterStrings;
    }

    public void setFilter(Map filterMap, String property) {
        if (filterMap != null) {
            this.filterMap = filterMap;
            Object[] filterArray = filterMap.keySet().toArray();
            this.filterStrings = new String[filterArray.length];
            int i = 0;
            while (i < filterArray.length) {
                this.filterStrings[i] = (String)filterArray[i];
                ++i;
            }
            this.filterAppliesTo = property;
        }
    }

    private int findColumnIndexFromProperty(String property) {
        int i = 0;
        while (i < this.collectionColumns.size()) {
            if (((SortFilterCollectionColumn)this.collectionColumns.get(i)).getCaption().equals(property)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setInput(List sortFilterElements) {
        int j;
        ArrayList<SortFilterElement> updatedSortFilterElements = new ArrayList<SortFilterElement>();
        for (SortFilterElement element : sortFilterElements) {
            updatedSortFilterElements.add(element);
        }
        this.baseElements = new ArrayList(updatedSortFilterElements.size());
        Iterator itr = updatedSortFilterElements.iterator();
        while (itr.hasNext()) {
            this.baseElements.add(new SortFilterElement(((SortFilterElement)itr.next()).getData()));
        }
        if (this._filtering == Filtering.MANUAL_LITERAL && !updatedSortFilterElements.isEmpty() && this._filteredObjects != null && this._filteredObjects.size() > 0) {
            int i = 0;
            while (i < this._filteredObjects.size()) {
                EObject eObject = (EObject)this._filteredObjects.get(i);
                j = 0;
                while (j < updatedSortFilterElements.size()) {
                    SortFilterElement element = (SortFilterElement)updatedSortFilterElements.get(j);
                    if (eObject.equals(element.getData())) {
                        element.setVisible(false);
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (this._sorting == Sorting.MANUAL_LITERAL) {
            if (!updatedSortFilterElements.isEmpty() && this._sortedObjects != null && this._sortedObjects.size() > 0) {
                this.elementCollection = new ArrayList(updatedSortFilterElements.size());
                int i = 0;
                while (i < this._sortedObjects.size()) {
                    SortFilterElement element;
                    element = (EObject)this._sortedObjects.get(i);
                    j = 0;
                    while (j < updatedSortFilterElements.size()) {
                        SortFilterElement e = (SortFilterElement)updatedSortFilterElements.get(j);
                        if (((Object)element).equals(e.getData())) {
                            this.elementCollection.add(e);
                        }
                        ++j;
                    }
                    ++i;
                }
                ArrayList missingElements = new ArrayList(updatedSortFilterElements);
                missingElements.removeAll(this.elementCollection);
                this.elementCollection.addAll(missingElements);
            }
        } else {
            this.elementCollection = updatedSortFilterElements;
        }
        this.createBackUp();
    }

    public void setContents(List sortFilterElements, List hiddenContents) {
        this.setInput(sortFilterElements);
        this._shownAsAlternateViewItems = hiddenContents;
    }

    protected void performDefaults() {
        this._filtering = Filtering.NONE_LITERAL;
        this._filteredObjects = Collections.EMPTY_LIST;
        if (this.filterStrings != null && !this._filteringKeys.isEmpty()) {
            this._filteringKeys = Collections.EMPTY_LIST;
            this.populateFilterLists();
        }
        this._sorting = Sorting.NONE_LITERAL;
        this._sortingKeys = Collections.EMPTY_MAP;
        this._sortedObjects = Collections.EMPTY_LIST;
        this.tableViewer.setSorter(null);
        TableColumn[] columns = this.tableViewer.getTable().getColumns();
        int i = 0;
        while (i < columns.length) {
            columns[i].setImage(null);
            ++i;
        }
        List input = (List)this.tableViewer.getInput();
        input.clear();
        int i2 = 0;
        while (i2 < this.baseElements.size()) {
            input.add(new SortFilterElement(((SortFilterElement)this.baseElements.get(i2)).getData()));
            ++i2;
        }
        this.tableViewer.refresh();
        this.updateApplyButton();
    }

    protected void performApply() {
        Command sortAndFilteringCommand = this.getApplyCommand();
        if (sortAndFilteringCommand != null && sortAndFilteringCommand.canExecute()) {
            this.editPart.getRoot().getViewer().getEditDomain().getCommandStack().execute(sortAndFilteringCommand);
            this.createBackUp();
        }
        this.updateApplyButton();
    }

    public Command getCommand() {
        if (this.isDirty()) {
            return this.getApplyCommand();
        }
        return null;
    }

    public Command getApplyCommand() {
        UnexecutableCommand cmd = UnexecutableCommand.INSTANCE;
        if (CHILD_PAGE.equals(this.pageType)) {
            ArrayList<Object> newSortedObjects = Collections.EMPTY_LIST;
            if (this._sorting.equals(Sorting.MANUAL_LITERAL)) {
                newSortedObjects = new ArrayList<Object>();
                for (SortFilterElement element : this.elementCollection) {
                    newSortedObjects.add(element.getData());
                }
            }
            ArrayList<Object> newFilteredObjects = Collections.EMPTY_LIST;
            if (this._filtering.equals(Filtering.MANUAL_LITERAL)) {
                newFilteredObjects = new ArrayList<Object>();
                for (SortFilterElement element : this.elementCollection) {
                    if (element.isVisible()) continue;
                    newFilteredObjects.add(element.getData());
                }
                if (this._filtering.equals(Filtering.MANUAL_LITERAL) && newFilteredObjects.size() == 0) {
                    this._filtering = Filtering.NONE_LITERAL;
                }
            }
            if (!this._shownAsAlternateViewItems.isEmpty() && Collections.EMPTY_LIST.equals(newFilteredObjects)) {
                newFilteredObjects = new ArrayList();
            }
            newFilteredObjects.addAll(this._shownAsAlternateViewItems);
            ChangeSortFilterRequest request = new ChangeSortFilterRequest(this._filtering, newFilteredObjects, this._filteringKeys, this._sorting, newSortedObjects, this._sortingKeys);
            cmd = this.editPart.getCommand(request);
        }
        return cmd;
    }

    /*
     * Unable to fully structure code
     */
    private void populateFilterLists() {
        block3: {
            if (this.filterMap == null || this.filterMap.isEmpty() || this.filterList == null || this.filters == null) break block3;
            this.filterList.removeAll();
            this.filters.removeAll();
            keySet = this.filterMap.keySet();
            i = keySet.iterator();
            if (this._filtering != Filtering.AUTOMATIC_LITERAL) ** GOTO lbl17
            while (i.hasNext()) {
                filterString = (String)i.next();
                if (this._filteringKeys.contains(filterString)) {
                    this.filters.add(filterString);
                    continue;
                }
                this.filterList.add(filterString);
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                filterString = (String)i.next();
                this.filterList.add(filterString);
lbl17:
                // 2 sources

                ** while (i.hasNext())
            }
        }
    }

    private void tokenizeFilterProperty() {
        View view;
        FilteringStyle style;
        Object model = this.editPart.getModel();
        if (model instanceof View && (style = (FilteringStyle)(view = (View)model).getStyle(NotationPackage.eINSTANCE.getFilteringStyle())) != null) {
            this._filtering = style.getFiltering();
            this._filteredObjects = style.eIsSet((EStructuralFeature)NotationPackage.eINSTANCE.getFilteringStyle_FilteredObjects()) ? new ArrayList(style.getFilteredObjects()) : Collections.EMPTY_LIST;
            this._filteringKeys = style.eIsSet((EStructuralFeature)NotationPackage.eINSTANCE.getFilteringStyle_FilteringKeys()) ? new ArrayList(style.getFilteringKeys()) : Collections.EMPTY_LIST;
        }
    }

    private void tokenizeSortProperty() {
        View view;
        SortingStyle style;
        Object model = this.editPart.getModel();
        if (model instanceof View && (style = (SortingStyle)(view = (View)model).getStyle(NotationPackage.eINSTANCE.getSortingStyle())) != null) {
            Set keySet;
            Iterator iter;
            this._sorting = style.getSorting();
            this._sortedObjects = style.eIsSet((EStructuralFeature)NotationPackage.eINSTANCE.getSortingStyle_SortedObjects()) ? new ArrayList(style.getSortedObjects()) : Collections.EMPTY_LIST;
            Map map = this._sortingKeys = style.eIsSet((EStructuralFeature)NotationPackage.eINSTANCE.getSortingStyle_SortingKeys()) ? new HashMap(style.getSortingKeys()) : Collections.EMPTY_MAP;
            if (this._sortingKeys.size() > 0 && (iter = (keySet = this._sortingKeys.keySet()).iterator()).hasNext()) {
                this._sortColumn = (String)iter.next();
                this._sortingDirection = (SortingDirection)this._sortingKeys.get(this._sortColumn);
            }
        }
    }

    void setFilterCriteria(String[] filterCriteriaList) {
        this.filters.setItems(filterCriteriaList);
    }

    boolean isFiltering() {
        return this.filterStrings == null ? false : this.filters.getItems().length != 0;
    }

    void setCriteria(String[] criteriaList) {
        this.filterList.setItems(criteriaList);
    }

    protected void updateApplyButton() {
        if (this.getApplyButton() != null) {
            this.getApplyButton().setEnabled(this.isValid() && this.isDirty());
        }
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.updateApplyButton();
    }

    protected boolean isDirty() {
        if (this.pageType == ROOT_PAGE || this._filteringBackUp != this._filtering || this._sortingBackUp != this._sorting) {
            return true;
        }
        return !this.elementCollection.equals(this.elementCollectionBackUp);
    }

    private void createBackUp() {
        this._filteringBackUp = this._filtering;
        this._sortingBackUp = this._sorting;
        this.elementCollectionBackUp = new ArrayList(this.elementCollection.size());
        for (SortFilterElement element : this.elementCollection) {
            this.elementCollectionBackUp.add(new SortFilterElement(element.isVisible(), element.getData()));
        }
    }

    class ButtonSelectionAdapter
    extends SelectionAdapter {
        ButtonSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent event) {
            SortFilterPage.this.buttonPressed((Integer)event.widget.getData());
        }
    }

    class HeaderSelectionListener
    implements SelectionListener {
        private SortFilterViewerSorter sorter;
        private TableViewer _tableViewer;

        public HeaderSelectionListener(SortFilterViewerSorter sorter, TableViewer tableViewer) {
            this.sorter = sorter;
            this._tableViewer = tableViewer;
        }

        public void widgetSelected(SelectionEvent e) {
            this.handleEvent(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.handleEvent(e);
        }

        private void handleEvent(SelectionEvent e) {
            TableColumn column;
            TableColumn[] columns = this._tableViewer.getTable().getColumns();
            int i = 0;
            while (i < columns.length) {
                columns[i].setImage(null);
                ++i;
            }
            int columnIndex = 0;
            if (e.widget instanceof TableColumn && (columnIndex = SortFilterPage.this.findColumnIndexFromProperty((column = (TableColumn)e.widget).getText())) != -1) {
                Image image = null;
                SortFilterViewerSorter newSorter = (SortFilterViewerSorter)this._tableViewer.getSorter();
                if (newSorter != null) {
                    newSorter.toggleSortingDirection();
                    image = newSorter == null || SortingDirection.ASCENDING_LITERAL.equals(newSorter.getSortingDirection()) ? DiagramUIPluginImages.DESC_SORT_ARROW_UP.createImage() : DiagramUIPluginImages.DESC_SORT_ARROW_DN.createImage();
                    columns[columnIndex].setImage(image);
                }
            }
            if (this.sorter != null) {
                this._tableViewer.setSorter(null);
                this._tableViewer.setSorter((ViewerSorter)this.getSorter());
                TableItem[] tableItems = this._tableViewer.getTable().getItems();
                ArrayList<SortFilterElement> newModel = new ArrayList<SortFilterElement>();
                int i2 = 0;
                while (i2 < tableItems.length) {
                    SortFilterElement ey = (SortFilterElement)tableItems[i2].getData();
                    newModel.add(i2, ey);
                    ++i2;
                }
                SortFilterPage.this.elementCollection.clear();
                SortFilterPage.this.elementCollection.addAll(newModel);
                this._tableViewer.refresh();
                SortFilterPage.this._sorting = Sorting.AUTOMATIC_LITERAL;
                Object[] columnNames = SortFilterPage.this.tableViewer.getColumnProperties();
                if (SortFilterPage.this._sortingKeys != Collections.EMPTY_MAP) {
                    SortFilterPage.this._sortingKeys.clear();
                } else {
                    SortFilterPage.this._sortingKeys = new HashMap();
                }
                SortFilterPage.this._sortingKeys.put(columnNames[columnIndex], this.getSorter().getSortingDirection());
                SortFilterPage.this.handleSelection();
                SortFilterPage.this.updateApplyButton();
            }
        }

        public SortFilterViewerSorter getSorter() {
            return this.sorter;
        }
    }

    public class SortFilterCellModifier
    implements ICellModifier {
        public boolean canModify(Object element, String property) {
            int columnIndex = this.findPropertyIndex(property);
            if (columnIndex == 0) {
                return true;
            }
            return true;
        }

        public Object getValue(Object element, String property) {
            SortFilterElement item = (SortFilterElement)element;
            Boolean result = null;
            int columnIndex = this.findPropertyIndex(property);
            if (columnIndex == 0) {
                result = item.isVisible();
            }
            return result;
        }

        public void modify(Object element, String property, Object value) {
            boolean newValue = (Boolean)value;
            TableItem tableItem = (TableItem)element;
            SortFilterElement item = (SortFilterElement)tableItem.getData();
            int columnIndex = this.findPropertyIndex(property);
            if (columnIndex == 0) {
                TableItem[] tableItems = SortFilterPage.this.tableViewer.getTable().getItems();
                int j = 0;
                while (j < tableItems.length) {
                    SortFilterElement data = (SortFilterElement)tableItems[j].getData();
                    if (data.equals(item)) {
                        ((SortFilterElement)SortFilterPage.this.tableViewer.getElementAt(j)).setVisible(newValue);
                        SortFilterPage.this.tableViewer.update(new Object[]{SortFilterPage.this.tableViewer.getElementAt(j)}, new String[]{SortFilterPage.this.getColumnProperties()[0]});
                    }
                    ++j;
                }
                SortFilterPage.this.tableViewer.update(new Object[]{element}, new String[]{SortFilterPage.this.getColumnProperties()[0]});
                if (SortFilterPage.this.filterStrings != null) {
                    String[] items = SortFilterPage.this.filters.getItems();
                    int i = 0;
                    while (i < items.length) {
                        SortFilterPage.this.filterList.add(items[i]);
                        SortFilterPage.this.filters.remove(items[i]);
                        ++i;
                    }
                }
                SortFilterPage.this._filteringKeys = Collections.EMPTY_LIST;
                Filtering filtering = SortFilterPage.this._filtering = newValue ? Filtering.NONE_LITERAL : Filtering.MANUAL_LITERAL;
                if (newValue) {
                    Iterator itr = SortFilterPage.this.elementCollection.iterator();
                    while (itr.hasNext()) {
                        if (SortFilterPage.this.baseElements.contains(itr.next())) continue;
                        SortFilterPage.this._filtering = Filtering.MANUAL_LITERAL;
                        break;
                    }
                }
                SortFilterPage.this.updateApplyButton();
            }
        }

        private int findPropertyIndex(String property) {
            Object[] columnNames = SortFilterPage.this.tableViewer.getColumnProperties();
            int i = 0;
            while (i < columnNames.length) {
                if (((String)columnNames[i]).equals(property)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
    }
}

