/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.db.ddl;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.Properties;
import java.util.Set;
import org.eclipse.net4j.db.ddl.IDBSchema;
import org.eclipse.net4j.db.ddl.IDBSchemaElement;
import org.eclipse.net4j.db.ddl.IDBSchemaVisitor;
import org.eclipse.net4j.internal.db.ddl.DelegatingDBField;
import org.eclipse.net4j.internal.db.ddl.DelegatingDBIndex;
import org.eclipse.net4j.internal.db.ddl.DelegatingDBIndexField;
import org.eclipse.net4j.internal.db.ddl.DelegatingDBSchema;
import org.eclipse.net4j.internal.db.ddl.DelegatingDBTable;
import org.eclipse.net4j.spi.db.ddl.InternalDBField;
import org.eclipse.net4j.spi.db.ddl.InternalDBIndex;
import org.eclipse.net4j.spi.db.ddl.InternalDBIndexField;
import org.eclipse.net4j.spi.db.ddl.InternalDBSchema;
import org.eclipse.net4j.spi.db.ddl.InternalDBSchemaElement;
import org.eclipse.net4j.spi.db.ddl.InternalDBTable;
import org.eclipse.net4j.util.event.IListener;

public abstract class DelegatingDBSchemaElement
implements InternalDBSchemaElement {
    private InternalDBSchemaElement delegate;

    DelegatingDBSchemaElement(InternalDBSchemaElement delegate) {
        this.delegate = delegate;
    }

    public InternalDBSchemaElement getDelegate() {
        return this.delegate;
    }

    public void setDelegate(IDBSchemaElement delegate) {
        if (this.delegate != null) {
            this.delegate.setWrapper(null);
        }
        this.delegate = (InternalDBSchemaElement)delegate;
        if (this.delegate != null) {
            this.delegate.setWrapper(this);
        }
    }

    @Override
    public final void setWrapper(IDBSchemaElement wrapper) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IDBSchemaElement getParent() {
        return DelegatingDBSchemaElement.wrap(this.getDelegate().getParent());
    }

    @Override
    public final String getName() {
        return this.getDelegate().getName();
    }

    @Override
    @Deprecated
    public final void setName(String name) {
        this.getDelegate().setName(name);
    }

    @Override
    public final <T extends IDBSchemaElement> T getElement(Class<T> type, String name) {
        return this.getDelegate().getElement(type, name);
    }

    @Override
    public final String getFullName() {
        return this.getDelegate().getFullName();
    }

    @Override
    public final IDBSchema getSchema() {
        return DelegatingDBSchemaElement.wrap(this.getDelegate().getSchema());
    }

    @Override
    public final Properties getProperties() {
        return this.getDelegate().getProperties();
    }

    @Override
    public final String dumpToString() {
        return this.getDelegate().dumpToString();
    }

    @Override
    public final void dump() {
        this.getDelegate().dump();
    }

    @Override
    public final void dump(Writer writer) throws IOException {
        this.getDelegate().dump(writer);
    }

    @Override
    public final IDBSchemaElement.SchemaElementType getSchemaElementType() {
        return this.getDelegate().getSchemaElementType();
    }

    public final boolean isEmpty() {
        return this.getDelegate().isEmpty();
    }

    public final IDBSchemaElement[] getElements() {
        IDBSchemaElement[] elements = (IDBSchemaElement[])this.getDelegate().getElements();
        IDBSchemaElement[] wrappers = new IDBSchemaElement[elements.length];
        int i = 0;
        while (i < elements.length) {
            wrappers[i] = DelegatingDBSchemaElement.wrap(elements[i]);
            ++i;
        }
        return wrappers;
    }

    @Override
    public final void accept(IDBSchemaVisitor visitor) {
        this.getDelegate().accept(visitor);
    }

    @Override
    public final void remove() {
        this.getDelegate().remove();
    }

    public final void addListener(IListener listener) {
        this.getDelegate().addListener(listener);
    }

    public final IListener[] getListeners() {
        return this.getDelegate().getListeners();
    }

    public final boolean hasListeners() {
        return this.getDelegate().hasListeners();
    }

    public final void removeListener(IListener listener) {
        this.getDelegate().removeListener(listener);
    }

    public int hashCode() {
        return this.getDelegate().hashCode();
    }

    public boolean equals(Object obj) {
        return this.getDelegate().equals(obj);
    }

    @Override
    public final int compareTo(IDBSchemaElement o) {
        return this.getDelegate().compareTo(DelegatingDBSchemaElement.unwrap(o));
    }

    public String toString() {
        return this.getDelegate().toString();
    }

    public static <T extends IDBSchemaElement> T wrap(T delegate) {
        if (delegate == null || delegate instanceof DelegatingDBSchemaElement) {
            return delegate;
        }
        InternalDBSchemaElement internalDelegate = (InternalDBSchemaElement)delegate;
        IDBSchemaElement wrapper = internalDelegate.getWrapper();
        if (wrapper == null) {
            IDBSchemaElement.SchemaElementType schemaElementType = internalDelegate.getSchemaElementType();
            switch (schemaElementType) {
                case SCHEMA: {
                    wrapper = new DelegatingDBSchema((InternalDBSchema)internalDelegate);
                    break;
                }
                case TABLE: {
                    wrapper = new DelegatingDBTable((InternalDBTable)internalDelegate);
                    break;
                }
                case FIELD: {
                    wrapper = new DelegatingDBField((InternalDBField)internalDelegate);
                    break;
                }
                case INDEX: {
                    wrapper = new DelegatingDBIndex((InternalDBIndex)internalDelegate);
                    break;
                }
                case INDEX_FIELD: {
                    wrapper = new DelegatingDBIndexField((InternalDBIndexField)internalDelegate);
                    break;
                }
                default: {
                    throw new IllegalStateException("Illegal schema element type: " + (Object)((Object)schemaElementType));
                }
            }
            internalDelegate.setWrapper(wrapper);
        }
        IDBSchemaElement result = wrapper;
        return (T)result;
    }

    public static <T extends IDBSchemaElement> T[] wrap(T[] delegates, Class<T> type) {
        IDBSchemaElement[] wrappers = (IDBSchemaElement[])Array.newInstance(type, delegates.length);
        int i = 0;
        while (i < delegates.length) {
            T wrapper = DelegatingDBSchemaElement.wrap(delegates[i]);
            wrappers[i] = wrapper;
            ++i;
        }
        return wrappers;
    }

    public static <T extends IDBSchemaElement> Set<T> wrap(Set<T> delegates, Set<T> wrappers) {
        for (IDBSchemaElement delegate : delegates) {
            wrappers.add(DelegatingDBSchemaElement.wrap(delegate));
        }
        return wrappers;
    }

    public static <T extends IDBSchemaElement> T unwrap(T wrapper) {
        if (wrapper instanceof DelegatingDBSchemaElement) {
            InternalDBSchemaElement delegate = ((DelegatingDBSchemaElement)wrapper).getDelegate();
            return (T)delegate;
        }
        return wrapper;
    }

    public static <T extends IDBSchemaElement> T[] unwrap(T[] wrappers, Class<T> type) {
        IDBSchemaElement[] delegates = (IDBSchemaElement[])Array.newInstance(type, wrappers.length);
        int i = 0;
        while (i < wrappers.length) {
            delegates[i] = DelegatingDBSchemaElement.unwrap(wrappers[i]);
            ++i;
        }
        return delegates;
    }
}

