/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.signal.heartbeat;

import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.internal.net4j.bundle.OM;
import org.eclipse.net4j.channel.IChannelMultiplexer;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.signal.Indication;
import org.eclipse.net4j.signal.Request;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.signal.SignalReactor;
import org.eclipse.net4j.util.ExceptionHandler;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.concurrent.Timeouter;
import org.eclipse.net4j.util.concurrent.TimerLifecycle;
import org.eclipse.net4j.util.container.IElementProcessor;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IManagedContainerProvider;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.log.OMLogger;
import org.eclipse.spi.net4j.ServerProtocolFactory;

public class HeartBeatProtocol
extends SignalProtocol<Object> {
    public static final String TYPE = "heartbeat";
    private static final short SIGNAL_START = 1;
    private static final short SIGNAL_HEART_BEAT = 2;
    private static final boolean HEART_BEAT = true;
    private Timeouter timeouter;
    private Timer timer;

    protected HeartBeatProtocol(String type, IConnector connector, Timer timer) {
        super(type);
        this.checkArg(timer, "timer");
        this.checkArg(connector, "connector");
        this.timer = timer;
        this.open(connector);
    }

    public HeartBeatProtocol(IConnector connector, Timer timer) {
        this(TYPE, connector, timer);
    }

    public HeartBeatProtocol(IConnector connector, IManagedContainer container) {
        this(connector, HeartBeatProtocol.getDefaultTimer(container));
    }

    public HeartBeatProtocol(IConnector connector) {
        this(connector, (IManagedContainer)IPluginContainer.INSTANCE);
    }

    public Timer getTimer() {
        return this.timer;
    }

    public void start(long rate) {
        this.start(rate, 2L * rate);
    }

    public void start(final long rate, long timeout) {
        this.checkActive();
        this.checkArg(rate > 0L, "rate");
        this.checkArg(timeout >= rate, "timeout");
        try {
            new Request(this, 1, "Start"){

                @Override
                protected void requesting(ExtendedDataOutputStream out) throws Exception {
                    HeartBeatProtocol.this.requestingStart(out, rate);
                }
            }.sendAsync();
        }
        catch (Exception ex) {
            throw WrappedException.wrap((Exception)ex);
        }
        if (this.timeouter == null) {
            this.timeouter = new Timeouter(this.getTimer(), timeout){

                protected void handleTimeout(long untouched) {
                    HeartBeatProtocol.this.handleTimeout(untouched);
                }
            };
        } else {
            this.timeouter.setTimeout(timeout);
            this.timeouter.touch();
        }
    }

    @Override
    protected SignalReactor createSignalReactor(short signalID) {
        if (signalID == 2) {
            return new Indication(this, 2, "HeartBeat"){

                @Override
                protected void indicating(ExtendedDataInputStream in) throws Exception {
                    HeartBeatProtocol.this.checkState(in.readBoolean(), "Invalid heart beat");
                    HeartBeatProtocol.this.timeouter.touch();
                }
            };
        }
        return null;
    }

    protected void handleTimeout(long untouched) {
        IChannelMultiplexer multiplexer = this.getChannel().getMultiplexer();
        LifecycleUtil.deactivate((Object)multiplexer, (OMLogger.Level)OMLogger.Level.DEBUG);
    }

    @Override
    protected void doDeactivate() throws Exception {
        if (this.timeouter != null) {
            this.timeouter.dispose();
            this.timeouter = null;
        }
        super.doDeactivate();
    }

    protected void requestingStart(ExtendedDataOutputStream out, long rate) throws IOException {
        out.writeLong(rate);
    }

    public static Timer getDefaultTimer(IManagedContainer container) {
        return TimerLifecycle.DaemonFactory.getTimer((IManagedContainer)container, null);
    }

    public static class Server
    extends SignalProtocol<Object> {
        private long heartBeatRate;
        private Timer heartBeatTimer;
        private TimerTask heartBeatTimerTask;

        protected Server(String type) {
            super(type);
        }

        public Server() {
            this(HeartBeatProtocol.TYPE);
        }

        public Timer getHeartBeatTimer() {
            return this.heartBeatTimer;
        }

        public void setHeartBeatTimer(Timer heartBeatTimer) {
            this.checkInactive();
            this.heartBeatTimer = heartBeatTimer;
        }

        @Override
        protected SignalReactor createSignalReactor(short signalID) {
            if (signalID == 1) {
                return new Indication(this, 1, "Start"){

                    @Override
                    protected void indicating(ExtendedDataInputStream in) throws Exception {
                        this.indicatingStart(in);
                    }
                };
            }
            return null;
        }

        @Override
        protected void doBeforeActivate() throws Exception {
            super.doBeforeActivate();
            this.checkState(this.heartBeatTimer, "heartBeatTimer");
        }

        @Override
        protected void doDeactivate() throws Exception {
            try {
                this.cancelHeartBeatTask();
            }
            finally {
                super.doDeactivate();
            }
        }

        protected void indicatingStart(ExtendedDataInputStream in) throws IOException {
            this.heartBeatRate = in.readLong();
            this.cancelHeartBeatTask();
            this.scheduleHeartBeatTask();
        }

        private void scheduleHeartBeatTask() {
            this.heartBeatTimerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        new Request(this, 2, "HeartBeat"){

                            @Override
                            protected void requesting(ExtendedDataOutputStream out) throws Exception {
                                out.writeBoolean(true);
                            }
                        }.sendAsync();
                    }
                    catch (Exception ex) {
                        ExceptionHandler.Factory.handle((IManagedContainerProvider)this, (Throwable)ex, (String)"HeartBeatProtocolTask failed", (OMLogger)OM.LOG);
                    }
                }
            };
            this.heartBeatTimer.schedule(this.heartBeatTimerTask, 0L, this.heartBeatRate);
        }

        private void cancelHeartBeatTask() {
            if (this.heartBeatTimerTask != null) {
                this.heartBeatTimerTask.cancel();
                this.heartBeatTimerTask = null;
            }
        }

        public static class Factory
        extends ServerProtocolFactory {
            public Factory() {
                super(HeartBeatProtocol.TYPE);
            }

            public Object create(String description) throws ProductCreationException {
                return new Server();
            }
        }

        public static class TimerInjector
        implements IElementProcessor {
            public Object process(IManagedContainer container, String productGroup, String factoryType, String description, Object element) {
                Server server;
                if (element instanceof Server && (server = (Server)element).getHeartBeatTimer() == null) {
                    server.setHeartBeatTimer(this.getTimer(container));
                }
                return element;
            }

            protected Timer getTimer(IManagedContainer container) {
                return HeartBeatProtocol.getDefaultTimer(container);
            }
        }
    }
}

