/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.view;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionCache;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.common.revision.PointerCDORevision;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewSetHandler;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;

public class CDOPrefetcherManager
extends CDOViewSetHandler {
    public static final long NO_TIMEOUT = -1L;
    public static final long DEFAULT_TIMEOUT = 30000L;
    private final ExecutorService executorService;
    private final boolean prefetchLockStates;
    private final Map<CDOView, Prefetcher> prefetchers = Collections.synchronizedMap(new HashMap());
    @ReflectUtil.ExcludeFromDump
    private final Object lock = new Object();
    private int runnables;

    public CDOPrefetcherManager(ResourceSet resourceSet, boolean prefetchLockStates) {
        super(resourceSet);
        this.prefetchLockStates = prefetchLockStates;
        this.executorService = ConcurrencyUtil.getExecutorService((Object)this.getViewSet());
    }

    public boolean isPrefetchLockStates() {
        return this.prefetchLockStates;
    }

    public final Prefetcher[] getPrefetchers() {
        return this.prefetchers.values().toArray(new Prefetcher[0]);
    }

    public final Prefetcher getPrefetcher(CDOView view) {
        return this.prefetchers.get(view);
    }

    public boolean waitUntilPrefetched() {
        return this.waitUntilPrefetched(30000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean waitUntilPrefetched(long timeout) {
        Object object = this.lock;
        synchronized (object) {
            long end = timeout == -1L ? Long.MAX_VALUE : System.currentTimeMillis() + timeout;
            while (this.runnables > 0) {
                try {
                    long wait = end - System.currentTimeMillis();
                    if (wait <= 0L) {
                        return false;
                    }
                    this.lock.wait(wait);
                }
                catch (InterruptedException ex) {
                    return false;
                }
            }
            return true;
        }
    }

    public void cleanup() {
        Prefetcher[] prefetchers = this.getPrefetchers();
        CountDownLatch finished = new CountDownLatch(prefetchers.length);
        Prefetcher[] prefetcherArray = prefetchers;
        int n = prefetchers.length;
        int n2 = 0;
        while (n2 < n) {
            Prefetcher prefetcher = prefetcherArray[n2];
            this.executorService.submit(() -> {
                try {
                    prefetcher.cleanup();
                }
                finally {
                    finished.countDown();
                }
            });
            ++n2;
        }
        try {
            finished.await();
        }
        catch (InterruptedException ex) {
            OM.LOG.error((Throwable)ex);
        }
    }

    @Override
    protected void viewAdded(CDOView view) {
        Prefetcher prefetcher = this.createPrefetcher(view);
        this.prefetchers.put(view, prefetcher);
        this.schedule(prefetcher::prefetch);
    }

    @Override
    protected void viewChanged(CDOView view, CDOBranchPoint oldBranchPoint, CDOBranchPoint newBranchPoint) {
        Prefetcher prefetcher = this.getPrefetcher(view);
        if (prefetcher != null) {
            this.schedule(prefetcher::changeBranchPoint);
        }
    }

    @Override
    protected void viewRemoved(CDOView view) {
        Prefetcher prefetcher = this.prefetchers.remove(view);
        if (prefetcher != null) {
            this.schedule(prefetcher::dispose);
        }
    }

    protected Prefetcher createPrefetcher(CDOView view) {
        return new Prefetcher(view, this.prefetchLockStates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void schedule(Runnable runnable) {
        Object object = this.lock;
        synchronized (object) {
            ++this.runnables;
        }
        this.executorService.submit(() -> this.execute(runnable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(Runnable runnable) {
        block18: {
            try {
                try {
                    runnable.run();
                }
                catch (Error ex) {
                    OM.LOG.error((Throwable)ex);
                    throw ex;
                }
                catch (Throwable ex) {
                    OM.LOG.error(ex);
                    Object object = this.lock;
                    synchronized (object) {
                        if (--this.runnables == 0) {
                            this.lock.notifyAll();
                        }
                        break block18;
                    }
                }
            }
            catch (Throwable throwable) {
                Object object = this.lock;
                synchronized (object) {
                    if (--this.runnables == 0) {
                        this.lock.notifyAll();
                    }
                }
                throw throwable;
            }
            Object object = this.lock;
            synchronized (object) {
                if (--this.runnables == 0) {
                    this.lock.notifyAll();
                }
            }
        }
    }

    public static class Prefetcher {
        private final CDOView view;
        private final CDOID rootID;
        private final Map<CDORevisionKey, CDORevision> revisions = new HashMap<CDORevisionKey, CDORevision>();
        private final InternalCDORevisionManager revisionManager;
        private final boolean prefetchLockStates;
        private final IListener cacheListener = new IListener(){

            public void notifyEvent(IEvent event) {
                if (prefetching) {
                    return;
                }
                if (event instanceof CDORevisionCache.AdditionEvent) {
                    CDOBranchPoint branchPoint;
                    CDORevisionCache.AdditionEvent e = (CDORevisionCache.AdditionEvent)event;
                    CDORevision revision = e.getRevision();
                    if (this.isValidRevision(revision, branchPoint = branchPoint)) {
                        this.notifyValidRevision(revision);
                    } else {
                        this.revisionIgnored(revision);
                    }
                }
            }
        };
        private volatile CDOBranchPoint branchPoint;
        private volatile boolean prefetching;
        private volatile boolean cancelCleanup;

        public Prefetcher(CDOView view, CDOID rootID, boolean prefetchLockStates) {
            this.view = view;
            CDOSession session = view.getSession();
            this.rootID = rootID != null ? rootID : session.getRepositoryInfo().getRootResourceID();
            this.prefetchLockStates = prefetchLockStates;
            this.revisionManager = (InternalCDORevisionManager)session.getRevisionManager();
            this.revisionManager.getCache().addListener(this.cacheListener);
            this.branchPoint = CDOBranchUtil.copyBranchPoint((CDOBranchPoint)view);
        }

        public Prefetcher(CDOView view, boolean prefetchLockStates) {
            this(view, null, prefetchLockStates);
        }

        public final CDOView getView() {
            return this.view;
        }

        public final synchronized int getSize() {
            return this.revisions.size();
        }

        public final synchronized boolean isDisposed() {
            return this.branchPoint == null;
        }

        public final synchronized void handleRevisions(CDORevisionHandler handler) {
            for (CDORevision revision : this.revisions.values()) {
                if (!handler.handleRevision(revision)) break;
            }
        }

        protected void prefetch() {
            this.cancelCleanup = true;
            try {
                this.doPrefetch();
            }
            finally {
                this.cancelCleanup = false;
            }
        }

        protected void changeBranchPoint() {
            this.doChangeBranchPoint();
        }

        protected synchronized void cleanup() {
            HashSet<Object> keysToKeep = new HashSet<Object>();
            for (Map.Entry<CDORevisionKey, CDORevision> entry : this.revisions.entrySet()) {
                if (this.cancelCleanup) break;
                CDORevision revision = entry.getValue();
                if (!this.isValidRevision(revision, this.branchPoint)) continue;
                CDORevisionKey key = entry.getKey();
                keysToKeep.add(key);
                if (this.cancelCleanup || !(revision instanceof PointerCDORevision)) continue;
                PointerCDORevision pointer = (PointerCDORevision)revision;
                CDOBranchVersion target = pointer.getTarget();
                if (target instanceof CDORevision) {
                    keysToKeep.add((CDORevision)target);
                    continue;
                }
                if (target == null) continue;
                keysToKeep.add(CDORevisionUtil.createRevisionKey((CDOID)key.getID(), (CDOBranch)target.getBranch(), (int)target.getVersion()));
            }
            Iterator<Map.Entry<CDORevisionKey, CDORevision>> it = this.revisions.entrySet().iterator();
            while (!this.cancelCleanup && it.hasNext()) {
                Map.Entry<CDORevisionKey, CDORevision> entry = it.next();
                CDORevisionKey key = entry.getKey();
                if (keysToKeep.contains(key)) continue;
                CDORevision revision = entry.getValue();
                it.remove();
                try {
                    this.revisionRemoved(revision);
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                }
            }
        }

        protected void dispose() {
            this.cancelCleanup = true;
            this.revisionManager.getCache().removeListener(this.cacheListener);
            this.doDispose();
        }

        protected CDORevision addRevision(CDORevision revision) {
            return this.revisions.put(CDORevisionUtil.copyRevisionKey((CDORevisionKey)revision), revision);
        }

        protected void revisionRemoved(CDORevision revision) {
        }

        protected void revisionIgnored(CDORevision revision) {
        }

        private boolean isValidRevision(CDORevision revision, CDOBranchPoint branchPoint) {
            return revision.isValid(branchPoint);
        }

        private void handleValidRevision(CDORevision revision) {
            PointerCDORevision pointer;
            CDOBranchVersion target;
            this.addRevision(revision);
            if (revision instanceof PointerCDORevision && (target = (pointer = (PointerCDORevision)revision).getTarget()) instanceof CDORevision) {
                this.addRevision((CDORevision)target);
            }
        }

        private synchronized void notifyValidRevision(CDORevision revision) {
            this.handleValidRevision(revision);
        }

        private synchronized void doPrefetch() {
            this.prefetching = true;
            try {
                this.revisionManager.prefetchRevisions(this.rootID, this.branchPoint, -1, this.prefetchLockStates, r -> this.handleValidRevision((CDORevision)r));
            }
            finally {
                this.prefetching = false;
            }
        }

        private synchronized void doChangeBranchPoint() {
            this.branchPoint = CDOBranchUtil.copyBranchPoint((CDOBranchPoint)this.view);
            this.prefetch();
        }

        private synchronized void doDispose() {
            this.revisions.clear();
            this.branchPoint = null;
        }
    }
}

