/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.type.core.commands;

import java.util.Collection;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.core.util.PackageUtil;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.internal.l10n.EMFTypeCoreMessages;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;

public class MoveElementsCommand
extends EditElementCommand {
    private final Map elementsToMove;
    private final EObject targetContainer;

    public MoveElementsCommand(MoveRequest request) {
        super(request.getLabel(), request.getTargetContainer(), request);
        this.elementsToMove = request.getElementsToMove();
        this.targetContainer = request.getTargetContainer();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        for (EObject element : this.getElementsToMove().keySet()) {
            EReference feature = this.getTargetFeature(element);
            if (feature != null) {
                if (FeatureMapUtil.isMany((EObject)this.targetContainer, (EStructuralFeature)feature)) {
                    ((Collection)this.targetContainer.eGet((EStructuralFeature)feature)).add(element);
                    continue;
                }
                this.targetContainer.eSet((EStructuralFeature)feature, (Object)element);
                continue;
            }
            return CommandResult.newErrorCommandResult((String)EMFTypeCoreMessages.moveElementsCommand_noTargetFeature);
        }
        return CommandResult.newOKCommandResult();
    }

    protected EReference getTargetFeature(EObject element) {
        EReference feature = (EReference)this.getElementsToMove().get(element);
        if (feature == null) {
            EReference oldContainmentFeature = element.eContainmentFeature();
            if (this.getTargetContainer().eClass().getEAllReferences().contains((Object)oldContainmentFeature)) {
                this.getElementsToMove().put(element, oldContainmentFeature);
                feature = oldContainmentFeature;
            }
        }
        if (feature == null) {
            feature = PackageUtil.findFeature((EClass)this.getTargetContainer().eClass(), (EClass)element.eClass());
            this.setTargetFeature(element, feature);
        }
        return feature;
    }

    protected EObject getTargetContainer() {
        return this.targetContainer;
    }

    protected Map getElementsToMove() {
        return this.elementsToMove;
    }

    protected void setTargetFeature(EObject element, EReference targetFeature) {
        this.getElementsToMove().put(element, targetFeature);
    }

    @Override
    public boolean canExecute() {
        EObject container = this.getTargetContainer();
        if (container == null || this.elementsToMove == null || this.elementsToMove.isEmpty()) {
            return false;
        }
        for (EObject element : this.getElementsToMove().keySet()) {
            EReference feature = this.getTargetFeature(element);
            if (feature == null || !container.eClass().getEAllReferences().contains((Object)feature)) {
                return false;
            }
            if (container.equals(element.eContainer()) && feature == element.eContainmentFeature()) {
                return false;
            }
            if (EcoreUtil.isAncestor((EObject)element, (EObject)this.getTargetContainer())) {
                return false;
            }
            if (PackageUtil.canContain((EClass)this.getTargetContainer().eClass(), (EReference)feature, (EClass)element.eClass(), (boolean)false)) continue;
            return false;
        }
        return true;
    }
}

