/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.uml.impl;

import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.operations.OperationCallExpOperations;
import org.eclipse.ocl.uml.OperationCallExp;
import org.eclipse.ocl.uml.UMLPackage;
import org.eclipse.ocl.uml.impl.FeatureCallExpImpl;
import org.eclipse.ocl.util.OCLStandardLibraryUtil;
import org.eclipse.ocl.util.TypeUtil;
import org.eclipse.ocl.utilities.PredefinedType;
import org.eclipse.ocl.utilities.Visitor;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Operation;

public class OperationCallExpImpl
extends FeatureCallExpImpl
implements OperationCallExp {
    protected EList<OCLExpression<Classifier>> argument;
    protected Operation referredOperation;
    protected static final int OPERATION_CODE_EDEFAULT = 0;
    private int operationCode = -1;

    protected OperationCallExpImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return UMLPackage.Literals.OPERATION_CALL_EXP;
    }

    public EList<OCLExpression<Classifier>> getArgument() {
        if (this.argument == null) {
            this.argument = new EObjectContainmentEList(OCLExpression.class, (InternalEObject)this, 17);
        }
        return this.argument;
    }

    public Operation getReferredOperation() {
        if (this.referredOperation != null && this.referredOperation.eIsProxy()) {
            InternalEObject oldReferredOperation = (InternalEObject)this.referredOperation;
            this.referredOperation = (Operation)this.eResolveProxy(oldReferredOperation);
            if (this.referredOperation != oldReferredOperation && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 18, (Object)oldReferredOperation, (Object)this.referredOperation));
            }
        }
        return this.referredOperation;
    }

    public Operation basicGetReferredOperation() {
        return this.referredOperation;
    }

    public void setReferredOperation(Operation newReferredOperation) {
        Operation oldReferredOperation = this.referredOperation;
        this.referredOperation = newReferredOperation;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 18, (Object)oldReferredOperation, (Object)this.referredOperation));
        }
    }

    public int getOperationCode() {
        if (this.operationCode < 0) {
            if (this.getSource() != null && this.getReferredOperation() != null) {
                Environment env = Environment.Registry.INSTANCE.getEnvironmentFor(this.getSource());
                Classifier type = (Classifier)this.getSource().getType();
                if (env != null) {
                    String operName = this.getReferredOperation().getName();
                    if (type instanceof PredefinedType) {
                        this.operationCode = OCLStandardLibraryUtil.getOperationCode((String)operName);
                    } else if (TypeUtil.isOclAnyOperation((Environment)env, (Object)this.getReferredOperation())) {
                        this.operationCode = OCLStandardLibraryUtil.getOclAnyOperationCode((String)operName);
                    }
                }
            } else {
                this.operationCode = 0;
            }
        }
        return this.operationCode;
    }

    public void setOperationCode(int newOperationCode) {
        this.operationCode = newOperationCode;
    }

    public boolean checkArgumentsConform(DiagnosticChain diagnostics, Map<Object, Object> context) {
        return OperationCallExpOperations.checkArgumentsConform((org.eclipse.ocl.expressions.OperationCallExp)this, (DiagnosticChain)diagnostics, context);
    }

    public boolean checkArgumentCount(DiagnosticChain diagnostics, Map<Object, Object> context) {
        return OperationCallExpOperations.checkArgumentCount((org.eclipse.ocl.expressions.OperationCallExp)this, (DiagnosticChain)diagnostics, context);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 17: {
                return ((InternalEList)this.getArgument()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 17: {
                return this.getArgument();
            }
            case 18: {
                if (resolve) {
                    return this.getReferredOperation();
                }
                return this.basicGetReferredOperation();
            }
            case 19: {
                return this.getOperationCode();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 17: {
                this.getArgument().clear();
                this.getArgument().addAll((Collection)newValue);
                return;
            }
            case 18: {
                this.setReferredOperation((Operation)newValue);
                return;
            }
            case 19: {
                this.setOperationCode((Integer)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 17: {
                this.getArgument().clear();
                return;
            }
            case 18: {
                this.setReferredOperation(null);
                return;
            }
            case 19: {
                this.setOperationCode(0);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 17: {
                return this.argument != null && !this.argument.isEmpty();
            }
            case 18: {
                return this.referredOperation != null;
            }
            case 19: {
                return this.getOperationCode() != 0;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == org.eclipse.ocl.expressions.OperationCallExp.class) {
            switch (derivedFeatureID) {
                case 17: {
                    return 6;
                }
                case 18: {
                    return 7;
                }
                case 19: {
                    return 8;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    @Override
    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == org.eclipse.ocl.expressions.OperationCallExp.class) {
            switch (baseFeatureID) {
                case 6: {
                    return 17;
                }
                case 7: {
                    return 18;
                }
                case 8: {
                    return 19;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    @Override
    public <T, U extends Visitor<T, ?, ?, ?, ?, ?, ?, ?, ?, ?>> T accept(U v) {
        return (T)v.visitOperationCallExp((org.eclipse.ocl.expressions.OperationCallExp)this);
    }
}

