/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.common.model;

import java.util.function.Predicate;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public final class EMFPredicates {
    public static final Predicate<EClassifier> CLASSES = new Predicate<EClassifier>(){

        @Override
        public boolean test(EClassifier classifier) {
            return classifier instanceof EClass;
        }
    };
    public static final Predicate<EClassifier> DATA_TYPES = new Predicate<EClassifier>(){

        @Override
        public boolean test(EClassifier classifier) {
            return classifier instanceof EDataType;
        }
    };
    public static final Predicate<EClassifier> ENUMS = new Predicate<EClassifier>(){

        @Override
        public boolean test(EClassifier classifier) {
            return classifier instanceof EEnum;
        }
    };
    public static final Predicate<EClassifier> CONCRETE_CLASSES = new Predicate<EClassifier>(){

        @Override
        public boolean test(EClassifier classifier) {
            return CLASSES.test(classifier) && !((EClass)classifier).isAbstract() && !((EClass)classifier).isInterface();
        }
    };
    public static final Predicate<EStructuralFeature> ATTRIBUTES = new Predicate<EStructuralFeature>(){

        @Override
        public boolean test(EStructuralFeature feature) {
            return feature instanceof EAttribute;
        }
    };
    public static final Predicate<EStructuralFeature> REFERENCES = new Predicate<EStructuralFeature>(){

        @Override
        public boolean test(EStructuralFeature feature) {
            return feature instanceof EReference;
        }
    };
    public static final Predicate<EStructuralFeature> CONTAINER_REFERENCES = new Predicate<EStructuralFeature>(){

        @Override
        public boolean test(EStructuralFeature feature) {
            if (feature instanceof EReference) {
                EReference reference = (EReference)feature;
                return reference.isContainer();
            }
            return false;
        }
    };
    public static final Predicate<EStructuralFeature> CROSS_REFERENCES = new Predicate<EStructuralFeature>(){

        @Override
        public boolean test(EStructuralFeature feature) {
            if (feature instanceof EReference) {
                EReference reference = (EReference)feature;
                return !reference.isContainer() && !reference.isContainment();
            }
            return false;
        }
    };
    public static final Predicate<EStructuralFeature> CONTAINMENT_REFERENCES = new Predicate<EStructuralFeature>(){

        @Override
        public boolean test(EStructuralFeature feature) {
            if (feature instanceof EReference) {
                EReference reference = (EReference)feature;
                return reference.isContainment();
            }
            return false;
        }
    };

    private EMFPredicates() {
    }
}

